/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.command.diagram_contents.not_element.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.insightech.er.editor.controller.command.AbstractCommand;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.Column;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.CopyColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.group.ColumnGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.CopyGroup;
import org.insightech.er.editor.model.diagram_contents.not_element.group.GroupSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeGroupCommand
extends AbstractCommand {
    private GroupSet groupSet;
    private List<CopyGroup> oldCopyGroups;
    private List<CopyGroup> newGroups;
    private Map<TableView, List<Column>> oldColumnListMap;
    private ERDiagram diagram;

    public ChangeGroupCommand(ERDiagram diagram, GroupSet groupSet, List<CopyGroup> newGroups) {
        this.diagram = diagram;
        this.groupSet = groupSet;
        this.newGroups = newGroups;
        this.oldCopyGroups = new ArrayList<CopyGroup>();
        this.oldColumnListMap = new HashMap<TableView, List<Column>>();
        for (ColumnGroup columnGroup : groupSet) {
            CopyGroup oldCopyGroup = new CopyGroup(columnGroup);
            this.oldCopyGroups.add(oldCopyGroup);
        }
    }

    @Override
    protected void doExecute() {
        ERDiagram diagram = this.diagram;
        this.groupSet.clear();
        this.oldColumnListMap.clear();
        for (CopyGroup oldCopyColumnGroup : this.oldCopyGroups) {
            for (NormalColumn column : oldCopyColumnGroup.getColumns()) {
                diagram.getDiagramContents().getDictionary().remove(((CopyColumn)column).getOriginalColumn());
            }
        }
        for (CopyGroup newCopyColumnGroup : this.newGroups) {
            this.groupSet.add(newCopyColumnGroup.restructure(diagram));
        }
        for (TableView tableView : this.diagram.getDiagramContents().getContents().getTableViewList()) {
            List<Column> columns = tableView.getColumns();
            ArrayList<Column> oldColumns = new ArrayList<Column>(columns);
            this.oldColumnListMap.put(tableView, oldColumns);
            Iterator<Column> iter = columns.iterator();
            while (iter.hasNext()) {
                Column column = iter.next();
                if (!(column instanceof ColumnGroup) || this.groupSet.contains((ColumnGroup)column)) continue;
                iter.remove();
            }
            tableView.setColumns(columns);
        }
    }

    @Override
    protected void doUndo() {
        ERDiagram diagram = this.diagram;
        this.groupSet.clear();
        for (CopyGroup newCopyColumnGroup : this.newGroups) {
            for (NormalColumn column : newCopyColumnGroup.getColumns()) {
                diagram.getDiagramContents().getDictionary().remove(((CopyColumn)column).getOriginalColumn());
            }
        }
        for (CopyGroup copyGroup : this.oldCopyGroups) {
            ColumnGroup group = copyGroup.restructure(diagram);
            this.groupSet.add(group);
        }
        for (TableView tableView : this.oldColumnListMap.keySet()) {
            List<Column> oldColumns = this.oldColumnListMap.get(tableView);
            tableView.setColumns(oldColumns);
        }
    }
}

