/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.controller.editpart.element.connection;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.editor.controller.command.diagram_contents.element.connection.relation.ChangeRelationPropertyCommand;
import org.insightech.er.editor.controller.editpart.element.connection.ERDiagramConnectionEditPart;
import org.insightech.er.editor.controller.editpolicy.element.connection.CommentConnectionEditPolicy;
import org.insightech.er.editor.controller.editpolicy.element.connection.ERDiagramBendpointEditPolicy;
import org.insightech.er.editor.model.diagram_contents.element.connection.Bendpoint;
import org.insightech.er.editor.model.diagram_contents.element.connection.ConnectionElement;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.view.dialog.element.relation.RelationDialog;
import org.insightech.er.editor.view.figure.connection.ERDiagramConnection;

public class CommentConnectionEditPart
extends ERDiagramConnectionEditPart {
    protected IFigure createFigure() {
        boolean bezier = this.getDiagram().getDiagramContents().getSettings().isUseBezierCurve();
        ERDiagramConnection connection = new ERDiagramConnection(bezier);
        connection.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        connection.setLineStyle(2);
        return connection;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new CommentConnectionEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new ERDiagramBendpointEditPolicy());
    }

    protected void refreshBendpoints() {
        ConnectionElement connection = (ConnectionElement)this.getModel();
        ArrayList<AbsoluteBendpoint> constraint = new ArrayList<AbsoluteBendpoint>();
        for (Bendpoint bendPoint : connection.getBendpoints()) {
            constraint.add(new AbsoluteBendpoint(bendPoint.getX(), bendPoint.getY()));
        }
        this.getConnectionFigure().setRoutingConstraint(constraint);
    }

    public void performRequest(Request request) {
        Relation relation = (Relation)this.getModel();
        if (request.getType().equals("open")) {
            Relation copy = relation.copy();
            RelationDialog dialog = new RelationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), copy);
            if (dialog.open() == 0) {
                ChangeRelationPropertyCommand command = new ChangeRelationPropertyCommand(relation, copy);
                this.getViewer().getEditDomain().getCommandStack().execute((Command)command);
            }
        }
        super.performRequest(request);
    }
}

