/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.dbexport.html.page_generator.HtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.OverviewHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.CategoryHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.GroupHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.IndexHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.SequenceHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.TableHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.TablespaceHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.TriggerHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.ViewHtmlReportPageGenerator;
import org.insightech.er.editor.model.dbexport.html.page_generator.impl.WordHtmlReportPageGenerator;
import org.insightech.er.editor.model.diagram_contents.element.node.Location;
import org.insightech.er.editor.model.diagram_contents.element.node.table.TableView;
import org.insightech.er.util.io.FileUtils;
import org.insightech.er.util.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportToHtmlManager {
    private static final Map PROPERTIES = ResourceString.getResources("html.report.");
    private static final String[] FIX_FILES = new String[]{"help-doc.html", "index.html", "stylesheet.css"};
    public static final String[] ICON_FILES = new String[]{"icons/pkey.gif", "icons/foreign_key.gif"};
    private static final String TEMPLATE_DIR = "html/";
    protected List<HtmlReportPageGenerator> htmlReportPageGeneratorList = new ArrayList<HtmlReportPageGenerator>();
    protected OverviewHtmlReportPageGenerator overviewPageGenerator;
    private String outputDir;
    protected ERDiagram diagram;
    private Map<TableView, Location> tableLocationMap;

    public ExportToHtmlManager(String outputDir, ERDiagram diagram, Map<TableView, Location> tableLocationMap) {
        this.outputDir = outputDir;
        this.diagram = diagram;
        this.tableLocationMap = tableLocationMap;
        HashMap<Object, Integer> idMap = new HashMap<Object, Integer>();
        this.overviewPageGenerator = new OverviewHtmlReportPageGenerator(idMap);
        this.htmlReportPageGeneratorList.add(new TableHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new IndexHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new SequenceHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new ViewHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new TriggerHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new GroupHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new TablespaceHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new WordHtmlReportPageGenerator(idMap));
        this.htmlReportPageGeneratorList.add(new CategoryHtmlReportPageGenerator(idMap));
    }

    protected void doPreTask(HtmlReportPageGenerator pageGenerator, Object object) {
    }

    protected void doPostTask() throws InterruptedException {
    }

    public void doProcess() throws IOException, InterruptedException {
        int i = 0;
        while (i < FIX_FILES.length) {
            this.copyOut(FIX_FILES[i], FIX_FILES[i]);
            ++i;
        }
        String template = null;
        String imageSrc = "image/er.png";
        String[] stringArray = ICON_FILES;
        int n = ICON_FILES.length;
        int n2 = 0;
        while (n2 < n) {
            String iconFile = stringArray[n2];
            this.copyOutResource("image/" + iconFile, iconFile);
            ++n2;
        }
        String allclasses = this.overviewPageGenerator.generateAllClasses(this.diagram, this.htmlReportPageGeneratorList);
        this.writeOut("allclasses.html", allclasses);
        String overviewFrame = this.overviewPageGenerator.generateFrame(this.htmlReportPageGeneratorList);
        this.writeOut("overview-frame.html", overviewFrame);
        String overviewSummary = this.overviewPageGenerator.generateSummary(imageSrc, this.tableLocationMap, this.htmlReportPageGeneratorList);
        this.writeOut("overview-summary.html", overviewSummary);
        int i2 = 0;
        while (i2 < this.htmlReportPageGeneratorList.size()) {
            HtmlReportPageGenerator pageGenerator = this.htmlReportPageGeneratorList.get(i2);
            try {
                HtmlReportPageGenerator prevPageGenerator = null;
                if (i2 != 0) {
                    prevPageGenerator = this.htmlReportPageGeneratorList.get(i2 - 1);
                }
                HtmlReportPageGenerator nextPageGenerator = null;
                if (i2 != this.htmlReportPageGeneratorList.size() - 1) {
                    nextPageGenerator = this.htmlReportPageGeneratorList.get(i2 + 1);
                }
                String type = pageGenerator.getType();
                template = pageGenerator.generatePackageFrame(this.diagram);
                this.writeOut(String.valueOf(type) + "/package-frame.html", template);
                template = pageGenerator.generatePackageSummary(prevPageGenerator, nextPageGenerator, this.diagram);
                this.writeOut(String.valueOf(type) + "/package-summary.html", template);
                List<Object> objectList = pageGenerator.getObjectList(this.diagram);
                int j = 0;
                while (j < objectList.size()) {
                    Object object = objectList.get(j);
                    this.doPreTask(pageGenerator, object);
                    Object prevObject = null;
                    if (j != 0) {
                        prevObject = objectList.get(j - 1);
                    }
                    Object nextObject = null;
                    if (j != objectList.size() - 1) {
                        nextObject = objectList.get(j + 1);
                    }
                    template = pageGenerator.generateContent(this.diagram, object, prevObject, nextObject);
                    String objectId = pageGenerator.getObjectId(object);
                    this.writeOut(String.valueOf(type) + "/" + objectId + ".html", template);
                    this.doPostTask();
                    ++j;
                }
            }
            catch (RuntimeException e) {
                throw new IllegalStateException(pageGenerator.getClass().getName(), e);
            }
            ++i2;
        }
    }

    public static String getTemplate(String key) throws IOException {
        InputStream in = ExportToHtmlManager.class.getClassLoader().getResourceAsStream(TEMPLATE_DIR + key);
        if (in == null) {
            throw new FileNotFoundException(TEMPLATE_DIR + key);
        }
        try {
            String content = IOUtils.toString(in);
            String string = content = ExportToHtmlManager.replaceProperties(content);
            return string;
        }
        finally {
            in.close();
        }
    }

    private void writeOut(String dstPath, String content) throws IOException {
        dstPath = String.valueOf(this.outputDir) + dstPath;
        File file = new File(dstPath);
        file.getParentFile().mkdirs();
        FileUtils.writeStringToFile(file, content, "UTF-8");
    }

    private void copyOut(String dstPath, String key) throws FileNotFoundException, IOException {
        String content = ExportToHtmlManager.getTemplate(key);
        this.writeOut(dstPath, content);
    }

    private static String replaceProperties(String content) {
        for (Object key : PROPERTIES.keySet()) {
            content = content.replaceAll(String.valueOf(key), String.valueOf(PROPERTIES.get(key)));
        }
        return content;
    }

    private void copyOutResource(String dstPath, String srcPath) throws FileNotFoundException, IOException {
        InputStream in = null;
        try {
            in = ExportToHtmlManager.class.getClassLoader().getResourceAsStream(srcPath);
            this.copyOutResource(dstPath, in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void copyOutResource(String dstPath, InputStream in) throws FileNotFoundException, IOException {
        FileOutputStream out = null;
        try {
            dstPath = String.valueOf(this.outputDir) + dstPath;
            File file = new File(dstPath);
            file.getParentFile().mkdirs();
            out = new FileOutputStream(file);
            IOUtils.copy(in, out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }
}

