/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.dbexport.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.insightech.er.editor.model.dbexport.html.page_generator.HtmlReportPageGenerator;

public class ExportToImageManager {
    protected Image img;
    private int format;
    private String saveFilePath;
    private String formatName;

    public ExportToImageManager(Image img, int format, String saveFilePath) {
        this.img = img;
        this.format = format;
        this.saveFilePath = saveFilePath;
    }

    public void doProcess() throws IOException, InterruptedException {
        if (this.format == 4 || this.format == 0) {
            this.writeJPGorBMP(this.img, this.saveFilePath, this.format);
        } else if (this.format == 5 || this.format == 2) {
            this.writePNGorGIF(this.img, this.saveFilePath, this.formatName);
        }
    }

    private void writeJPGorBMP(Image image, String saveFilePath, int format) throws IOException {
        ImageData[] imgData = new ImageData[]{image.getImageData()};
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = imgData;
        imgLoader.save(saveFilePath, format);
    }

    private void writePNGorGIF(Image image, String saveFilePath, String formatName) throws IOException, InterruptedException {
        try {
            ImageLoader loader = new ImageLoader();
            loader.data = new ImageData[]{image.getImageData()};
            loader.save(saveFilePath, this.format);
        }
        catch (SWTException e) {
            e.printStackTrace();
            BufferedImage bufferedImage = new BufferedImage(image.getBounds().width, image.getBounds().height, 1);
            this.drawAtBufferedImage(bufferedImage, image, 0, 0);
            ImageIO.write((RenderedImage)bufferedImage, formatName, new File(saveFilePath));
        }
    }

    private void drawAtBufferedImage(BufferedImage bimg, Image image, int x, int y) throws InterruptedException {
        ImageData data = image.getImageData();
        int i = 0;
        while (i < image.getBounds().width) {
            int j = 0;
            while (j < image.getBounds().height) {
                int tmp = 4 * (j * image.getBounds().width + i);
                if (data.data.length > tmp + 2) {
                    int r = 0xFF & data.data[tmp + 2];
                    int g = 0xFF & data.data[tmp + 1];
                    int b = 0xFF & data.data[tmp];
                    bimg.setRGB(i + x, j + y, 0xFF000000 | r << 16 | g << 8 | b << 0);
                }
                this.doPostTask();
                ++j;
            }
            ++i;
        }
    }

    protected void doPreTask(HtmlReportPageGenerator pageGenerator, Object object) {
    }

    protected void doPostTask() throws InterruptedException {
    }
}

