/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.element.node.model_properties;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.insightech.er.ResourceString;
import org.insightech.er.editor.model.diagram_contents.element.node.Location;
import org.insightech.er.editor.model.diagram_contents.element.node.NodeElement;
import org.insightech.er.util.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProperties
extends NodeElement
implements Cloneable {
    private static final long serialVersionUID = 5311013351131568260L;
    public static final String PROPERTY_CHANGE_MODEL_PROPERTIES = "model_properties";
    private boolean display;
    private List<NameValue> properties;
    private Date creationDate = new Date();
    private Date updatedDate = new Date();

    public ModelProperties() {
        this.setLocation(new Location(50, 50, -1, -1));
        this.properties = new ArrayList<NameValue>();
    }

    public void init() {
        this.properties.add(new NameValue(ResourceString.getResourceString("label.project.name"), ""));
        this.properties.add(new NameValue(ResourceString.getResourceString("label.model.name"), ""));
        this.properties.add(new NameValue(ResourceString.getResourceString("label.version"), ""));
        this.properties.add(new NameValue(ResourceString.getResourceString("label.company.name"), ""));
        this.properties.add(new NameValue(ResourceString.getResourceString("label.author"), ""));
    }

    public void clear() {
        this.properties.clear();
    }

    public List<NameValue> getProperties() {
        return this.properties;
    }

    public void addProperty(NameValue property) {
        this.properties.add(property);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setUpdatedDate(Date updatedDate) {
        this.updatedDate = updatedDate;
        this.firePropertyChange(PROPERTY_CHANGE_MODEL_PROPERTIES, null, null);
    }

    public boolean isDisplay() {
        return this.display;
    }

    public void setDisplay(boolean display) {
        this.display = display;
        this.firePropertyChange(PROPERTY_CHANGE_MODEL_PROPERTIES, null, null);
    }

    @Override
    public void setLocation(Location location) {
        location.width = -1;
        location.height = -1;
        super.setLocation(location);
    }

    @Override
    public ModelProperties clone() {
        ModelProperties clone = (ModelProperties)super.clone();
        ArrayList<NameValue> list = new ArrayList<NameValue>();
        for (NameValue nameValue : this.properties) {
            list.add(nameValue.clone());
        }
        clone.properties = list;
        return clone;
    }

    public void setProperties(List<NameValue> properties) {
        this.properties = properties;
        this.firePropertyChange(PROPERTY_CHANGE_MODEL_PROPERTIES, null, null);
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getObjectType() {
        return PROPERTY_CHANGE_MODEL_PROPERTIES;
    }
}

