/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.diagram_contents.element.node.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.insightech.er.ResourceString;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.model.AbstractModel;
import org.insightech.er.editor.model.ObjectListModel;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSet
extends AbstractModel
implements ObjectListModel,
Iterable<ERTable> {
    private static final long serialVersionUID = 5264397678674390103L;
    public static final String PROPERTY_CHANGE_TABLE_SET = "TableSet";
    private List<ERTable> tableList = new ArrayList<ERTable>();

    public void add(ERTable table) {
        this.tableList.add(table);
        this.firePropertyChange(PROPERTY_CHANGE_TABLE_SET, null, null);
    }

    public int remove(ERTable table) {
        int index = this.tableList.indexOf(table);
        this.tableList.remove(index);
        this.firePropertyChange(PROPERTY_CHANGE_TABLE_SET, null, null);
        return index;
    }

    public void setDirty() {
        this.firePropertyChange(PROPERTY_CHANGE_TABLE_SET, null, null);
    }

    public List<ERTable> getList() {
        Collections.sort(this.tableList);
        return this.tableList;
    }

    @Override
    public Iterator<ERTable> iterator() {
        Collections.sort(this.tableList);
        return this.tableList.iterator();
    }

    @Override
    public TableSet clone() {
        TableSet tableSet = (TableSet)super.clone();
        ArrayList<ERTable> newTableList = new ArrayList<ERTable>();
        for (ERTable table : this.tableList) {
            ERTable newTable = table.clone();
            newTableList.add(newTable);
        }
        tableSet.tableList = newTableList;
        return tableSet;
    }

    public List<String> getAutoSequenceNames(String database) {
        ArrayList<String> autoSequenceNames = new ArrayList<String>();
        for (ERTable table : this.tableList) {
            String prefix = String.valueOf(table.getNameWithSchema(database)) + "_";
            for (NormalColumn column : table.getNormalColumns()) {
                SqlType sqlType = column.getType();
                if (!SqlType.valueOfId("serial").equals(sqlType) && !SqlType.valueOfId("bigserial").equals(sqlType)) continue;
                autoSequenceNames.add((String.valueOf(prefix) + column.getPhysicalName() + "_seq").toUpperCase());
            }
        }
        return autoSequenceNames;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getName() {
        return ResourceString.getResourceString("label.object.type.table_list");
    }

    @Override
    public String getObjectType() {
        return "list";
    }
}

