/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.model.settings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.insightech.er.editor.model.diagram_contents.element.node.category.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorySetting
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7691417386790834828L;
    private List<Category> allCategories = new ArrayList<Category>();
    private List<Category> selectedCategories = new ArrayList<Category>();
    private boolean freeLayout;
    private boolean showReferredTables;

    public boolean isFreeLayout() {
        return this.freeLayout;
    }

    public void setFreeLayout(boolean freeLayout) {
        this.freeLayout = freeLayout;
    }

    public boolean isShowReferredTables() {
        return this.showReferredTables;
    }

    public void setShowReferredTables(boolean showReferredTables) {
        this.showReferredTables = showReferredTables;
    }

    public void setSelectedCategories(List<Category> selectedCategories) {
        this.selectedCategories = selectedCategories;
    }

    public boolean contains(String categoryName) {
        for (Category category : this.selectedCategories) {
            if (!category.getName().equals(categoryName)) continue;
            return true;
        }
        return false;
    }

    public List<Category> getAllCategories() {
        return this.allCategories;
    }

    public void addCategory(Category category) {
        this.allCategories.add(category);
        Collections.sort(this.allCategories);
    }

    public void addCategoryAsSelected(Category category) {
        this.addCategory(category);
        this.selectedCategories.add(category);
    }

    public void removeCategory(Category category) {
        this.allCategories.remove(category);
        this.selectedCategories.remove(category);
    }

    public void removeCategory(int index) {
        this.allCategories.remove(index);
    }

    public boolean isSelected(Category tableCategory) {
        return this.selectedCategories.contains(tableCategory);
    }

    public List<Category> getSelectedCategories() {
        return this.selectedCategories;
    }

    public Object clone() {
        try {
            CategorySetting settings = (CategorySetting)super.clone();
            settings.allCategories = new ArrayList<Category>();
            settings.selectedCategories = new ArrayList<Category>();
            for (Category category : this.allCategories) {
                Category clone = category.clone();
                settings.allCategories.add(clone);
                if (!this.contains(category.getName())) continue;
                settings.selectedCategories.add(clone);
            }
            return settings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void setAllCategories(List<Category> allCategories) {
        this.allCategories = allCategories;
        Collections.sort(this.allCategories);
    }
}

