/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.insightech.er.Activator;
import org.insightech.er.editor.ERDiagramEditor;
import org.insightech.er.editor.model.ERDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBaseSelectionAction
extends SelectionAction {
    private ERDiagramEditor editor;

    public AbstractBaseSelectionAction(String id, String text, ERDiagramEditor editor) {
        this(id, text, 0, editor);
    }

    public AbstractBaseSelectionAction(String id, String text, int style, ERDiagramEditor editor) {
        super((IWorkbenchPart)editor, style);
        this.setId(id);
        this.setText(text);
        this.editor = editor;
    }

    protected ERDiagram getDiagram() {
        EditPart editPart = this.editor.getGraphicalViewer().getContents();
        ERDiagram diagram = (ERDiagram)editPart.getModel();
        return diagram;
    }

    protected GraphicalViewer getGraphicalViewer() {
        return this.editor.getGraphicalViewer();
    }

    public final void runWithEvent(Event event) {
        try {
            this.execute(event);
        }
        catch (Exception e) {
            Activator.showExceptionDialog(e);
        }
    }

    protected void execute(Command command) {
        this.editor.getGraphicalViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected IEditorPart getEditorPart() {
        return this.editor;
    }

    protected void execute(Event event) {
        GraphicalViewer viewer = this.getGraphicalViewer();
        ArrayList<Command> commandList = new ArrayList<Command>();
        for (Object object : viewer.getSelectedEditParts()) {
            List<Command> subCommandList = this.getCommand((EditPart)object, event);
            commandList.addAll(subCommandList);
        }
        if (!commandList.isEmpty()) {
            CompoundCommand compoundCommand = new CompoundCommand();
            for (Command command : commandList) {
                compoundCommand.add(command);
            }
            this.execute((Command)compoundCommand);
        }
    }

    protected abstract List<Command> getCommand(EditPart var1, Event var2);

    protected boolean calculateEnabled() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        return !viewer.getSelectedEditParts().isEmpty();
    }
}

