/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.action.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.AlignmentRequest;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.insightech.er.Activator;
import org.insightech.er.editor.controller.editpart.element.node.column.NormalColumnEditPart;

public class ERDiagramAlignmentAction
extends SelectionAction {
    public static final String ID_ALIGN_BOTTOM = "org.eclipse.gef.align_bottom";
    public static final String ID_ALIGN_CENTER = "org.eclipse.gef.align_center";
    public static final String ID_ALIGN_LEFT = "org.eclipse.gef.align_left";
    public static final String ID_ALIGN_MIDDLE = "org.eclipse.gef.align_middle";
    public static final String ID_ALIGN_RIGHT = "org.eclipse.gef.align_right";
    public static final String ID_ALIGN_TOP = "org.eclipse.gef.align_top";
    private int alignment;
    private List operationSet;
    private static final AlignmentAction ALIGNMENT_ACTION_LEFT = new AlignmentAction(null, 1);
    private static final AlignmentAction ALIGNMENT_ACTION_RIGHT = new AlignmentAction(null, 4);
    private static final AlignmentAction ALIGNMENT_ACTION_TOP = new AlignmentAction(null, 8);
    private static final AlignmentAction ALIGNMENT_ACTION_BOTTOM = new AlignmentAction(null, 32);
    private static final AlignmentAction ALIGNMENT_ACTION_CENTER = new AlignmentAction(null, 2);
    private static final AlignmentAction ALIGNMENT_ACTION_MIDDLE = new AlignmentAction(null, 16);

    public ERDiagramAlignmentAction(IWorkbenchPart part, int align) {
        super(part);
        this.alignment = align;
        this.initUI();
    }

    protected Rectangle calculateAlignmentRectangle(Request request) {
        List editparts = this.getOperationSet(request);
        if (editparts == null || editparts.isEmpty()) {
            return null;
        }
        GraphicalEditPart part = (GraphicalEditPart)editparts.get(editparts.size() - 1);
        PrecisionRectangle rect = new PrecisionRectangle(part.getFigure().getBounds());
        part.getFigure().translateToAbsolute((Translatable)rect);
        return rect;
    }

    protected boolean calculateEnabled() {
        this.operationSet = null;
        Command cmd = this.createAlignmentCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    private Command createAlignmentCommand() {
        AlignmentRequest request = new AlignmentRequest((Object)"align");
        request.setAlignmentRectangle(this.calculateAlignmentRectangle((Request)request));
        request.setAlignment(this.alignment);
        List editparts = this.getOperationSet((Request)request);
        if (editparts.size() < 2) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart editpart = (EditPart)editparts.get(i);
            command.add(editpart.getCommand((Request)request));
            ++i;
        }
        return command;
    }

    public void dispose() {
        this.operationSet = Collections.EMPTY_LIST;
        super.dispose();
    }

    protected List getOperationSet(Request request) {
        if (this.operationSet != null) {
            return this.operationSet;
        }
        List editparts = new ArrayList(this.getSelectedObjects());
        Iterator iter = editparts.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof NormalColumnEditPart)) continue;
            iter.remove();
        }
        if (editparts.isEmpty() || !(editparts.get(0) instanceof GraphicalEditPart)) {
            return Collections.EMPTY_LIST;
        }
        Object primary = editparts.get(editparts.size() - 1);
        editparts = ToolUtilities.getSelectionWithoutDependants(editparts);
        ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)request);
        if (editparts.size() < 2 || !editparts.contains(primary)) {
            return Collections.EMPTY_LIST;
        }
        EditPart parent = ((EditPart)editparts.get(0)).getParent();
        int i = 1;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            if (part.getParent() != parent) {
                return Collections.EMPTY_LIST;
            }
            ++i;
        }
        return editparts;
    }

    protected void initUI() {
        switch (this.alignment) {
            case 1: {
                this.setId(ID_ALIGN_LEFT);
                this.setText(ALIGNMENT_ACTION_LEFT.getText());
                this.setToolTipText(ALIGNMENT_ACTION_LEFT.getToolTipText());
                this.setImageDescriptor(Activator.getImageDescriptor("ALIGN_LEFT"));
                break;
            }
            case 4: {
                this.setId(ID_ALIGN_RIGHT);
                this.setText(ALIGNMENT_ACTION_RIGHT.getText());
                this.setToolTipText(ALIGNMENT_ACTION_RIGHT.getToolTipText());
                this.setImageDescriptor(Activator.getImageDescriptor("ALIGN_RIGHT"));
                break;
            }
            case 8: {
                this.setId(ID_ALIGN_TOP);
                this.setText(ALIGNMENT_ACTION_TOP.getText());
                this.setToolTipText(ALIGNMENT_ACTION_TOP.getToolTipText());
                this.setImageDescriptor(Activator.getImageDescriptor("ALIGN_TOP"));
                break;
            }
            case 32: {
                this.setId(ID_ALIGN_BOTTOM);
                this.setText(ALIGNMENT_ACTION_BOTTOM.getText());
                this.setToolTipText(ALIGNMENT_ACTION_BOTTOM.getToolTipText());
                this.setImageDescriptor(Activator.getImageDescriptor("ALIGN_BOTTOM"));
                break;
            }
            case 2: {
                this.setId(ID_ALIGN_CENTER);
                this.setText(ALIGNMENT_ACTION_CENTER.getText());
                this.setToolTipText(ALIGNMENT_ACTION_CENTER.getToolTipText());
                this.setImageDescriptor(Activator.getImageDescriptor("ALIGN_CENTER"));
                break;
            }
            case 16: {
                this.setId(ID_ALIGN_MIDDLE);
                this.setText(ALIGNMENT_ACTION_MIDDLE.getText());
                this.setToolTipText(ALIGNMENT_ACTION_MIDDLE.getToolTipText());
                this.setImageDescriptor(Activator.getImageDescriptor("ALIGN_MIDDLE"));
            }
        }
    }

    public void run() {
        this.operationSet = null;
        this.execute(this.createAlignmentCommand());
    }
}

