/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.dbimport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.StringObjectModel;
import org.insightech.er.editor.model.dbimport.DBObject;
import org.insightech.er.editor.model.dbimport.DBObjectSet;
import org.insightech.er.editor.view.dialog.dbimport.ViewLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSelectImportedObjectDialog
extends AbstractDialog {
    private ContainerCheckedTreeViewer viewer;
    protected Button useCommentAsLogicalNameButton;
    private Button mergeWordButton;
    private Button mergeGroupButton;
    protected DBObjectSet dbObjectSet;
    protected boolean resultUseCommentAsLogicalName;
    private boolean resultMergeWord;
    private boolean resultMergeGroup;
    private List<DBObject> resultSelectedDbObjects;

    public AbstractSelectImportedObjectDialog(Shell parentShell, ERDiagram diagram, DBObjectSet dbObjectSet) {
        super(parentShell);
        this.dbObjectSet = dbObjectSet;
    }

    @Override
    protected void initialize(Composite composite) {
        this.createObjectListComposite(composite);
        this.setListener();
    }

    private void createObjectListComposite(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 20;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)gridData);
        this.createAllObjectGroup(composite);
        GridData groupGridData = new GridData();
        groupGridData.horizontalAlignment = 4;
        groupGridData.grabExcessHorizontalSpace = true;
        groupGridData.horizontalSpan = 3;
        GridLayout groupLayout = new GridLayout();
        groupLayout.marginWidth = 15;
        groupLayout.marginHeight = 15;
        Group group = new Group(composite, 0);
        group.setText(ResourceString.getResourceString("label.option"));
        group.setLayoutData((Object)groupGridData);
        group.setLayout((Layout)groupLayout);
        this.initializeOptionGroup(group);
    }

    protected void initializeOptionGroup(Group group) {
        this.mergeWordButton = CompositeFactory.createCheckbox(this, (Composite)group, "label.merge.word");
        this.mergeWordButton.setSelection(true);
        this.mergeGroupButton = CompositeFactory.createCheckbox(this, (Composite)group, "label.merge.group");
        this.mergeGroupButton.setSelection(true);
    }

    private void createAllObjectGroup(Composite composite) {
        GridData gridData = new GridData();
        gridData.heightHint = 300;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.viewer = new ContainerCheckedTreeViewer(composite, 2818);
        Tree tree = this.viewer.getTree();
        tree.setLayoutData((Object)gridData);
        this.viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
    }

    private void setListener() {
        this.viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                AbstractSelectImportedObjectDialog.this.validate();
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    protected void perfomeOK() throws InputException {
        Object[] selectedNodes = this.viewer.getCheckedElements();
        this.resultSelectedDbObjects = new ArrayList<DBObject>();
        int i = 0;
        while (i < selectedNodes.length) {
            Object value = ((TreeNode)selectedNodes[i]).getValue();
            if (value instanceof DBObject) {
                this.resultSelectedDbObjects.add((DBObject)value);
            }
            ++i;
        }
        this.resultMergeWord = this.mergeWordButton.getSelection();
        this.resultMergeGroup = this.mergeGroupButton.getSelection();
    }

    @Override
    protected String getErrorMessage() {
        if (this.viewer.getCheckedElements().length == 0) {
            return "error.import.object.empty";
        }
        return null;
    }

    @Override
    protected String getTitle() {
        return "dialog.title.select.import.object";
    }

    @Override
    protected void setData() {
        List<TreeNode> treeNodeList = this.createTreeNodeList();
        Object[] treeNodes = treeNodeList.toArray(new TreeNode[treeNodeList.size()]);
        this.viewer.setInput((Object)treeNodes);
        this.viewer.setCheckedElements(treeNodes);
        this.viewer.expandAll();
    }

    protected List<TreeNode> createTreeNodeList() {
        ArrayList<TreeNode> treeNodeList = new ArrayList<TreeNode>();
        TreeNode topNode = new TreeNode((Object)new StringObjectModel(ResourceString.getResourceString("label.schema")));
        treeNodeList.add(topNode);
        ArrayList<TreeNode> schemaNodeList = new ArrayList<TreeNode>();
        for (Map.Entry<String, List<DBObject>> entry : this.dbObjectSet.getSchemaDbObjectListMap().entrySet()) {
            String schemaName = entry.getKey();
            if ("".equals(schemaName)) {
                schemaName = ResourceString.getResourceString("label.none");
            }
            TreeNode schemaNode = new TreeNode((Object)new StringObjectModel(schemaName));
            schemaNode.setParent(topNode);
            schemaNodeList.add(schemaNode);
            List<DBObject> dbObjectList = entry.getValue();
            TreeNode[] objectTypeNodes = new TreeNode[DBObject.ALL_TYPES.length];
            int i = 0;
            while (i < DBObject.ALL_TYPES.length) {
                objectTypeNodes[i] = new TreeNode((Object)new StringObjectModel(ResourceString.getResourceString("label.object.type." + DBObject.ALL_TYPES[i])));
                ArrayList<TreeNode> objectNodeList = new ArrayList<TreeNode>();
                for (DBObject dbObject : dbObjectList) {
                    if (!DBObject.ALL_TYPES[i].equals(dbObject.getType())) continue;
                    TreeNode objectNode = new TreeNode((Object)dbObject);
                    objectNode.setParent(objectTypeNodes[i]);
                    objectNodeList.add(objectNode);
                }
                objectTypeNodes[i].setChildren(objectNodeList.toArray(new TreeNode[objectNodeList.size()]));
                ++i;
            }
            schemaNode.setChildren(objectTypeNodes);
        }
        topNode.setChildren(schemaNodeList.toArray(new TreeNode[schemaNodeList.size()]));
        topNode = this.createTopNode("tablespace", this.dbObjectSet.getTablespaceList());
        treeNodeList.add(topNode);
        return treeNodeList;
    }

    protected TreeNode createTopNode(String objectType, List<DBObject> dbObjectList) {
        TreeNode treeNode = new TreeNode((Object)new StringObjectModel(ResourceString.getResourceString("label.object.type." + objectType)));
        ArrayList<TreeNode> objectNodeList = new ArrayList<TreeNode>();
        for (DBObject dbObject : dbObjectList) {
            TreeNode objectNode = new TreeNode((Object)dbObject);
            objectNode.setParent(treeNode);
            objectNodeList.add(objectNode);
        }
        treeNode.setChildren(objectNodeList.toArray(new TreeNode[objectNodeList.size()]));
        return treeNode;
    }

    public boolean isUseCommentAsLogicalName() {
        return this.resultUseCommentAsLogicalName;
    }

    public boolean isMergeWord() {
        return this.resultMergeWord;
    }

    public boolean isMergeGroup() {
        return this.resultMergeGroup;
    }

    public List<DBObject> getSelectedDbObjects() {
        return this.resultSelectedDbObjects;
    }
}

