/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.element.relation;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.editor.model.diagram_contents.element.connection.Relation;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.unique_key.ComplexUniqueKey;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

public class RelationDialog
extends AbstractDialog {
    private Relation relation;
    private Text nameText;
    private Text parentTableNameText;
    private Combo columnCombo;
    private Combo parentCardinalityCombo;
    private Combo childCardinalityCombo;
    private Combo onUpdateCombo;
    private Combo onDeleteCombo;
    private ColumnComboInfo columnComboInfo;

    public RelationDialog(Shell parentShell, Relation relation) {
        super(parentShell, 2);
        this.relation = relation;
    }

    protected void initialize(Composite composite) {
        CompositeFactory.createLabel(composite, "label.constraint.name", 2);
        this.nameText = CompositeFactory.createText(this, composite, null, 2, false);
        this.createMethodGroup(composite);
        int size = this.createParentGroup(composite);
        this.createChildGroup(composite, size);
    }

    private void createMethodGroup(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        group.setText(ResourceString.getResourceString("label.reference.operation"));
        Label label1 = new Label((Composite)group, 0);
        label1.setText("ON UPDATE");
        this.createOnUpdateCombo(group);
        Label label2 = new Label((Composite)group, 0);
        label2.setText("ON DELETE");
        this.createOnDeleteCombo(group);
    }

    private void createOnUpdateCombo(Group group) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.onUpdateCombo = new Combo((Composite)group, 0);
        this.onUpdateCombo.setLayoutData((Object)gridData);
        this.onUpdateCombo.add("RESTRICT");
        this.onUpdateCombo.add("CASCADE");
        this.onUpdateCombo.add("NO ACTION");
        this.onUpdateCombo.add("SET NULL");
        this.onUpdateCombo.add("SET DEFAULT");
    }

    private void createOnDeleteCombo(Group group) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.onDeleteCombo = new Combo((Composite)group, 0);
        this.onDeleteCombo.setLayoutData((Object)gridData);
        this.onDeleteCombo.add("RESTRICT");
        this.onDeleteCombo.add("CASCADE");
        this.onDeleteCombo.add("NO ACTION");
        this.onDeleteCombo.add("SET NULL");
        this.onDeleteCombo.add("SET DEFAULT");
    }

    private int createParentGroup(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        group.setText(ResourceString.getResourceString("label.parent"));
        Composite upperComposite = new Composite((Composite)group, 0);
        upperComposite.setLayoutData((Object)gridData);
        upperComposite.setLayout((Layout)gridLayout);
        Label label1 = new Label(upperComposite, 0);
        label1.setText(ResourceString.getResourceString("label.reference.table"));
        this.parentTableNameText = new Text(upperComposite, 2056);
        this.parentTableNameText.setLayoutData((Object)gridData);
        Label label2 = new Label(upperComposite, 0);
        label2.setText(ResourceString.getResourceString("label.reference.column"));
        this.createColumnCombo(upperComposite);
        this.createParentMandatoryGroup(group);
        upperComposite.pack();
        return upperComposite.getSize().y;
    }

    private void createChildGroup(Composite composite, int size) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.verticalSpacing = 10;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Group group = new Group(composite, 0);
        group.setLayoutData((Object)gridData);
        group.setLayout((Layout)gridLayout);
        group.setText(ResourceString.getResourceString("label.child"));
        Label filler = new Label((Composite)group, 0);
        filler.setText("");
        GridData fillerGridData = new GridData();
        fillerGridData.heightHint = size;
        filler.setLayoutData((Object)fillerGridData);
        this.createChildMandatoryGroup(group);
    }

    private void createColumnCombo(Composite parent) {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.columnCombo = new Combo(parent, 8);
        this.columnCombo.setLayoutData((Object)gridData);
        this.columnCombo.setVisibleItemCount(20);
        this.columnComboInfo = RelationDialog.setReferencedColumnComboData(this.columnCombo, (ERTable)this.relation.getSourceTableView());
    }

    public static ColumnComboInfo setReferencedColumnComboData(Combo columnCombo, ERTable table) {
        ColumnComboInfo info = new ColumnComboInfo();
        int primaryKeySize = table.getPrimaryKeySize();
        if (primaryKeySize != 0) {
            columnCombo.add("PRIMARY KEY");
            info.complexUniqueKeyStartIndex = 1;
            info.candidatePK = true;
        } else {
            info.complexUniqueKeyStartIndex = 0;
            info.candidatePK = false;
        }
        for (ComplexUniqueKey complexUniqueKey : table.getComplexUniqueKeyList()) {
            columnCombo.add(complexUniqueKey.getLabel());
        }
        info.columnStartIndex = info.complexUniqueKeyStartIndex + table.getComplexUniqueKeyList().size();
        for (NormalColumn column : table.getNormalColumns()) {
            if (!column.isUniqueKey()) continue;
            columnCombo.add(column.getLogicalName());
            info.candidateColumns.add(column);
        }
        return info;
    }

    private void createParentMandatoryGroup(Group parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        Group group = new Group((Composite)parent, 0);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setText(ResourceString.getResourceString("label.mandatory"));
        this.parentCardinalityCombo = new Combo((Composite)group, 0);
        this.parentCardinalityCombo.setLayoutData((Object)gridData);
        this.parentCardinalityCombo.setVisibleItemCount(5);
        this.parentCardinalityCombo.add("1");
        this.parentCardinalityCombo.add("0..1");
    }

    private void createChildMandatoryGroup(Group parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Group group = new Group((Composite)parent, 0);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        group.setText(ResourceString.getResourceString("label.mandatory"));
        this.childCardinalityCombo = new Combo((Composite)group, 0);
        this.childCardinalityCombo.setLayoutData((Object)gridData);
        this.childCardinalityCombo.setVisibleItemCount(5);
        this.childCardinalityCombo.add("1..n");
        this.childCardinalityCombo.add("0..n");
        this.childCardinalityCombo.add("1");
        this.childCardinalityCombo.add("0..1");
    }

    protected void setData() {
        ERTable sourceTable = (ERTable)this.relation.getSourceTableView();
        this.nameText.setText(Format.null2blank(this.relation.getName()));
        if (this.relation.getOnUpdateAction() != null) {
            this.onUpdateCombo.setText(this.relation.getOnUpdateAction());
        }
        if (this.relation.getOnDeleteAction() != null) {
            this.onDeleteCombo.setText(this.relation.getOnDeleteAction());
        }
        if (!Check.isEmpty(this.relation.getParentCardinality())) {
            this.parentCardinalityCombo.setText(this.relation.getParentCardinality());
        } else {
            this.parentCardinalityCombo.select(0);
        }
        if (!Check.isEmpty(this.relation.getChildCardinality())) {
            this.childCardinalityCombo.setText(this.relation.getChildCardinality());
        } else {
            this.childCardinalityCombo.select(0);
        }
        if (this.relation.isReferenceForPK()) {
            this.columnCombo.select(0);
        } else if (this.relation.getReferencedComplexUniqueKey() != null) {
            int i = 0;
            while (i < sourceTable.getComplexUniqueKeyList().size()) {
                if (sourceTable.getComplexUniqueKeyList().get(i) == this.relation.getReferencedComplexUniqueKey()) {
                    this.columnCombo.select(i + this.columnComboInfo.complexUniqueKeyStartIndex);
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.columnComboInfo.candidateColumns.size()) {
                if (this.columnComboInfo.candidateColumns.get(i) == this.relation.getReferencedColumn()) {
                    this.columnCombo.select(i + this.columnComboInfo.columnStartIndex);
                    break;
                }
                ++i;
            }
        }
        if (this.relation.isReferedStrictly()) {
            this.columnCombo.setEnabled(false);
        }
        this.parentTableNameText.setText(this.relation.getSourceTableView().getLogicalName());
    }

    protected void perfomeOK() {
        this.relation.setName(this.nameText.getText());
        this.relation.setOnDeleteAction(this.onDeleteCombo.getText());
        this.relation.setOnUpdateAction(this.onUpdateCombo.getText());
        this.relation.setChildCardinality(this.childCardinalityCombo.getText());
        this.relation.setParentCardinality(this.parentCardinalityCombo.getText());
        int index = this.columnCombo.getSelectionIndex();
        if (index < this.columnComboInfo.complexUniqueKeyStartIndex) {
            this.relation.setReferenceForPK(true);
            this.relation.setReferencedComplexUniqueKey(null);
            this.relation.setReferencedColumn(null);
        } else if (index < this.columnComboInfo.columnStartIndex) {
            ComplexUniqueKey complexUniqueKey = ((ERTable)this.relation.getSourceTableView()).getComplexUniqueKeyList().get(index - this.columnComboInfo.complexUniqueKeyStartIndex);
            this.relation.setReferenceForPK(false);
            this.relation.setReferencedComplexUniqueKey(complexUniqueKey);
            this.relation.setReferencedColumn(null);
        } else {
            NormalColumn sourceColumn = this.columnComboInfo.candidateColumns.get(index - this.columnComboInfo.columnStartIndex);
            this.relation.setReferenceForPK(false);
            this.relation.setReferencedComplexUniqueKey(null);
            this.relation.setReferencedColumn(sourceColumn);
        }
    }

    protected String getErrorMessage() {
        String text = this.nameText.getText().trim();
        if (!Check.isAlphabet(text)) {
            return "error.constraint.name.not.alphabet";
        }
        return null;
    }

    protected String getTitle() {
        return "dialog.title.relation";
    }

    public static class ColumnComboInfo {
        public List<NormalColumn> candidateColumns = new ArrayList<NormalColumn>();
        public int complexUniqueKeyStartIndex;
        public int columnStartIndex;
        public boolean candidatePK;
    }
}

