/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.printer;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.insightech.er.Activator;
import org.insightech.er.ResourceString;
import org.insightech.er.common.dialog.AbstractDialog;
import org.insightech.er.common.exception.InputException;
import org.insightech.er.editor.model.ERDiagram;
import org.insightech.er.editor.model.settings.PageSetting;

public class PageSettingDialog
extends AbstractDialog {
    private PageSetting pageSetting;
    private Button vButton;
    private Button hButton;
    private Spinner scaleSpinner;
    private Combo sizeCombo;
    private Spinner topMarginSpinner;
    private Spinner rightMarginSpinner;
    private Spinner bottomMarginSpinner;
    private Spinner leftMarginSpinner;
    private ERDiagram diagram;

    public PageSettingDialog(Shell parentShell, ERDiagram diagram) {
        super(parentShell, 1);
        this.pageSetting = diagram.getPageSetting();
        this.diagram = diagram;
    }

    protected void createErrorComposite(Composite parent) {
    }

    protected void initialize(Composite parent) {
        parent.setBackground(ColorConstants.white);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        parent.setLayout((Layout)layout);
        this.initDirectionGroup(parent);
        this.initScaleGroup(parent);
        this.initSizeGroup(parent);
    }

    private void initDirectionGroup(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Group directionGroup = new Group(parent, 0);
        directionGroup.setLayoutData((Object)gridData);
        directionGroup.setBackground(ColorConstants.white);
        directionGroup.setText(ResourceString.getResourceString("label.page.direction"));
        GridLayout directionGroupLayout = new GridLayout();
        directionGroupLayout.marginWidth = 20;
        directionGroupLayout.horizontalSpacing = 20;
        directionGroupLayout.numColumns = 4;
        directionGroup.setLayout((Layout)directionGroupLayout);
        Label vImage = new Label((Composite)directionGroup, 0);
        vImage.setImage(Activator.getImage("PAGE_SETTING_V"));
        this.vButton = new Button((Composite)directionGroup, 16);
        this.vButton.setBackground(ColorConstants.white);
        this.vButton.setText(ResourceString.getResourceString("label.page.direction.v"));
        Label hImage = new Label((Composite)directionGroup, 0);
        hImage.setImage(Activator.getImage("PAGE_SETTING_H"));
        this.hButton = new Button((Composite)directionGroup, 16);
        this.hButton.setBackground(ColorConstants.white);
        this.hButton.setText(ResourceString.getResourceString("label.page.direction.h"));
    }

    private void initScaleGroup(Composite parent) {
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        Group scaleGroup = new Group(parent, 0);
        scaleGroup.setLayoutData((Object)gridData);
        scaleGroup.setBackground(ColorConstants.white);
        scaleGroup.setText(ResourceString.getResourceString("label.page.scale.printing"));
        GridLayout scaleGroupLayout = new GridLayout();
        scaleGroupLayout.marginWidth = 20;
        scaleGroupLayout.horizontalSpacing = 20;
        scaleGroupLayout.numColumns = 3;
        scaleGroup.setLayout((Layout)scaleGroupLayout);
        Label label = new Label((Composite)scaleGroup, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.scale"));
        this.scaleSpinner = new Spinner((Composite)scaleGroup, 2048);
        this.scaleSpinner.setIncrement(5);
        this.scaleSpinner.setMinimum(10);
        this.scaleSpinner.setMaximum(400);
        this.scaleSpinner.setSelection(100);
        label = new Label((Composite)scaleGroup, 0);
        label.setBackground(ColorConstants.white);
        label.setText("%");
    }

    private void initSizeGroup(Composite parent) {
        GridData sizeGroupGridData = new GridData();
        sizeGroupGridData.grabExcessHorizontalSpace = true;
        sizeGroupGridData.horizontalAlignment = 4;
        Group sizeGroup = new Group(parent, 0);
        sizeGroup.setLayoutData((Object)sizeGroupGridData);
        sizeGroup.setBackground(ColorConstants.white);
        GridLayout sizeGroupLayout = new GridLayout();
        sizeGroupLayout.marginWidth = 20;
        sizeGroupLayout.horizontalSpacing = 20;
        sizeGroupLayout.numColumns = 2;
        sizeGroup.setLayout((Layout)sizeGroupLayout);
        Label label = new Label((Composite)sizeGroup, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.size"));
        this.sizeCombo = new Combo((Composite)sizeGroup, 2056);
        this.sizeCombo.setBackground(ColorConstants.white);
        this.setPaperSize(this.sizeCombo);
        label = new Label((Composite)sizeGroup, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.margin"));
        Composite marginComposite = new Composite((Composite)sizeGroup, 0);
        marginComposite.setBackground(ColorConstants.white);
        GridLayout marginCompositeLayout = new GridLayout();
        marginCompositeLayout.marginWidth = 10;
        marginCompositeLayout.horizontalSpacing = 10;
        marginCompositeLayout.numColumns = 6;
        marginComposite.setLayout((Layout)marginCompositeLayout);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.margin.top"));
        this.topMarginSpinner = new Spinner(marginComposite, 2048);
        this.setMarginSpinner(this.topMarginSpinner);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.margin.left"));
        this.leftMarginSpinner = new Spinner(marginComposite, 2048);
        this.setMarginSpinner(this.leftMarginSpinner);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.margin.right"));
        this.rightMarginSpinner = new Spinner(marginComposite, 2048);
        this.setMarginSpinner(this.rightMarginSpinner);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
        label.setBackground(ColorConstants.white);
        label.setText(ResourceString.getResourceString("label.page.margin.bottom"));
        this.bottomMarginSpinner = new Spinner(marginComposite, 2048);
        this.setMarginSpinner(this.bottomMarginSpinner);
        label = new Label(marginComposite, 0);
        label = new Label(marginComposite, 0);
    }

    private void setMarginSpinner(Spinner spinner) {
        spinner.setDigits(1);
        spinner.setIncrement(5);
        spinner.setMinimum(0);
        spinner.setMaximum(1000);
        spinner.setSelection(20);
    }

    private void setPaperSize(Combo combo) {
        for (String paperSize : PageSetting.getAllPaperSize()) {
            combo.add(paperSize);
        }
        combo.select(0);
    }

    protected String getTitle() {
        return "dialog.title.page.setting";
    }

    protected void perfomeOK() throws InputException {
        this.pageSetting = new PageSetting(this.hButton.getSelection(), this.scaleSpinner.getSelection(), this.sizeCombo.getText(), this.topMarginSpinner.getSelection(), this.rightMarginSpinner.getSelection(), this.bottomMarginSpinner.getSelection(), this.leftMarginSpinner.getSelection());
        this.diagram.setPageSetting(this.pageSetting);
    }

    protected void setData() {
        if (this.pageSetting.isDirectionHorizontal()) {
            this.hButton.setSelection(true);
        } else {
            this.vButton.setSelection(true);
        }
        this.scaleSpinner.setSelection(this.pageSetting.getScale());
        this.sizeCombo.setText(this.pageSetting.getPaperSize());
        this.topMarginSpinner.setSelection(this.pageSetting.getTopMargin());
        this.rightMarginSpinner.setSelection(this.pageSetting.getRightMargin());
        this.bottomMarginSpinner.setSelection(this.pageSetting.getBottomMargin());
        this.leftMarginSpinner.setSelection(this.pageSetting.getLeftMargin());
    }

    protected String getErrorMessage() {
        return null;
    }
}

