/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.dialog.word.column.real;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.insightech.er.ResourceString;
import org.insightech.er.common.widgets.CompositeFactory;
import org.insightech.er.db.DBManager;
import org.insightech.er.db.DBManagerFactory;
import org.insightech.er.db.impl.mysql.MySQLDBManager;
import org.insightech.er.db.sqltype.SqlType;
import org.insightech.er.editor.model.diagram_contents.element.node.table.ERTable;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.CopyColumn;
import org.insightech.er.editor.model.diagram_contents.element.node.table.column.NormalColumn;
import org.insightech.er.editor.model.diagram_contents.not_element.sequence.Sequence;
import org.insightech.er.editor.view.dialog.element.table.sub.AutoIncrementSettingDialog;
import org.insightech.er.editor.view.dialog.word.column.real.AbstractRealColumnDialog;
import org.insightech.er.util.Check;
import org.insightech.er.util.Format;

public class ColumnDialog
extends AbstractRealColumnDialog {
    private ERTable erTable;
    private Sequence autoIncrementSetting;
    protected Button primaryKeyCheck;
    protected Text uniqueKeyNameText;
    protected Combo characterSetCombo;
    protected Combo collationCombo;
    protected Button autoIncrementCheck;
    protected Button autoIncrementSettingButton;

    public ColumnDialog(Shell parentShell, ERTable erTable) {
        super(parentShell, erTable.getDiagram());
        this.erTable = erTable;
    }

    protected void initializeDetailTab(Composite composite) {
        this.uniqueKeyNameText = CompositeFactory.createText(this, composite, "label.unique.key.name", false);
        super.initializeDetailTab(composite);
        DBManager manager = DBManagerFactory.getDBManager(this.diagram);
        if ("MySQL".equals(this.diagram.getDatabase())) {
            this.characterSetCombo = CompositeFactory.createCombo(this, composite, "label.character.set", 1);
            this.collationCombo = CompositeFactory.createCombo(this, composite, "label.collation", 1);
        }
        if (manager.isSupported(1)) {
            CompositeFactory.filler(composite, 2);
            this.autoIncrementSettingButton = new Button(composite, 0);
            this.autoIncrementSettingButton.setText(ResourceString.getResourceString("label.auto.increment.setting"));
            this.autoIncrementSettingButton.setEnabled(false);
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.autoIncrementSettingButton.setLayoutData((Object)gridData);
        }
    }

    protected int getCheckBoxCompositeNumColumns() {
        DBManager manager = DBManagerFactory.getDBManager(this.diagram);
        if (manager.isSupported(0)) {
            return 4;
        }
        return 3;
    }

    protected void initializeCheckBoxComposite(Composite composite) {
        this.primaryKeyCheck = CompositeFactory.createCheckbox(this, composite, "label.primary.key");
        super.initializeCheckBoxComposite(composite);
        DBManager manager = DBManagerFactory.getDBManager(this.diagram);
        if (manager.isSupported(0)) {
            this.autoIncrementCheck = CompositeFactory.createCheckbox(this, composite, "label.auto.increment");
        }
        if (this.isRefered) {
            this.uniqueKeyCheck.setEnabled(false);
        }
        this.enableAutoIncrement(false);
    }

    protected int getStyle(int style) {
        if (this.foreignKey) {
            style |= 8;
        }
        return style;
    }

    protected void initializeComposite(Composite composite) {
        super.initializeComposite(composite);
        if (this.foreignKey) {
            this.wordCombo.setEnabled(false);
            this.typeCombo.setEnabled(false);
            this.defaultText.setEnabled(false);
            this.lengthText.setEnabled(false);
            this.decimalText.setEnabled(false);
        }
    }

    protected void setWordData() {
        super.setWordData();
        this.primaryKeyCheck.setSelection(this.targetColumn.isPrimaryKey());
        if (this.autoIncrementCheck != null) {
            this.autoIncrementCheck.setSelection(this.targetColumn.isAutoIncrement());
        }
        if (this.primaryKeyCheck.getSelection()) {
            this.notNullCheck.setSelection(true);
            this.notNullCheck.setEnabled(false);
        } else {
            this.notNullCheck.setEnabled(true);
        }
        NormalColumn autoIncrementColumn = this.erTable.getAutoIncrementColumn();
        if (this.primaryKeyCheck.getSelection()) {
            if (autoIncrementColumn == null || autoIncrementColumn == this.targetColumn) {
                this.enableAutoIncrement(true);
            } else {
                this.enableAutoIncrement(false);
            }
        } else {
            this.enableAutoIncrement(false);
        }
        this.defaultText.setText(Format.null2blank(this.targetColumn.getDefaultValue()));
        this.setEnabledBySqlType();
        this.uniqueKeyNameText.setText(Format.null2blank(this.targetColumn.getUniqueKeyName()));
        if (this.characterSetCombo != null) {
            this.characterSetCombo.add("");
            for (String characterSet : MySQLDBManager.getCharacterSetList()) {
                this.characterSetCombo.add(characterSet);
            }
            this.characterSetCombo.setText(Format.null2blank(this.targetColumn.getCharacterSet()));
            this.collationCombo.add("");
            for (String collation : MySQLDBManager.getCollationList(this.targetColumn.getCharacterSet())) {
                this.collationCombo.add(collation);
            }
            this.collationCombo.setText(Format.null2blank(this.targetColumn.getCollation()));
        }
    }

    protected String getTitle() {
        return "dialog.title.column";
    }

    private void enableAutoIncrement(boolean enabled) {
        if (this.autoIncrementCheck != null) {
            if (!enabled) {
                this.autoIncrementCheck.setSelection(false);
            }
            this.autoIncrementCheck.setEnabled(enabled);
            if (this.autoIncrementSettingButton != null) {
                this.autoIncrementSettingButton.setEnabled(enabled && this.autoIncrementCheck.getSelection());
            }
        }
    }

    protected void setEnabledBySqlType() {
        super.setEnabledBySqlType();
        SqlType selectedType = SqlType.valueOf(this.diagram.getDatabase(), this.typeCombo.getText());
        if (selectedType != null && "PostgreSQL".equals(this.diagram.getDatabase())) {
            if ("bigserial".equals(selectedType.getId()) || "serial".equals(selectedType.getId())) {
                this.autoIncrementSettingButton.setEnabled(true);
            } else {
                this.autoIncrementSettingButton.setEnabled(false);
            }
        }
    }

    protected void perfomeOK() {
        super.perfomeOK();
        this.returnColumn.setPrimaryKey(this.primaryKeyCheck.getSelection());
        if (this.autoIncrementCheck != null) {
            this.returnColumn.setAutoIncrement(this.autoIncrementCheck.getSelection());
        }
        this.returnColumn.setAutoIncrementSetting(this.autoIncrementSetting);
        this.returnColumn.setUniqueKeyName(this.uniqueKeyNameText.getText());
        if (this.characterSetCombo != null) {
            this.returnColumn.setCharacterSet(this.characterSetCombo.getText());
            this.returnColumn.setCollation(this.collationCombo.getText());
        }
    }

    protected String getErrorMessage() {
        SqlType selectedType;
        if (this.autoIncrementCheck != null && this.autoIncrementCheck.getSelection() && ((selectedType = SqlType.valueOf(this.diagram.getDatabase(), this.typeCombo.getText())) == null || !selectedType.isNumber())) {
            return "error.no.auto.increment.column";
        }
        String text = this.uniqueKeyNameText.getText().trim();
        if (!Check.isAlphabet(text)) {
            return "error.unique.key.name.not.alphabet";
        }
        return super.getErrorMessage();
    }

    protected void addListener() {
        super.addListener();
        if (this.autoIncrementSettingButton != null) {
            this.autoIncrementSettingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AutoIncrementSettingDialog dialog = new AutoIncrementSettingDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), ColumnDialog.this.autoIncrementSetting, ColumnDialog.this.diagram.getDatabase());
                    if (dialog.open() == 0) {
                        ColumnDialog.this.autoIncrementSetting = dialog.getResult();
                    }
                }
            });
        }
        final NormalColumn autoIncrementColumn = this.erTable.getAutoIncrementColumn();
        this.primaryKeyCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnDialog.this.primaryKeyCheck.getSelection()) {
                    ColumnDialog.this.notNullCheck.setSelection(true);
                    ColumnDialog.this.notNullCheck.setEnabled(false);
                    if (autoIncrementColumn == null || autoIncrementColumn == ColumnDialog.this.targetColumn) {
                        ColumnDialog.this.enableAutoIncrement(true);
                    } else {
                        ColumnDialog.this.enableAutoIncrement(false);
                    }
                } else {
                    ColumnDialog.this.notNullCheck.setEnabled(true);
                    ColumnDialog.this.enableAutoIncrement(false);
                }
            }
        });
        this.uniqueKeyCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnDialog.this.uniqueKeyNameText.setEnabled(ColumnDialog.this.uniqueKeyCheck.getSelection());
            }
        });
        if (this.autoIncrementSettingButton != null && this.autoIncrementCheck != null) {
            this.autoIncrementCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ColumnDialog.this.autoIncrementSettingButton.setEnabled(ColumnDialog.this.autoIncrementCheck.getSelection());
                }
            });
        }
        if (this.characterSetCombo != null) {
            this.characterSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String selectedCollation = ColumnDialog.this.collationCombo.getText();
                    ColumnDialog.this.collationCombo.removeAll();
                    ColumnDialog.this.collationCombo.add("");
                    for (String collation : MySQLDBManager.getCollationList(ColumnDialog.this.characterSetCombo.getText())) {
                        ColumnDialog.this.collationCombo.add(collation);
                    }
                    int index = ColumnDialog.this.collationCombo.indexOf(selectedCollation);
                    ColumnDialog.this.collationCombo.select(index);
                }
            });
        }
    }

    public void setTargetColumn(CopyColumn targetColumn, boolean foreignKey, boolean isRefered) {
        super.setTargetColumn(targetColumn, foreignKey, isRefered);
        this.autoIncrementSetting = targetColumn != null ? targetColumn.getAutoIncrementSetting() : new Sequence();
    }
}

