/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.editor.view.figure.table.style.frame;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.insightech.er.Activator;

public class ImageTitleBarBorder
extends TitleBarBorder {
    private int width;

    public void paint(IFigure figure, Graphics g, Insets insets) {
        tempRect.setBounds(ImageTitleBarBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        Rectangle rec = tempRect;
        this.width = this.getTextExtents((IFigure)figure).width + this.getPadding().getWidth();
        rec.height = Math.min(rec.height, this.getTextExtents((IFigure)figure).height + this.getPadding().getHeight());
        g.clipRect(rec);
        g.fillRectangle(rec);
        Image image = Activator.getImage("TITLEBAR_BACKGROUND");
        g.drawImage(image, 0, 0, image.getImageData().width, image.getImageData().height, rec.x, rec.y, rec.width, rec.height);
        int x = rec.x + this.getPadding().left;
        int y = rec.y + this.getPadding().top;
        int textWidth = this.getTextExtents((IFigure)figure).width;
        int freeSpace = rec.width - this.getPadding().getWidth() - textWidth;
        if (this.getTextAlignment() == 2) {
            freeSpace /= 2;
        }
        if (this.getTextAlignment() != 1) {
            x += freeSpace;
        }
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.drawString(this.getLabel(), x, y);
    }

    public int getWidth(IFigure figure) {
        if (this.getFont(figure) != null) {
            this.width = this.getTextExtents((IFigure)figure).width + this.getPadding().getWidth();
        }
        return this.width;
    }
}

