/*
 * Decompiled with CFR 0.152.
 */
package org.insightech.er.test;

import java.io.FileNotFoundException;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImageTest {
    private static Shell shell = new Shell();
    private static Image image;
    private static ImageFigure imageFigure;

    public static void main(String[] args) throws FileNotFoundException {
        ImageTest.main();
    }

    private static void main() throws FileNotFoundException {
        try {
            shell.setSize(100, 100);
            LightweightSystem lws = new LightweightSystem((Canvas)shell);
            Figure panel = new Figure();
            panel.setLayoutManager((LayoutManager)new ToolbarLayout());
            ImageTest.initialize((IFigure)panel);
            lws.setContents((IFigure)panel);
            shell.open();
            Display display = Display.getDefault();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        finally {
            if (image != null) {
                image.dispose();
            }
        }
    }

    private static void initialize(IFigure parent) throws FileNotFoundException {
        parent.add((IFigure)ImageTest.createContents());
    }

    private static Figure createContents() {
        Figure contents = new Figure();
        XYLayout layout = new XYLayout();
        contents.setLayoutManager((LayoutManager)layout);
        Button button = new Button("Hello World");
        layout.setConstraint((IFigure)button, (Object)new Rectangle(0, 0, -1, -1));
        contents.add((IFigure)button);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionevent) {
                ImageTest.setBrightness();
            }
        });
        String path = "C:\\Users\\Public\\Pictures\\Sample Pictures\\Oryx Antelope.jpg";
        image = new Image((Device)Display.getDefault(), path);
        imageFigure = new ImageFigure(image);
        layout.setConstraint((IFigure)imageFigure, (Object)new Rectangle(0, 30, -1, -1));
        contents.add((IFigure)imageFigure);
        return contents;
    }

    private static void setBrightness() {
        if (image.isDisposed()) {
            return;
        }
        ImageData imageData = image.getImageData();
        int x = 0;
        while (x < imageData.width) {
            int y = 0;
            while (y < imageData.height) {
                RGB rgb = imageData.palette.getRGB(imageData.getPixel(x, y));
                float[] hsb = rgb.getHSB();
                hsb[2] = hsb[2] + 0.1f;
                if (hsb[2] > 1.0f) {
                    hsb[2] = 1.0f;
                }
                RGB newRGB = new RGB(hsb[0], hsb[1], hsb[2]);
                int pixel = imageData.palette.getPixel(newRGB);
                imageData.setPixel(x, y, pixel);
                ++y;
            }
            ++x;
        }
        image.dispose();
        image = new Image((Device)Display.getDefault(), imageData);
        imageFigure.setImage(image);
    }
}

