/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.io;

import com.objfac.util.IRewindableInputStream;
import com.objfac.util.Misc;
import com.objfac.util.RewindableInputStream;
import com.objfac.xml.io.ASCIIReader;
import com.objfac.xml.io.Encoding;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.io.ILogger;
import com.objfac.xml.io.ResolverConfiguration;
import com.objfac.xml.io.ResolverExtension;
import com.objfac.xml.io.UCSReader;
import com.objfac.xml.io.UTF8Reader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultDocumentReaderFactory
implements IDocumentReaderFactory {
    private static HashMap fPubMap;
    private LinkedList fExtensions;
    private static DefaultDocumentReaderFactory fFactory;
    private ResolverConfiguration[] configs;
    private ILogger logger;
    boolean[] resolverHistory;

    public static synchronized DefaultDocumentReaderFactory getFactory() {
        if (fFactory == null) {
            fFactory = new DefaultDocumentReaderFactory();
        }
        return fFactory;
    }

    public String getExternal(String string) throws IOException, MalformedURLException {
        Reader reader = this.getReader(string);
        return Misc.read((Reader)reader);
    }

    public Reader getReader(String string) throws MalformedURLException, IOException {
        Reader reader = this.getInternalReader(string);
        if (reader == null) {
            IRewindableInputStream iRewindableInputStream = this.getInputStream(string);
            Encoding encoding = this.getEncoding(iRewindableInputStream);
            String string2 = encoding.getStandardEncoding();
            if (string2 != null) {
                if (string2.equals("US-ASCII")) {
                    return new ASCIIReader((InputStream)iRewindableInputStream);
                }
                if (string2.equals("UTF-8")) {
                    return new UTF8Reader((InputStream)iRewindableInputStream);
                }
                if (string2.startsWith("UTF-16")) {
                    short s = string2.equals("UTF-16") || string2.equals("UTF-16BE") ? UCSReader.UCS2BE : UCSReader.UCS2LE;
                    return new UCSReader((InputStream)iRewindableInputStream, s);
                }
                if (string2.equals("ISO-10646-UCS-4")) {
                    short s = encoding.isBigEndian() ? UCSReader.UCS4BE : UCSReader.UCS4LE;
                    return new UCSReader((InputStream)iRewindableInputStream, s);
                }
            }
            reader = (string2 = encoding.getJavaEncoding()) != null ? new InputStreamReader((InputStream)iRewindableInputStream, string2) : new InputStreamReader((InputStream)iRewindableInputStream);
            reader = new BufferedReader(reader);
        }
        return reader;
    }

    public void addFactoryExtension(FactoryExtension factoryExtension) {
        if (this.fExtensions == null) {
            this.fExtensions = new LinkedList();
        }
        if (!this.fExtensions.contains(factoryExtension)) {
            this.fExtensions.add(factoryExtension);
        }
    }

    public void removeFactoryExtension(FactoryExtension factoryExtension) {
        this.fExtensions.remove(factoryExtension);
    }

    public void setLogger(ILogger iLogger) {
        this.logger = iLogger;
    }

    public synchronized void setResolverConfiguration(ResolverConfiguration[] resolverConfigurationArray) {
        this.configs = resolverConfigurationArray;
        this.resolverHistory = null;
    }

    public synchronized String resolve(String string, String string2, String string3, String string4) {
        if (this.configs == null) {
            return null;
        }
        int n = 0;
        int n2 = this.configs.length;
        while (n < n2) {
            String string5;
            block6: {
                ResolverExtension resolverExtension = this.configs[n].getResolver();
                string5 = null;
                try {
                    string5 = resolverExtension.resolve(string, string2, string3, string4);
                }
                catch (Throwable throwable) {
                    if (this.logger == null) break block6;
                    if (this.resolverHistory == null) {
                        this.resolverHistory = new boolean[this.configs.length];
                    }
                    if (this.resolverHistory[n]) break block6;
                    this.resolverHistory[n] = true;
                    this.logger.log("Error in resolver extension " + resolverExtension.getClass().getName() + " - only the first error reported");
                    this.logger.log(throwable);
                }
            }
            if (string5 != null) {
                return string5;
            }
            ++n;
        }
        return null;
    }

    private IRewindableInputStream getInputStream(String string) throws MalformedURLException, IOException {
        URL uRL = new URL(string);
        InputStream inputStream = uRL.openStream();
        if (inputStream != null) {
            return new RewindableInputStream(inputStream);
        }
        return null;
    }

    private Reader getInternalReader(String string) throws MalformedURLException {
        if (this.fExtensions != null) {
            Iterator iterator = this.fExtensions.iterator();
            while (iterator.hasNext()) {
                FactoryExtension factoryExtension = (FactoryExtension)iterator.next();
                Reader reader = factoryExtension.getReader(string);
                if (reader == null) continue;
                return reader;
            }
        }
        return null;
    }

    private InputStream internalGetStream(String string) throws MalformedURLException, IOException {
        URL uRL = new URL(string);
        return uRL.openStream();
    }

    private Encoding getEncoding(IRewindableInputStream iRewindableInputStream) throws IOException {
        Encoding encoding = new Encoding();
        encoding.autoDetect(iRewindableInputStream);
        return encoding;
    }

    public static interface FactoryExtension {
        public Reader getReader(String var1);
    }
}

