/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.parsers;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xml.XMLCharacter;
import com.objfac.xml.parsers.ParserInterruptedException;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.ISchema;
import com.objfac.xml.schema.UnknownPublicIdentifierException;
import com.objfac.xml.schema.impl.Attr;
import com.objfac.xml.schema.impl.ComplexType;
import com.objfac.xml.schema.impl.Element;
import com.objfac.xml.schema.impl.EnumFacet;
import com.objfac.xml.schema.impl.Model;
import com.objfac.xml.schema.impl.Notation;
import com.objfac.xml.schema.impl.Schema;
import com.objfac.xml.schema.impl.SchemaError;
import com.objfac.xml.schema.impl.SimpleType;
import com.objfac.xml.schema.impl.Type;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class DTDParser {
    private Schema fSchema;
    private boolean fInternal;
    private char[] fBuf;
    private int fBeg;
    private int fPos;
    private int fEnd;
    private int fLin;
    private HashMap fPEs;
    private LinkedList fStack;
    private String fValue;
    private String fString;
    private int fToken;
    private int fTokBeg;
    private int fTokEnd;
    private int fBad;
    private String fRefValue;
    private int fInclude = 0;
    private static HashMap fPredef = new HashMap();
    private static final Model DEFAULT_MODEL;
    private static final Model ANY_MODEL;
    private static final Model EMPTY_MODEL;
    private int fMal;
    private static final int MALMAX = 5;
    private int fNon;
    private static final int NONMAX = 5;
    private static final int BAD = 1;
    private static final int EOF = 2;
    private static final int LT = 4;
    private static final int GT = 8;
    private static final int QUESTION = 16;
    private static final int ID = 32;
    private static final int STRING = 64;
    private static final int COMMENT = 128;
    private static final int ENTITY = 256;
    private static final int ELEMENT = 512;
    private static final int ATTLIST = 1024;
    private static final int INCBEG = 2048;
    private static final int INCEND = 4096;
    private static final int LBRACKET = 8192;
    private static final int KEYWORD = 16384;
    private static final int LPAREN = 32768;
    private static final int RPAREN = 65536;
    private static final int COMMA = 131072;
    private static final int OR = 262144;
    private static final int STAR = 524288;
    private static final int PLUS = 0x100000;
    private static final int NM = 0x200000;
    private static final int RBRACKET = 0x400000;
    private static final int EQ = 0x800000;
    private static final int NOTATION = 0x1000000;
    private static final int PE = 0x2000000;
    private IExternalEntity fEnt;
    private static char[] fOne;
    private static final String XML_STR = " <?xml";
    private static final int XML_LEN;
    private static final String VALUE_AFTER_EQ = "dtdparser_Value_required_after___24";
    private static char[] fCharArray;
    private boolean fIgnoreMissing = true;
    private boolean fEof;
    private String fNam;

    static {
        fPredef.put("&lt;", "&#60;");
        fPredef.put("&amp;", "&#38;");
        fPredef.put("&gt;", ">");
        fPredef.put("&quot;", "\"");
        fPredef.put("&apos;", "'");
        DEFAULT_MODEL = new Model(3);
        ANY_MODEL = new Model(5);
        EMPTY_MODEL = new Model(6);
        fOne = new char[1];
        XML_LEN = XML_STR.length();
        fCharArray = new char[1];
    }

    public ISchema parseInternal(IExternalEntity iExternalEntity, char[] cArray, int n, int n2) {
        this.fEnt = iExternalEntity;
        this.fNam = "*internal*";
        this.fSchema = new Schema(true, iExternalEntity.getFactory());
        this.fInternal = true;
        this.parse(cArray, n, n2);
        return this.fSchema;
    }

    public ISchema parseExternal(ISchema iSchema, IExternalEntity iExternalEntity) {
        this.fEnt = iExternalEntity;
        this.fNam = "*external*";
        this.fSchema = (Schema)iSchema;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getContents(this.fEnt, stringBuffer)) {
            char[] cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
            this.fInternal = false;
            this.parse(cArray, 0, cArray.length);
        }
        return this.fSchema;
    }

    public ISchema parseExternal(IExternalEntity iExternalEntity) {
        return this.parseExternal(new Schema(true, iExternalEntity.getFactory()), iExternalEntity);
    }

    public ISchema parse(ISchema iSchema, IExternalEntity iExternalEntity, char[] cArray, int n, int n2) {
        this.fEnt = iExternalEntity;
        this.fNam = "*external*";
        this.fSchema = (Schema)iSchema;
        this.fInternal = false;
        this.parse(cArray, n, n2);
        return this.fSchema;
    }

    public ISchema parse(IExternalEntity iExternalEntity, char[] cArray, int n, int n2) {
        return this.parse(new Schema(true, iExternalEntity.getFactory()), iExternalEntity, cArray, n, n2);
    }

    public void setIgnoreMissingEntities(boolean bl) {
        this.fIgnoreMissing = bl;
    }

    public boolean ignoreMissingEntities() {
        return this.fIgnoreMissing;
    }

    private int nextToken() {
        int n;
        this.fToken = 1;
        while (true) {
            n = this.skipWS();
            this.fTokBeg = this.fTokEnd = this.fPos - 1;
            if (n < 0) {
                this.fTokBeg = this.fTokEnd = this.fPos;
                break;
            }
            if (n != 37 || this.fInternal) break;
            this.expandPE();
        }
        if (n < 0) {
            this.fToken = 2;
        } else {
            switch (XMLCharacter.charType(n)) {
                case 11: {
                    n = this.nextChar();
                    if (n == 33) {
                        n = this.nextChar();
                        if (n == 91) {
                            this.fValue = "<![";
                            this.fToken = 2048;
                            break;
                        }
                        this.pushChar();
                    }
                    this.pushChar();
                    this.fValue = "<";
                    this.fToken = 4;
                    break;
                }
                case 12: {
                    this.fValue = ">";
                    this.fToken = 8;
                    break;
                }
                case 8: {
                    this.fValue = "=";
                    this.fToken = 0x800000;
                    break;
                }
                case 19: {
                    this.fValue = "?";
                    this.fToken = 16;
                    break;
                }
                case 15: {
                    this.fValue = "(";
                    this.fToken = 32768;
                    break;
                }
                case 16: {
                    this.fValue = ")";
                    this.fToken = 65536;
                    break;
                }
                case 26: {
                    this.fValue = ",";
                    this.fToken = 131072;
                    break;
                }
                case 27: {
                    this.fValue = "|";
                    this.fToken = 262144;
                    break;
                }
                case 9: 
                case 10: {
                    DTDParser.fOne[0] = (char)n;
                    this.fValue = new String(fOne);
                    this.collectString(n);
                    return 64;
                }
                case 14: {
                    n = this.nextChar();
                    if (n == 45) {
                        n = this.nextChar();
                        if (n == 45) {
                            this.scanComment();
                            this.fValue = "!--";
                            this.fToken = 128;
                            break;
                        }
                        this.pushChar();
                        break;
                    }
                    if (n == 91) {
                        this.fValue = "![";
                        this.fToken = 2048;
                        break;
                    }
                    if (XMLCharacter.isIDStart((char)n)) {
                        this.fValue = this.collectId(n);
                        if (this.fValue.equals("ELEMENT")) {
                            this.fToken = 512;
                            break;
                        }
                        if (this.fValue.equals("ENTITY")) {
                            this.fToken = 256;
                            break;
                        }
                        if (this.fValue.equals("ATTLIST")) {
                            this.fToken = 1024;
                            break;
                        }
                        if (!this.fValue.equals("NOTATION")) break;
                        this.fToken = 0x1000000;
                        break;
                    }
                    this.pushChar();
                    break;
                }
                case 17: {
                    this.fValue = "[";
                    this.fToken = 8192;
                    break;
                }
                case 18: {
                    n = this.nextChar();
                    if (n == 93) {
                        n = this.nextChar();
                        if (n == 62) {
                            this.fValue = "]]>";
                            this.fToken = 4096;
                            break;
                        }
                        this.pushChar();
                    }
                    this.pushChar();
                    this.fValue = "]";
                    this.fToken = 0x400000;
                    break;
                }
                case 24: {
                    this.fValue = "*";
                    this.fToken = 524288;
                    break;
                }
                case 25: {
                    this.fValue = "+";
                    this.fToken = 0x100000;
                    break;
                }
                case 22: {
                    this.fValue = this.collectId(n);
                    this.fToken = 16384;
                    break;
                }
                case 23: {
                    this.fValue = this.parsePE();
                    if (this.fValue.length() <= 0) break;
                    this.fToken = 0x2000000;
                    break;
                }
                case 0: {
                    if (this.nextChar() < 0) {
                        this.malformedError(n);
                        this.pushChar();
                        break;
                    }
                    this.error("dtdparser_illegal_token_4", 0x100000 + n);
                    break;
                }
                case 2: {
                    this.malformedError(n);
                    break;
                }
                case 1: {
                    this.nonXmlError(n);
                    break;
                }
                case 6: {
                    this.fValue = this.collectId(n);
                    this.fToken = 32;
                    break;
                }
                case 7: {
                    this.fValue = this.collectId(n);
                    this.fToken = 0x200000;
                    break;
                }
                default: {
                    this.error("dtdparser_illegal_token_5");
                }
            }
        }
        this.fTokEnd = this.fPos;
        return this.fToken;
    }

    private boolean getContents(IExternalEntity iExternalEntity, StringBuffer stringBuffer) {
        String string = "";
        try {
            if (!this.isRecursive(iExternalEntity)) {
                string = iExternalEntity.getAbsUrl();
                iExternalEntity.getContents(stringBuffer);
                return true;
            }
        }
        catch (UnknownPublicIdentifierException unknownPublicIdentifierException) {
            this.error("dtdparser Entity no system id for " + iExternalEntity.getPublicId());
        }
        catch (MalformedURLException malformedURLException) {
            this.error("dtdparser_Entity_has_malformed_URL_{0}_17", string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            string.length();
            if (!this.fIgnoreMissing) {
                this.error("dtdparser_Entity_not_found_at_{0}_19", string);
            }
        }
        catch (IOException iOException) {
            this.error("Error reading entity {0} [{1}]", string, iOException.toString());
        }
        return false;
    }

    private boolean isRecursive(IExternalEntity iExternalEntity) throws UnknownPublicIdentifierException {
        String string = iExternalEntity.getAbsUrl();
        string.startsWith("file:");
        IExternalEntity iExternalEntity2 = iExternalEntity.getParent();
        while (iExternalEntity2 != null) {
            try {
                String string2 = iExternalEntity2.getAbsUrl();
                if (Misc.equalUrls((String)string, (String)string2)) {
                    this.error("dtdparser_Recursive_external_entity_{0}_21", string);
                    return true;
                }
            }
            catch (UnknownPublicIdentifierException unknownPublicIdentifierException) {}
            iExternalEntity2 = iExternalEntity2.getParent();
        }
        return false;
    }

    private void parse(char[] cArray, int n, int n2) {
        this.fBuf = cArray;
        this.fBeg = this.fPos = n;
        this.fEnd = n2;
        this.fLin = 1;
        this.fNon = -1;
        this.fMal = -1;
        this.fPEs = new HashMap();
        this.fStack = new LinkedList();
        this.parse();
        this.fPEs = null;
        this.fBuf = null;
        this.fStack = null;
    }

    private void parse() {
        if (!this.fInternal && this.fEnd - this.fPos >= "<?xml".length() && this.fBuf[this.fPos] == '<' && this.fBuf[this.fPos + 1] == '?' && this.fBuf[this.fPos + 2] == 'x' && this.fBuf[this.fPos + 3] == 'm' && this.fBuf[this.fPos + 4] == 'l') {
            this.fPos += XML_LEN;
            this.parseXML(false);
        }
        while (true) {
            boolean bl;
            if (Thread.currentThread().isInterrupted()) {
                throw new ParserInterruptedException();
            }
            int n = this.nextToken();
            if (n == 2) break;
            switch (n) {
                case 4: {
                    bl = this.parseTag();
                    break;
                }
                case 2048: {
                    bl = this.beginInclude();
                    break;
                }
                case 4096: {
                    bl = this.endInclude();
                    break;
                }
                case 0x2000000: {
                    bl = this.expandStmtPE();
                    break;
                }
                default: {
                    bl = this.invalidToken(n);
                }
            }
            if (bl) continue;
            this.skipToLT();
        }
    }

    private int nextChar() {
        this.fEof = false;
        while (true) {
            if (this.fPos < this.fEnd) {
                char c;
                if ((c = this.fBuf[this.fPos++]) == '\n' || c == '\r' && this.fPos < this.fEnd && this.fBuf[this.fPos] != '\n') {
                    ++this.fLin;
                }
                return c;
            }
            if (this.fStack.size() <= 0) break;
            this.popPE();
        }
        this.fEof = true;
        return -1;
    }

    private void pushChar() {
        if (this.fPos == this.fBeg) {
            throw new IllegalStateException("dtdparser_internal_pushChar()_before_start_7");
        }
        if (!this.fEof && this.fBuf[--this.fPos] == '\n') {
            --this.fLin;
        }
    }

    private String collectId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append((char)n);
        } while (XMLCharacter.isIDPart((char)(n = this.nextChar())));
        this.pushChar();
        return stringBuffer.toString();
    }

    private String collectId() {
        int n = this.nextChar();
        if (XMLCharacter.isIDStart((char)n)) {
            return this.collectId(n);
        }
        this.pushChar();
        return "";
    }

    private String parsePE() {
        String string = this.collectId();
        if (string.length() == 0) {
            this.error("dtdparser_pe_name_expected_9");
        } else {
            int n = this.nextChar();
            if (n != 59) {
                this.error("dtdparser_;_expected_after_pe_name_10");
                string = "";
                this.pushChar();
            }
        }
        return string;
    }

    private void collectString(int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (!this.goodChar(n)) continue;
            stringBuffer.append((char)n);
        } while ((n = this.nextChar()) != n2);
        stringBuffer.append((char)n);
        this.fValue = stringBuffer.toString();
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.fString = stringBuffer.toString();
    }

    private boolean scanComment() {
        block4: {
            while (true) {
                int n;
                if (!this.goodChar(n = this.nextChar())) continue;
                if (n == 45) {
                    n = this.nextChar();
                    if (n == 45) {
                        n = this.nextChar();
                        if (n != 62) {
                            return this.error("dtdparser_--_not_fol_by_>_12");
                        }
                        break block4;
                    }
                    this.pushChar();
                    continue;
                }
                if (n < 0) break;
            }
            return this.error("dtdparser_unterminated_comment_13");
        }
        return true;
    }

    private boolean error(String string) {
        return this.internalError(Local.getString((String)string));
    }

    private boolean error(String string, int n) {
        return this.internalError(Local.format((String)string, (int)n));
    }

    private boolean error(String string, String string2) {
        return this.internalError(Local.format((String)string, (Object)string2));
    }

    private boolean error(String string, String string2, String string3) {
        return this.internalError(Local.format((String)string, (Object)string2, (Object)string3));
    }

    private boolean internalError(String string) {
        int n;
        int n2;
        IExternalEntity iExternalEntity = this.fEnt;
        int n3 = this.fPos;
        int n4 = this.fBeg;
        int n5 = this.fEnd;
        char[] cArray = this.fBuf;
        if (this.fStack != null) {
            Entry[] entryArray = this.fStack.toArray(new Entry[this.fStack.size()]);
            n = n2 = entryArray.length;
            int n6 = entryArray.length - 1;
            while (n6 >= 0) {
                if (entryArray[n6].fEnt != this.fEnt) {
                    n = n6 + 1;
                    break;
                }
                --n6;
            }
            if (n != n2) {
                Entry entry = entryArray[n];
                iExternalEntity = entry.fEnt;
                cArray = entry.fBuf;
                n3 = entry.fPos;
                n4 = entry.fBeg;
                n5 = entry.fEnd;
            }
        } else if (this.fEnt == null) {
            SchemaError schemaError = new SchemaError(string, null, "", 0, 0, 0, 0);
            this.fSchema.addError(schemaError);
            return false;
        }
        int n7 = 1;
        n2 = 1;
        n = n4;
        int n8 = 0;
        while (n8 < n5 && n8 < n3) {
            if (cArray[n8] == '\n') {
                ++n2;
                n = n8 + 1;
            }
            ++n8;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n9 = n;
        while (n9 < n5) {
            char c = cArray[n9];
            if (c == '\r' || c == '\n') break;
            stringBuffer.append(c);
            ++n9;
        }
        String string2 = stringBuffer.toString();
        SchemaError schemaError = new SchemaError(string, iExternalEntity, string2, n3, n7, n2, n);
        this.fSchema.addError(schemaError);
        return false;
    }

    private boolean malformedError(int n) {
        if (++this.fMal <= 5) {
            if (this.fMal == 5) {
                return this.error("dtdparser_too_many_malformed_characters_17");
            }
            return this.error("dtdparser_malformed_character_{0}_18", "[" + Integer.toHexString(n) + "]");
        }
        return false;
    }

    private boolean nonXmlError(int n) {
        if (++this.fNon <= 5) {
            if (this.fNon == 5) {
                return this.error("dtdparser_too_many_non-XML_characters_21");
            }
            return this.error("dtdparser_non-XML_character_{0}_22", "[" + Integer.toHexString(n) + "]");
        }
        return false;
    }

    private boolean goodChar(int n) {
        switch (XMLCharacter.charType(n)) {
            case 2: {
                return this.malformedError(n);
            }
            case 1: {
                return this.nonXmlError(n);
            }
            case 0: {
                if (this.nextChar() >= 0) break;
                this.malformedError(n);
                this.pushChar();
                return false;
            }
        }
        return true;
    }

    private void pushPE(String string, Object object) {
        char[] cArray;
        StringBuffer stringBuffer = null;
        IExternalEntity iExternalEntity = this.fEnt;
        if (object instanceof IExternalEntity) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(' ');
            iExternalEntity = (IExternalEntity)object;
            if (!this.getContents(iExternalEntity, stringBuffer)) {
                return;
            }
            stringBuffer.append(' ');
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        } else {
            cArray = (" " + (String)object + ' ').toCharArray();
        }
        Entry entry = new Entry();
        entry.fBuf = this.fBuf;
        entry.fPos = this.fPos;
        entry.fBeg = this.fBeg;
        entry.fEnd = this.fEnd;
        entry.fLin = this.fLin;
        entry.fEnt = this.fEnt;
        entry.fNam = this.fNam;
        this.fStack.addLast(entry);
        this.fBuf = cArray;
        this.fBeg = 0;
        this.fPos = 0;
        this.fEnd = this.fBuf.length;
        this.fEnt = iExternalEntity;
        this.fNam = string;
        if (stringBuffer != null && stringBuffer.length() >= XML_LEN && stringBuffer.substring(0, XML_LEN).equals(XML_STR)) {
            this.fPos = XML_LEN;
            this.parseXML(true);
            this.fBuf[--this.fPos] = 32;
        }
    }

    private boolean parseXML(boolean bl) {
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_Expecting_version_or_encoding_in_xml_decl,_found_{0}_25", this.fValue);
        }
        if (this.fValue.equals("version")) {
            if (this.nextToken() != 0x800000) {
                return this.error("dtdparser_Expecting___after_version_27");
            }
            if (this.nextToken() != 64) {
                return this.error(VALUE_AFTER_EQ);
            }
            if (!this.fString.equals("1.0")) {
                return this.error("dtdparser_Version_must_be_1.0_29");
            }
            n = this.nextToken();
        } else if (!bl) {
            return this.error("dtdparser_version_is_required_in_xml_decl_30");
        }
        if (n == 32 && this.fValue.equals("encoding")) {
            if (this.nextToken() != 0x800000) {
                return this.error("dtdparser_Expecting___after_encoding_32");
            }
            if (this.nextToken() != 64) {
                return this.error(VALUE_AFTER_EQ);
            }
            n = this.nextToken();
        } else if (bl) {
            this.error("dtdparser_Missing_required_encoding_param_33");
        }
        if (n == 32 && this.fValue.equals("standalone")) {
            if (bl) {
                this.error("dtdparser_standalone_not_permitted_in_external_entity_35");
            }
            if (this.nextToken() != 0x800000) {
                return this.error("dtdparser_Expecting___after_standalone_36");
            }
            if (this.nextToken() != 64) {
                return this.error(VALUE_AFTER_EQ);
            }
            if (!this.fString.equals("yes") && !this.fString.equals("no")) {
                return this.error("dtdparser_standalone_value_must_be_yes_or_no_39");
            }
            this.nextToken();
        }
        if (n != 16) {
            return this.error("dtdparser__>_required_at_end_of_xml_decl_40");
        }
        this.noWS("dtdparser_no_space_allowed_between___and_>_41");
        return this.parseEndTag();
    }

    private void popPE() {
        Entry entry = (Entry)this.fStack.removeLast();
        this.fBuf = entry.fBuf;
        this.fPos = entry.fPos;
        this.fBeg = entry.fBeg;
        this.fEnd = entry.fEnd;
        this.fLin = entry.fLin;
        this.fEnt = entry.fEnt;
        this.fNam = entry.fNam;
    }

    private void skipToLT() {
        int n;
        while ((n = this.nextToken()) != 2 && n != 4) {
        }
        this.pushToken();
    }

    private boolean parseTag() {
        int n = this.nextToken();
        switch (n) {
            case 128: {
                return true;
            }
            case 256: {
                return this.parseEntity();
            }
            case 512: {
                return this.parseElement();
            }
            case 1024: {
                return this.parseAttlist();
            }
            case 0x1000000: {
                return this.parseNotation();
            }
            case 16: {
                return this.parsePI();
            }
        }
        return this.error("dtdparser_expect_tag_begin_26");
    }

    private boolean parsePI() {
        if (!(this.fPos + 2 >= this.fEnd || this.fBuf[this.fPos] != 'x' && this.fBuf[this.fPos] != 'X' || this.fBuf[this.fPos + 1] != 'm' && this.fBuf[this.fPos + 1] != 'M' || this.fBuf[this.fPos + 2] != 'l' && this.fBuf[this.fPos + 2] != 'L')) {
            return this.error("xml may not be used as target of PI");
        }
        this.noWS("S after <?");
        int n = this.nextToken();
        if (n != 32) {
            return this.error("no PI target after <?");
        }
        String string = this.fValue;
        this.requireWS("no S after PI target");
        while (this.fPos < this.fEnd && XMLCharacter.isWhitespace(this.fBuf[this.fPos])) {
            ++this.fPos;
        }
        int n2 = this.fPos;
        while (this.fPos < this.fEnd) {
            if (this.fBuf[this.fPos] == '?' && this.fPos + 1 < this.fEnd && this.fBuf[this.fPos + 1] == '>') {
                ++this.fPos;
                break;
            }
            ++this.fPos;
        }
        if (this.fPos == this.fEnd) {
            return this.error("EOF in PI looking for ?>");
        }
        this.fSchema.addPI(string, new String(this.fBuf, n2, this.fPos - n2));
        return this.parseEndTag();
    }

    private boolean parseNotation() {
        boolean bl;
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_expect_notation_name_1");
        }
        String string = this.fValue;
        this.requireWS("dtdparser_S_after_notation_name_2");
        n = this.nextToken();
        boolean bl2 = n == 32 && this.fValue.equals("PUBLIC");
        boolean bl3 = bl = n == 32 && this.fValue.equals("SYSTEM");
        if (!bl2 && !bl) {
            return this.error("dtdparser_require_PUBLIC_or_SYSTEM_after_notation_name_3");
        }
        String string2 = null;
        String string3 = null;
        if (bl2) {
            if (this.nextToken() != 64) {
                return this.error("dtdparser_PUBLIC_must_be_followed_by_public_id_4");
            }
            string2 = this.fString;
            if (this.nextToken() == 64) {
                string3 = this.fString;
            } else {
                this.pushToken();
            }
        } else {
            if (this.nextToken() != 64) {
                return this.error("dtdparser_SYSTEM_must_be_followed_by_system_id_5");
            }
            string3 = this.fString;
        }
        Notation notation = new Notation(string, string2, string3, this.fSchema);
        if (!this.fSchema.addNotation(notation)) {
            return this.error("dtdparser_notation_{0}_already_defined_6", string);
        }
        return this.parseEndTag();
    }

    private boolean parseEntity() {
        boolean bl;
        int n = this.skipWS();
        boolean bl2 = bl = n == 37;
        if (!bl) {
            this.pushChar();
        } else {
            this.requireWS("dtdparser_S_after_%_27");
        }
        int n2 = this.nextToken();
        if (n2 != 32) {
            return this.error("dtdparser_expect_entity_name_28");
        }
        String string = this.fValue;
        this.requireWS("dtdparser_S_after_entity_name_29");
        n2 = this.nextToken();
        if (n2 == 64) {
            if (bl) {
                this.fSchema.addPE(string, this.peValue());
            } else {
                this.fSchema.addGE(string, this.geValue());
            }
        } else if (n2 == 32) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (this.fValue.equals("PUBLIC")) {
                this.requireWS("dtdparser_S_after_PUBLIC_31");
                n2 = this.nextToken();
                if (n2 != 64) {
                    return this.error("dtdparser_expect_string_after_PUBLIC_32");
                }
                string2 = this.fString;
                this.requireWS("dtdparser_S_after_public_id_33");
                n2 = this.nextToken();
                if (n2 != 64) {
                    return this.error("dtdparser_expect_system_id_after_public_id_34");
                }
                string3 = this.fString;
            } else if (this.fValue.equals("SYSTEM")) {
                this.requireWS("dtdparser_S_after_SYSTEM_36");
                n2 = this.nextToken();
                if (n2 != 64) {
                    return this.error("dtdparser_expect_string_after_SYSTEM_37");
                }
                string3 = this.fString;
            } else {
                return this.error("dtdparser_expect_PUBLIC_or_SYSTEM_38");
            }
            if (!bl) {
                boolean bl3 = this.peekWS();
                n2 = this.nextToken();
                if (n2 == 32 && this.fValue.equals("NDATA")) {
                    if (!bl3) {
                        this.error("dtdparser_S_after_id_string_40");
                    }
                    if ((n2 = this.nextToken()) != 64) {
                        return this.error("dtdparser_expect_string_after_NDATA_41");
                    }
                    string4 = this.fString;
                } else {
                    this.pushToken();
                }
            }
            if (bl) {
                this.fSchema.addExternalPE(string, string2, string3, this.fEnt);
            } else {
                this.fSchema.addExternalGE(string, string2, string3, string4, this.fEnt);
            }
        } else {
            return this.error("dtdparser_expect_entity_def_42");
        }
        return this.parseEndTag();
    }

    private boolean parseEndTag() {
        int n = this.nextToken();
        if (n == 8) {
            return true;
        }
        if (n == 4 || n == 2) {
            this.pushToken();
        }
        return this.error("dtdparser_expect_end_of_tag_43");
    }

    private void pushToken() {
        this.fPos = this.fTokBeg;
    }

    private String peValue() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = this.fString.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char c = cArray[n];
            if (c == '%') {
                n = this.paramRef(cArray, n, n2);
                stringBuffer.append(this.fRefValue);
            } else if (c == '&') {
                n = this.charRef(cArray, n, n2);
                stringBuffer.append(this.fRefValue);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private int paramRef(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        ++n;
        while (n < n2 && cArray[n] != ';') {
            stringBuffer.append(cArray[n++]);
        }
        String string = stringBuffer.toString();
        if (n == n2) {
            this.error("dtdparser_undefined_param_ref_%{0};_44", string);
            this.fRefValue = "";
        } else {
            try {
                this.fRefValue = this.fSchema.getPEValue(string);
            }
            catch (Exception exception) {
                this.error("dtdparser_error_getting_value_of_%{0};_-_{1}_46", string, exception.toString());
            }
            if (this.fRefValue == null) {
                this.fRefValue = "";
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private int charRef(char[] var1_1, int var2_2, int var3_3) {
        block12: {
            block14: {
                block15: {
                    block17: {
                        block16: {
                            block13: {
                                var4_4 = var2_2++;
                                var5_5 = 0;
                                var6_6 = true;
                                var7_7 = false;
                                if (var2_2 != var3_3) break block13;
                                var6_6 = this.error("dtdparser_incomplete_entity_reference_{0}_11", new String(var1_1, var4_4, var2_2 - var4_4));
                                break block12;
                            }
                            if ((var8_8 = var1_1[var2_2++]) != 35) break block14;
                            var7_7 = true;
                            if (var2_2 >= var3_3) break block15;
                            if ((var8_8 = var1_1[var2_2++]) == 120 || var8_8 >= 48 || var8_8 <= 57) break block16;
                            var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                            var6_6 = false;
                            break block12;
                        }
                        if (var8_8 != 120) break block17;
                        while (var2_2 < var3_3) {
                            block20: {
                                block19: {
                                    block18: {
                                        var8_8 = var1_1[var2_2];
                                        var9_9 = 0;
                                        if (48 > var8_8 || var8_8 > 57) break block18;
                                        var9_9 = var8_8 - 48;
                                        ** GOTO lbl-1000
                                    }
                                    if (97 > var8_8 || var8_8 > 102) break block19;
                                    var9_9 = var8_8 - 97 + 10;
                                    ** GOTO lbl-1000
                                }
                                if (65 > var8_8 || var8_8 > 70) break block20;
                                var9_9 = var8_8 - 65 + 10;
                                ** GOTO lbl-1000
                            }
                            if (var8_8 != 59) {
                                ++var2_2;
                                var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                                var6_6 = false;
                            } else if (var8_8 != 59) {
                                var5_5 = var5_5 * 16 + var9_9;
                                ++var2_2;
                                continue;
                            }
                            break block12;
                        }
                        break block12;
                    }
                    var5_5 = var8_8 - 48;
                    while (var2_2 < var3_3) {
                        var8_8 = var1_1[var2_2];
                        if (var8_8 != 59 && (var8_8 < 48 || var8_8 > 57)) {
                            ++var2_2;
                            var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                            var6_6 = false;
                        } else if (var8_8 != 59) {
                            var5_5 = var5_5 * 10 + var8_8 - 48;
                            ++var2_2;
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                }
                var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                var6_6 = false;
                break block12;
            }
            var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
        }
        var8_8 = var2_2 - (var2_2 == var3_3 ? var4_4 : var4_4 - 1);
        if (var6_6) {
            if (var7_7) {
                DTDParser.fCharArray[0] = (char)var5_5;
                this.fRefValue = new String(DTDParser.fCharArray);
            } else {
                this.fRefValue = new String(var1_1, var4_4, var8_8);
            }
        } else {
            this.fRefValue = new String(var1_1, var4_4, var8_8);
            this.error("dtdparser_ill-formed_numeric_character_reference_{0}_12", this.fRefValue);
        }
        return var2_2;
    }

    private int collect(int n, char[] cArray, int n2, int n3) {
        while (n2 < n3) {
            if (cArray[n2] == ';') break;
            ++n2;
        }
        if (n2 == n3) {
            this.error("dtdparser_incomplete_entity_ref_{0}_13", new String(cArray, n, n2 - n));
        }
        return n2;
    }

    private String geValue() {
        return this.peValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseElement() {
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_expect_element_name_50");
        }
        String string = this.fValue;
        Element element = this.getElement(string);
        if (!element.isUndefined()) {
            return this.error("dtdparser_element_{0}_already_declared_51", string);
        }
        element.setUndefined(false);
        this.requireWS("dtdparser_S_after_element_name_52");
        n = this.nextToken();
        if (n == 32) {
            boolean bl = this.fValue.equals("ANY");
            boolean bl2 = this.fValue.equals("EMPTY");
            if (!bl && !bl2) {
                return this.error("dtdparser_expect_ANY_or_EMPTY_55");
            }
            ComplexType complexType = this.getComplexType(element);
            complexType.setAny(bl);
            complexType.setEmpty(bl2);
            return this.parseEndTag();
        } else {
            if (n == 32768) {
                Type type;
                boolean bl = false;
                boolean bl3 = false;
                n = this.nextToken();
                if (n == 16384 && this.fValue.equals("#PCDATA")) {
                    bl = true;
                    n = this.nextToken();
                    if (n == 65536) {
                        type = (SimpleType)this.fSchema.getSimpleType("http://www.w3.org/2001/XMLSchema", "string");
                        element.setSimpleType((SimpleType)type);
                        n = this.nextToken();
                        if (n != 524288) {
                            this.pushToken();
                        }
                        bl3 = true;
                    } else if (n != 262144) {
                        return this.error("dtdparser_expect_)_or_|_after__#PCDATA_58");
                    }
                } else {
                    this.pushToken();
                }
                type = this.getComplexType(element);
                ((ComplexType)type).setMixed(bl);
                ((ComplexType)type).setChildren(!bl && !bl3);
                if (bl3) return this.parseEndTag();
                Model model = new Model(bl ? 2 : 0);
                ((ComplexType)type).setElementModel(model);
                if (!this.parseModel(model, bl)) return false;
                element.setComplexType((ComplexType)type);
                if (!bl || model.getMinOccurs() == 0 && model.getMaxOccurs() == Integer.MAX_VALUE) return this.parseEndTag();
                return this.error("dtdparser_mixed_model_must_use_*_59");
            }
            this.error("dtdparser_expect_ANY,_EMPTY_or_(_60");
        }
        return this.parseEndTag();
    }

    private boolean parseModel(Model model, boolean bl) {
        HashSet<String> hashSet;
        int n = this.nextToken();
        HashSet<String> hashSet2 = hashSet = bl ? new HashSet<String>() : null;
        do {
            Model model2;
            if (n == 32) {
                if (bl) {
                    if (hashSet.contains(this.fValue)) {
                        return this.error("dtdparser_duplicate_type_{0}_in_mixed_model_1", this.fValue);
                    }
                    hashSet.add(this.fValue);
                }
                model2 = new Model(4);
                Element element = this.getElement(this.fValue);
                model2.setLeaf(element);
                model.addModel(model2);
                this.parseQualifier(model2);
            } else if (n == 32768) {
                if (bl) {
                    return this.error("dtdparser_mixed_model_can__t_have_submodels_61");
                }
                model2 = new Model();
                model.addModel(model2);
                this.parseModel(model2, false);
            } else {
                return this.error("dtdparser_expect_id_or_(_in_model_62");
            }
            n = this.nextToken();
            if (n == 262144 || n == 131072) {
                int n2 = n == 262144 ? 2 : 1;
                int n3 = model.getKind();
                if (n3 != 0 && n3 != n2) {
                    return this.error("dtdparser_unlike_operators_in_model_63");
                }
                model.setKind(n2);
                n = this.nextToken();
                continue;
            }
            if (n == 65536) continue;
            return this.error("dtdparser_model_operator_not_|_or_,_-_found_{0}_64", this.fValue);
        } while (n != 65536);
        this.parseQualifier(model);
        if (model.getKind() == 0) {
            model.setKind(1);
        }
        return true;
    }

    public void parseQualifier(Model model) {
        int n = this.nextToken();
        if (n == 524288 || n == 0x100000 || n == 16) {
            model.setMinOccurs(n == 0x100000 ? 1 : 0);
            model.setMaxOccurs(n == 16 ? 1 : Integer.MAX_VALUE);
        } else {
            this.pushToken();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseAttlist() {
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_expect_element_name_in_attlist_65");
        }
        Element element = this.getElement(this.fValue);
        Model model = this.getAttrModel(element);
        while (true) {
            EnumFacet enumFacet;
            SimpleType simpleType;
            boolean bl = this.peekWS();
            n = this.nextToken();
            if (n == 8) {
                this.pushToken();
                return this.parseEndTag();
            }
            if (!bl) {
                this.error("dtdparser_S_before_AttDef_66");
            }
            if (n != 32) {
                if (n != 8) return this.error("dtdparser_expect_attr_name_or_>_67");
                this.pushToken();
                return this.parseEndTag();
            }
            Attr attr = new Attr(this.fValue, this.fSchema);
            attr.setElement(element);
            Model model2 = new Model(4);
            model2.setMinOccurs(0);
            model2.setMaxOccurs(1);
            model2.setLeaf(attr);
            model.addModel(model2);
            n = this.nextToken();
            if (n == 32768) {
                simpleType = new SimpleType(this.fSchema);
                simpleType.setBaseType(SimpleType.NMTOKEN_TYPE);
                attr.setSimpleType(simpleType);
                enumFacet = new EnumFacet();
                do {
                    if ((n = this.nextToken()) != 32 && n != 0x200000) {
                        return this.error("dtdparser_expect_enumeration_NMTOKEN_68");
                    }
                    enumFacet.addValue(this.fValue);
                } while ((n = this.nextToken()) == 262144);
                if (n != 65536) {
                    this.error("dtdparser_expect_|_or_)_after_enum_item_1");
                }
                if (enumFacet.getEnum().length == 0) {
                    this.error("dtdparser_empty_enumeration_70");
                }
                simpleType.addFacet(enumFacet);
            } else {
                if (n != 32) return this.error("dtdparser_expect_attr_type_85");
                if (this.fValue.equals("NOTATION")) {
                    this.requireWS("dtdparser_S_after_NOTATION_72");
                    if (this.nextToken() != 32768) {
                        return this.error("expect ( after NOTATION");
                    }
                    simpleType = new SimpleType(this.fSchema);
                    simpleType.setBaseType(SimpleType.NOTATION_TYPE);
                    attr.setSimpleType(simpleType);
                    enumFacet = new EnumFacet();
                    do {
                        if ((n = this.nextToken()) != 32) {
                            return this.error("dtdparser_expect_notation_Name_73");
                        }
                        enumFacet.addValue(this.fValue);
                        if (this.fSchema.getNotation(this.fValue) != null) continue;
                        return this.error("undefined notation name {0}", this.fValue);
                    } while ((n = this.nextToken()) == 262144);
                    if (n != 65536) {
                        this.error("dtdparser_expect_,_or_)_after_enum_item_74");
                    }
                    if (enumFacet.getEnum().length == 0) {
                        this.error("dtdparser_empty_enumeration_75");
                    }
                    simpleType.addFacet(enumFacet);
                } else if (this.fValue.equals("CDATA")) {
                    attr.setSimpleType(SimpleType.CDATA_TYPE);
                } else if (this.fValue.equals("ID")) {
                    attr.setSimpleType(SimpleType.ID_TYPE);
                } else if (this.fValue.equals("IDREF")) {
                    attr.setSimpleType(SimpleType.IDREF_TYPE);
                } else if (this.fValue.equals("IDREFS")) {
                    attr.setSimpleType(SimpleType.IDREFS_TYPE);
                } else if (this.fValue.equals("ENTITY")) {
                    attr.setSimpleType(SimpleType.ENTITY_TYPE);
                } else if (this.fValue.equals("ENTITIES")) {
                    attr.setSimpleType(SimpleType.ENTITIES_TYPE);
                } else if (this.fValue.equals("NMTOKEN")) {
                    attr.setSimpleType(SimpleType.NMTOKEN_TYPE);
                } else {
                    if (!this.fValue.equals("NMTOKENS")) return this.error("dtdparser_expect_NOTATION_or_attr_type_name_84");
                    attr.setSimpleType(SimpleType.NMTOKENS_TYPE);
                }
            }
            n = this.nextToken();
            if (n == 16384) {
                if (this.fValue.equals("#REQUIRED")) {
                    model2.setMinOccurs(1);
                    continue;
                }
                if (this.fValue.equals("#FIXED")) {
                    this.requireWS("dtdparser_S_after_FIXED_90");
                    n = this.nextToken();
                    if (n != 64) {
                        return this.error("dtdparser_expect_fixed_value_string_91");
                    }
                    attr.setDefault(this.fString);
                    attr.setFixed(true);
                    continue;
                }
                if (this.fValue.equals("#IMPLIED")) continue;
                return this.error("dtdparser_unrecognized_keyword_88");
            }
            if (n != 64) return this.error("dtdparser_expect__#REQUIRED,__#IMPLIED,_FIXED_or_default_92");
            attr.setDefault(this.fString);
        }
    }

    private Element getElement(String string) {
        Element element = (Element)this.fSchema.getElement(string);
        if (element == null) {
            element = new Element(string, this.fSchema);
            element.setUndefined(true);
            this.fSchema.addElement(element);
        }
        return element;
    }

    private ComplexType getComplexType(Element element) {
        ComplexType complexType = (ComplexType)element.getComplexType();
        if (complexType == null) {
            complexType = new ComplexType(this.fSchema);
            complexType.setElementModel(ANY_MODEL);
            complexType.setAttributeModel(DEFAULT_MODEL);
            element.setComplexType(complexType);
        }
        return complexType;
    }

    private Model getAttrModel(Element element) {
        ComplexType complexType = this.getComplexType(element);
        Model model = (Model)complexType.getAttributeModel();
        if (model == DEFAULT_MODEL) {
            model = new Model(3);
            complexType.setAttributeModel(model);
        }
        return model;
    }

    private boolean beginInclude() {
        int n = this.nextToken();
        if (n != 32 || !this.fValue.equals("INCLUDE") && !this.fValue.equals("IGNORE")) {
            return this.error("dtdparser_expect_INCLUDE_or_IGNORE_95");
        }
        String string = this.fValue;
        n = this.nextToken();
        if (n != 8192) {
            return this.error("dtdparser_expect_[_after_INCLUDE_or_IGNORE_96");
        }
        if (string.equals("INCLUDE")) {
            ++this.fInclude;
        } else {
            int n2 = 0;
            int n3 = this.fEnd - 2;
            int n4 = this.fPos;
            while (n4 < n3) {
                if (this.fBuf[n4] == '<' && this.fBuf[n4 + 1] == '!' && this.fBuf[n4 + 2] == '[') {
                    ++n2;
                } else if (this.fBuf[n4] == ']' && this.fBuf[n4 + 1] == ']' && this.fBuf[n4 + 2] == '>' && n2-- == 0) break;
                ++n4;
            }
            if (n4 == n3) {
                this.fPos = this.fEnd;
                return this.error("no matching ]]> for ignore");
            }
            this.fPos = n4 + 3;
        }
        return true;
    }

    private boolean endInclude() {
        if (this.fInclude == 0) {
            return this.error("dtdparser_unbalanced_]]>_98");
        }
        --this.fInclude;
        return true;
    }

    private boolean invalidToken(int n) {
        return this.error("dtdparser_invalid_token_99");
    }

    private boolean expandPE() {
        String string = this.parsePE();
        if (string.length() == 0) {
            return false;
        }
        return this.expandPE(string);
    }

    private boolean expandStmtPE() {
        return this.expandPE(this.fValue);
    }

    private boolean expandPE(String string) {
        try {
            Object object = this.fSchema.getPE(string);
            if (object == null) {
                return this.error("dtdparser_undef_parameter_entity_%{0};_100", string);
            }
            this.pushPE(string, object);
        }
        catch (Exception exception) {
            this.error("dtdparser_Error_getting_value_of_%{0};_-_{1}_101", string, exception.toString());
        }
        return true;
    }

    private int skipWS() {
        int n;
        while ((n = this.nextChar()) >= 0 && XMLCharacter.isWhitespace(n)) {
        }
        return n;
    }

    private void requireWS(String string) {
        int n = this.nextChar();
        if (!XMLCharacter.isWhitespace(n)) {
            this.error(string);
        }
        this.pushChar();
    }

    private void noWS(String string) {
        int n = this.nextChar();
        if (XMLCharacter.isWhitespace(n)) {
            this.error(string);
        }
        this.pushChar();
    }

    private boolean peekWS() {
        int n = this.nextChar();
        boolean bl = XMLCharacter.isWhitespace(n);
        this.pushChar();
        return bl;
    }

    private static class Entry {
        public char[] fBuf;
        public int fPos;
        public int fBeg;
        public int fEnd;
        public int fLin;
        public IExternalEntity fEnt;
        public String fNam;

        Entry() {
        }
    }
}

