/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.parsers;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.xml.XMLCharacter;

public class DoctypeParser {
    private String fRoot;
    private String fSys;
    private String fPub;
    private int fBeg;
    private int fEnd;
    private int fTag;
    private String fErr;
    private int fErrPos;
    private static final char[] fDoctype = new char[]{'<', '!', 'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private int fPos;
    private char[] fBuf;
    private int fBufEnd;

    public void setRoot(String string) {
        this.fRoot = string;
    }

    public String getRoot() {
        return this.fRoot;
    }

    public String setSys(String string) {
        this.fSys = string;
        return this.fSys;
    }

    public String getSys() {
        return this.fSys;
    }

    public String setPub(String string) {
        this.fPub = string;
        return this.fPub;
    }

    public String getPub() {
        return this.fPub;
    }

    public void setBeg(int n) {
        this.fBeg = n;
    }

    public int getBeg() {
        return this.fBeg;
    }

    public int setEnd(int n) {
        this.fEnd = n;
        return this.fEnd;
    }

    public int getEnd() {
        return this.fEnd;
    }

    public int setTag(int n) {
        this.fTag = n;
        return this.fTag;
    }

    public int getTag() {
        return this.fTag;
    }

    public String setErr(String string) {
        this.fErr = string;
        return this.fErr;
    }

    public String getErr() {
        return this.fErr;
    }

    public int setErrPos(int n) {
        this.fErrPos = n;
        return this.fErrPos;
    }

    public int getErrPos() {
        return this.fErrPos;
    }

    public DoctypeParser() {
        this.init();
    }

    public boolean parse(char[] cArray, int n, int n2) {
        int n3;
        this.init();
        this.fBuf = cArray;
        this.fBufEnd = n2;
        this.fPos = Misc.indexOf((char[])fDoctype, (int)0, (int)fDoctype.length, (char[])cArray, (int)n, (int)n2);
        if (this.fPos < 0) {
            return this.error(Local.getString((String)"doctype_not_found_1"));
        }
        this.fPos += fDoctype.length;
        this.skipWS();
        if (this.eof()) {
            return this.error(Local.getString((String)"doctype_eof_root_name_2"));
        }
        int n4 = this.fPos;
        this.skipID();
        if (this.fPos == n4) {
            return this.error(Local.getString((String)"doctype_no_root_name_3"));
        }
        this.setRoot(new String(this.fBuf, n4, this.fPos - n4));
        this.skipWS();
        if (this.eof()) {
            return this.error(Local.getString((String)"doctype_eof_PUBLIC,_SYSTEM,_[_or_>_4"));
        }
        int n5 = this.fPos;
        this.skipID();
        if (this.fPos > n5) {
            String string = new String(this.fBuf, n5, this.fPos - n5);
            if (string.equals("PUBLIC")) {
                this.skipWS();
                if (this.eof() || this.fBuf[this.fPos] != '\'' && this.fBuf[this.fPos] != '\"') {
                    return this.error(Local.getString((String)"doctype_missing_public_id_6"));
                }
                n3 = this.fPos + 1;
                if (!this.scanString()) {
                    return this.error(Local.getString((String)Local.getString((String)"doctype_unterm_public_id_1")));
                }
                this.setPub(new String(this.fBuf, n3, this.fPos - n3 - 1));
            } else if (!string.equals("SYSTEM")) {
                return this.error(Local.format((String)"doctype_expect_PUBLIC_or_SYSTEM,_found_{0}_8", (Object)string));
            }
            this.skipWS();
            if (this.eof() || this.fBuf[this.fPos] != '\'' && this.fBuf[this.fPos] != '\"') {
                return this.error(Local.getString((String)"doctype_missing_system_id_9"));
            }
            n3 = this.fPos + 1;
            if (!this.scanString()) {
                return this.error(Local.getString((String)Local.getString((String)"doctype_unterm_system_id_2")));
            }
            this.setSys(new String(this.fBuf, n3, this.fPos - n3 - 1));
        }
        this.skipWS();
        if (this.eof()) {
            return this.error(Local.getString((String)"doctype_eof_looking_for_[_or_>_10"));
        }
        char c = this.fBuf[this.fPos];
        if (c == '[') {
            ++this.fPos;
            this.setBeg(this.fPos);
            n3 = 0;
            while (this.fPos < this.fBufEnd) {
                this.setEnd(this.fPos);
                char c2 = this.fBuf[this.fPos++];
                if (c2 == ']') {
                    if (this.fPos + 1 < this.fBufEnd && this.fBuf[this.fPos] == ']' && this.fBuf[this.fPos + 1] == '>') {
                        this.fPos += 2;
                        continue;
                    }
                    n3 = 1;
                    break;
                }
                if (c2 == '\'' || c2 == '\"') {
                    --this.fPos;
                    if (this.scanString()) continue;
                    return this.error(Local.getString((String)"doctype_eof_in_string_in_internal_subset_11"));
                }
                if (c2 != '<' || this.fPos + 2 >= this.fBufEnd || this.fBuf[this.fPos] != '!' || this.fBuf[this.fPos + 1] != '-' || this.fBuf[this.fPos + 2] != '-') continue;
                this.fPos += 3;
                if (this.scanComment()) continue;
                return false;
            }
            if (n3 == 0) {
                return this.error(Local.getString((String)"doctype_eof_looking_for_]_12"));
            }
            this.skipWS();
            if (this.eof()) {
                return this.error(Local.getString((String)"doctype_eof_looking_for_>_13"));
            }
            c = this.fBuf[this.fPos];
        }
        if (this.eof()) {
            return this.error(Local.getString((String)"doctype_eof_looking_for_>_1"));
        }
        if (c != '>') {
            return this.error(Local.format((String)"doctype_expecting_>_at_end_of_DOCTYPE,_found___{0}___14", (Object)("" + c)));
        }
        this.setTag(this.fPos + 1);
        return true;
    }

    private void init() {
        this.setRoot(this.setPub(this.setSys(this.setErr(null))));
        this.setBeg(this.setEnd(this.setTag(this.setErrPos(-1))));
    }

    private void skipWS() {
        while (this.fPos < this.fBufEnd && XMLCharacter.isWhitespace(this.fBuf[this.fPos])) {
            ++this.fPos;
        }
    }

    private void skipID() {
        if (this.fPos < this.fBufEnd && XMLCharacter.isIDStart(this.fBuf[this.fPos])) {
            ++this.fPos;
            while (this.fPos < this.fBufEnd && XMLCharacter.isIDPart(this.fBuf[this.fPos])) {
                ++this.fPos;
            }
        }
    }

    private boolean scanString() {
        char c;
        if (this.fPos < this.fBufEnd && ((c = this.fBuf[this.fPos]) == '\'' || c == '\"')) {
            ++this.fPos;
            char c2 = '\u0000';
            while (this.fPos < this.fBufEnd && (c2 = this.fBuf[this.fPos]) != c) {
                ++this.fPos;
            }
            if (c2 != c) {
                return false;
            }
            ++this.fPos;
        } else {
            return false;
        }
        return true;
    }

    private boolean scanComment() {
        while (this.fPos < this.fBufEnd) {
            if (this.fBuf[this.fPos++] != '-') continue;
            if (this.fPos == this.fBufEnd) break;
            if (this.fBuf[this.fPos++] != '-') continue;
            if (this.fPos == this.fBufEnd) break;
            if (this.fBuf[this.fPos] != '>') {
                return this.error(Local.getString((String)"doctype_--_inside_comment_16"));
            }
            ++this.fPos;
            return true;
        }
        return this.error(Local.getString((String)"doctype_unterminated_comment_17"));
    }

    private boolean eof() {
        return this.fPos >= this.fBufEnd;
    }

    private boolean error(String string) {
        return this.errorCommon(Local.getString((String)string));
    }

    private boolean error(String string, String string2) {
        return this.errorCommon(Local.format((String)string, (Object)string2));
    }

    private boolean errorCommon(String string) {
        this.setErrPos(this.fPos);
        this.setErr(string);
        return false;
    }
}

