/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.schema.impl;

import com.objfac.xml.schema.IAny;
import com.objfac.xml.schema.IAtom;
import com.objfac.xml.schema.IModel;
import com.objfac.xml.schema.impl.Nfm;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Model
implements IModel {
    public static final IModel EMPTYMODEL = new Model(6);
    protected int fKind;
    protected int fMin = 1;
    protected int fMax = 1;
    protected int fNum = 0;
    protected IModel[] fContents;
    protected List fContentsList;
    protected IAtom fLeaf;
    protected boolean fMixed;
    protected static IModel[] fEmptyContents = new IModel[0];
    protected static final String[] fOps = new String[]{"?", ",", "|", "&", "!!!"};
    private LinkedList fAny;

    public Model(int n) {
        this.fKind = n;
    }

    public Model() {
        this.fKind = 0;
    }

    public int getKind() {
        return this.fKind;
    }

    public int getMinOccurs() {
        return this.fMin;
    }

    public int getMaxOccurs() {
        return this.fMax;
    }

    public IModel[] getContents() {
        if (this.fContents == null) {
            if (this.fContentsList != null) {
                this.fContents = this.fContentsList.toArray(new IModel[this.fContentsList.size()]);
                this.fContentsList = null;
            } else {
                this.fContents = fEmptyContents;
            }
        }
        return this.fContents;
    }

    public IAtom getLeaf() {
        return this.fLeaf;
    }

    public void setKind(int n) {
        this.fKind = n;
    }

    public void setMinOccurs(int n) {
        this.fMin = n;
    }

    public void setMaxOccurs(int n) {
        this.fMax = n;
    }

    public void setContents(IModel[] iModelArray) {
        this.fContents = iModelArray;
    }

    public void addModel(IModel iModel) {
        if (this.fContents != null) {
            throw new IllegalStateException("model may not be changed once its contents have been requested");
        }
        if (this.fContentsList == null) {
            this.fContentsList = new LinkedList();
        }
        this.fContentsList.add(iModel);
    }

    public void setLeaf(IAtom iAtom) {
        this.fLeaf = iAtom;
    }

    public String getOperator() {
        return fOps[this.fKind];
    }

    public String getQualifier() {
        return this.fMin == 1 ? (this.fMax == Integer.MAX_VALUE ? "+" : "") : (this.fMax == Integer.MAX_VALUE ? "*" : "?");
    }

    public boolean isMixed() {
        return this.fMixed;
    }

    public void setMixed(boolean bl) {
        this.fMixed = bl;
    }

    public Nfm toNfm() {
        Nfm nfm = null;
        switch (this.fKind) {
            case 1: 
            case 2: 
            case 3: {
                IModel[] iModelArray = this.getContents();
                if (iModelArray == null || iModelArray.length == 0) {
                    nfm = null;
                    break;
                }
                nfm = iModelArray[0].toNfm();
                int n = 1;
                while (n < iModelArray.length) {
                    Nfm nfm2 = iModelArray[n].toNfm();
                    nfm = this.fKind == 1 ? Nfm.getComma(nfm, nfm2) : Nfm.getOr(nfm, nfm2);
                    ++n;
                }
                break;
            }
            case 4: {
                nfm = Nfm.getNfm(this.fLeaf);
            }
        }
        return this.qualifyNfm(nfm);
    }

    private Nfm qualifyNfm(Nfm nfm) {
        if (nfm == null) {
            return null;
        }
        if (this.fMin == 1 && this.fMax == 1) {
            return nfm;
        }
        if (this.fMin == 0 && this.fMax == 1) {
            return Nfm.getQuestion(nfm);
        }
        if (this.fMin == 0 && this.fMax == Integer.MAX_VALUE) {
            return Nfm.getStar(nfm);
        }
        if (this.fMin == 1 && this.fMax == Integer.MAX_VALUE) {
            return Nfm.getPlus(nfm);
        }
        if (this.fMax == 0) {
            return Nfm.getNfm(null);
        }
        if (this.fMax == Integer.MAX_VALUE) {
            return Nfm.getUnbounded(nfm, this.fMin);
        }
        return Nfm.getMinMax(nfm, this.fMin, this.fMax);
    }

    public List getAny() {
        return this.fAny;
    }

    public void addAny(IAny iAny) {
        if (this.fAny == null) {
            this.fAny = new LinkedList();
        }
        this.fAny.add(iAny);
    }

    public Model shallowCopy() {
        Model model;
        block3: {
            block2: {
                model = new Model(this.getKind());
                model.fMixed = this.fMixed;
                model.fLeaf = this.fLeaf;
                if (this.fContents == null) break block2;
                model.fContentsList = new LinkedList();
                int n = 0;
                while (n < this.fContents.length) {
                    model.fContentsList.add(this.fContents[n]);
                    ++n;
                }
                break block3;
            }
            if (this.fContentsList == null) break block3;
            model.fContentsList = new LinkedList();
            Iterator iterator = this.fContentsList.iterator();
            while (iterator.hasNext()) {
                model.fContentsList.add(iterator.next());
            }
        }
        return model;
    }
}

