/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.xml.schema.impl;

import com.objfac.util.Misc;
import com.objfac.xml.io.Encoding;
import com.objfac.xml.io.IDocumentReaderFactory;
import com.objfac.xml.schema.IAttr;
import com.objfac.xml.schema.IAttrGroup;
import com.objfac.xml.schema.IComment;
import com.objfac.xml.schema.IComplexType;
import com.objfac.xml.schema.IElement;
import com.objfac.xml.schema.IEntity;
import com.objfac.xml.schema.IExternalEntity;
import com.objfac.xml.schema.IGroup;
import com.objfac.xml.schema.IIdentityConstraint;
import com.objfac.xml.schema.IModel;
import com.objfac.xml.schema.INotation;
import com.objfac.xml.schema.ISchema;
import com.objfac.xml.schema.ISchemaError;
import com.objfac.xml.schema.ISimpleType;
import com.objfac.xml.schema.ISubstitutionGroup;
import com.objfac.xml.schema.QName;
import com.objfac.xml.schema.impl.Attr;
import com.objfac.xml.schema.impl.ComplexType;
import com.objfac.xml.schema.impl.Element;
import com.objfac.xml.schema.impl.Entity;
import com.objfac.xml.schema.impl.EnumFacet;
import com.objfac.xml.schema.impl.ExternalEntity;
import com.objfac.xml.schema.impl.Facet;
import com.objfac.xml.schema.impl.Markup;
import com.objfac.xml.schema.impl.Model;
import com.objfac.xml.schema.impl.ProcessingInstruction;
import com.objfac.xml.schema.impl.SchemaError;
import com.objfac.xml.schema.impl.SimpleType;
import com.objfac.xml.schema.impl.SubstitutionGroup;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Schema
extends Markup
implements ISchema {
    protected String fTargetNamespace;
    private boolean fElementFormDefault;
    private boolean fAttributeFormDefault;
    private int fBlockDefault;
    private int fFinalDefault;
    private String fSchemaLocation;
    private HashMap fIdentityConstraints = new HashMap();
    private boolean fIsDTD;
    private Schema fBase;
    private HashMap fSchemas;
    private HashMap fElements = new HashMap();
    private IElement[] fElementArray;
    private HashMap fAttrs = new HashMap();
    private IAttr[] fAttrArray;
    private HashMap fSimpleTypes = new HashMap();
    private ISimpleType[] fSimpleTypeArray;
    private HashMap fComplexTypes = new HashMap();
    private IComplexType[] fComplexTypeArray;
    private HashMap fAttrGroups = new HashMap();
    private IAttrGroup[] fAttrGroupArray;
    private HashMap fGroups = new HashMap();
    private IGroup[] fGroupArray;
    private HashMap fPEs = new HashMap();
    private HashMap fGEs = new HashMap();
    private static HashMap fPDIGEs = new HashMap();
    private IExternalEntity fEntity;
    private ISchemaError[] fErrors;
    private LinkedList fErrorList;
    private static final SchemaError[] NO_ERRORS;
    private IDocumentReaderFactory fFactory;
    private HashMap fNotations;
    private Element fXmlDecl;
    private SubstitutionGroup fTmpSub = new SubstitutionGroup(null, null);
    private HashMap fSubs;

    static {
        fPDIGEs.put("lt", "<");
        fPDIGEs.put("gt", ">");
        fPDIGEs.put("amp", "&");
        fPDIGEs.put("apos", "'");
        fPDIGEs.put("quot", "\"");
        NO_ERRORS = new SchemaError[0];
    }

    public boolean isDTD() {
        return this.fIsDTD;
    }

    public boolean isXMLSchema() {
        return !this.fIsDTD;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public void setTargetNamespace(String string) {
        this.fTargetNamespace = string == null ? null : string.intern();
        this.addSchema(this);
    }

    public void setElementFormDefault(boolean bl) {
        this.fElementFormDefault = bl;
    }

    public boolean getElementFormDefault() {
        return this.fElementFormDefault;
    }

    public void setAttributeFormDefault(boolean bl) {
        this.fAttributeFormDefault = bl;
    }

    public boolean getAttributeFormDefault() {
        return this.fAttributeFormDefault;
    }

    public void setBlockDefault(int n) {
        this.fBlockDefault = n;
    }

    public int getBlockDefault() {
        return this.fBlockDefault;
    }

    public void setFinalDefault(int n) {
        this.fFinalDefault = n;
    }

    public int getFinalDefault() {
        return this.fFinalDefault;
    }

    public ISchema getSchemaForNamespace(String string) {
        return this.fSchemas == null ? null : (Schema)this.fSchemas.get(string);
    }

    private void putSchema(Schema schema) {
        String string = schema.getTargetNamespace();
        if (this.fSchemas == null) {
            this.fSchemas = new HashMap();
        }
        this.fSchemas.put(string, schema);
    }

    public void addSchema(Schema schema) {
        Schema schema2;
        if (this.fSchemas == null) {
            this.fSchemas = new HashMap();
        }
        if ((schema2 = (Schema)this.fSchemas.get(schema.getTargetNamespace())) != null) {
            schema2.addBase(schema);
        } else {
            this.putSchema(schema);
        }
        if (schema != this && schema.fSchemas != null) {
            Iterator iterator = schema.fSchemas.values().iterator();
            schema.fSchemas = null;
            while (iterator.hasNext()) {
                Schema schema3 = (Schema)iterator.next();
                if (schema3 == schema) continue;
                this.addSchema(schema3);
            }
        }
    }

    public IElement getElement(String string) {
        return this.getElement(null, string);
    }

    public IElement getElement(String string, String string2) {
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return schema != null ? schema.internalGetElement(string2) : null;
    }

    private IElement internalGetElement(String string) {
        IElement iElement = null;
        if (this.fBase != null) {
            iElement = this.fBase.internalGetElement(string);
        }
        if (iElement == null) {
            iElement = (IElement)this.fElements.get(string);
        }
        return iElement;
    }

    public IAttr getAttr(String string, String string2) {
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return schema != null ? schema.internalGetAttr(string2) : null;
    }

    private IAttr internalGetAttr(String string) {
        IAttr iAttr;
        return this.fBase != null && (iAttr = this.fBase.internalGetAttr(string)) != null ? iAttr : (IAttr)this.fAttrs.get(string);
    }

    public ISimpleType getSimpleType(String string, String string2) {
        if (string != null && string.equals("http://www.w3.org/2001/XMLSchema") && (!string.equals(this.fTargetNamespace) || string2.equals("anySimpleType") || string2.equals("anyType"))) {
            return SimpleType.getXMLSimpleType(string2);
        }
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return schema != null ? schema.internalGetSimpleType(string2) : null;
    }

    private ISimpleType internalGetSimpleType(String string) {
        ISimpleType iSimpleType;
        if (this.fBase != null && (iSimpleType = this.fBase.internalGetSimpleType(string)) != null) {
            return iSimpleType;
        }
        return (ISimpleType)this.fSimpleTypes.get(string);
    }

    public IComplexType getComplexType(String string, String string2) {
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return schema != null ? schema.internalGetComplexType(string2) : null;
    }

    private IComplexType internalGetComplexType(String string) {
        IComplexType iComplexType;
        return this.fBase != null && (iComplexType = this.fBase.internalGetComplexType(string)) != null ? iComplexType : (IComplexType)this.fComplexTypes.get(string);
    }

    public IAttrGroup getAttrGroup(String string, String string2) {
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return schema != null ? schema.internalGetAttrGroup(string2) : null;
    }

    private IAttrGroup internalGetAttrGroup(String string) {
        IAttrGroup iAttrGroup;
        return this.fBase != null && (iAttrGroup = this.fBase.internalGetAttrGroup(string)) != null ? iAttrGroup : (IAttrGroup)this.fAttrGroups.get(string);
    }

    public IGroup getGroup(String string, String string2) {
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return schema != null ? schema.internalGetGroup(string2) : null;
    }

    private IGroup internalGetGroup(String string) {
        IGroup iGroup;
        return this.fBase != null && (iGroup = this.fBase.internalGetGroup(string)) != null ? iGroup : (IGroup)this.fGroups.get(string);
    }

    public String getGEValue(String string) throws IOException, MalformedURLException {
        Object object;
        String string2;
        if (this.fBase != null && (string2 = this.fBase.getGEValue(string)) != null) {
            return string2;
        }
        string2 = null;
        Entity entity = (Entity)this.fGEs.get(string);
        string2 = entity != null ? ((object = entity.getValue()) instanceof String ? (String)object : ((IExternalEntity)object).getStringContents()) : (String)fPDIGEs.get(string);
        return string2;
    }

    public String getPEValue(String string) throws IOException, MalformedURLException {
        String string2;
        if (this.fBase != null && (string2 = this.fBase.getPEValue(string)) != null) {
            return string2;
        }
        string2 = null;
        Object v = this.fPEs.get(string);
        if (v instanceof String) {
            string2 = (String)v;
        } else if (v instanceof ExternalEntity) {
            ExternalEntity externalEntity = (ExternalEntity)v;
            string2 = this.getExternal(externalEntity);
        }
        return string2;
    }

    public IEntity getGE(String string) {
        IEntity iEntity;
        return this.fBase != null && (iEntity = this.fBase.getGE(string)) != null ? iEntity : (IEntity)this.fGEs.get(string);
    }

    public Object getPE(String string) {
        Object object;
        return this.fBase != null && (object = this.fBase.getPE(string)) != null ? object : this.fPEs.get(string);
    }

    public List getElements() {
        LinkedList linkedList = new LinkedList();
        this.getElements(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                Schema schema = (Schema)iterator.next();
                if (schema == this) continue;
                schema.getElements(linkedList);
            }
        }
        return linkedList;
    }

    private void getElements(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getElements(linkedList);
        }
        linkedList.addAll(this.fElements.values());
    }

    public List getAttrs() {
        LinkedList linkedList = new LinkedList();
        this.getAttrs(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getAttrs(linkedList);
            }
        }
        return linkedList;
    }

    private void getAttrs(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getAttrs(linkedList);
        }
        linkedList.addAll(this.fAttrs.values());
    }

    public List getSimpleTypes() {
        LinkedList linkedList = new LinkedList();
        this.getSimpleTypes(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getSimpleTypes(linkedList);
            }
        }
        return linkedList;
    }

    private void getSimpleTypes(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getSimpleTypes(linkedList);
        }
        linkedList.addAll(this.fSimpleTypes.values());
    }

    public List getComplexTypes() {
        LinkedList linkedList = new LinkedList();
        this.getComplexTypes(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getComplexTypes(linkedList);
            }
        }
        return linkedList;
    }

    private void getComplexTypes(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getComplexTypes(linkedList);
        }
        linkedList.addAll(this.fComplexTypes.values());
    }

    public List getAttrGroups() {
        LinkedList linkedList = new LinkedList();
        this.getAttrGroups(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getAttrGroups(linkedList);
            }
        }
        return linkedList;
    }

    private void getAttrGroups(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getAttrGroups(linkedList);
        }
        linkedList.addAll(this.fAttrGroups.values());
    }

    public List getGroups() {
        LinkedList linkedList = new LinkedList();
        this.getGroups(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getGroups(linkedList);
            }
        }
        return linkedList;
    }

    private void getGroups(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getGroups(linkedList);
        }
        linkedList.addAll(this.fGroups.values());
    }

    public boolean addElement(IElement iElement) {
        String string = iElement.getName();
        if (this.getElement(string) != null) {
            return false;
        }
        this.fElements.put(string, iElement);
        this.addMarkup(iElement);
        return true;
    }

    public boolean addAttr(IAttr iAttr) {
        String string = iAttr.getLocalName();
        if (this.internalGetAttr(string) != null) {
            return false;
        }
        this.fAttrs.put(string, iAttr);
        this.addMarkup(iAttr);
        return true;
    }

    public boolean addSimpleType(ISimpleType iSimpleType) {
        String string = iSimpleType.getLocalName();
        if (this.fSimpleTypes.get(string) != null) {
            return false;
        }
        this.fSimpleTypes.put(string, iSimpleType);
        this.addMarkup(iSimpleType);
        return true;
    }

    public boolean addComplexType(IComplexType iComplexType) {
        String string = iComplexType.getLocalName();
        if (this.fComplexTypes.get(string) != null) {
            return false;
        }
        this.fComplexTypes.put(string, iComplexType);
        this.addMarkup(iComplexType);
        return true;
    }

    public boolean addAttrGroup(IAttrGroup iAttrGroup) {
        String string = iAttrGroup.getLocalName();
        if (this.fAttrGroups.get(string) != null) {
            return false;
        }
        this.fAttrGroups.put(string, iAttrGroup);
        this.addMarkup(iAttrGroup);
        return true;
    }

    public boolean addGroup(IGroup iGroup) {
        String string = iGroup.getLocalName();
        if (this.fGroups.get(string) != null) {
            return false;
        }
        this.fGroups.put(string, iGroup);
        this.addMarkup(iGroup);
        return true;
    }

    public boolean redefineSimpleType(ISimpleType iSimpleType) {
        String string = iSimpleType.getLocalName();
        this.fSimpleTypes.put(string, iSimpleType);
        this.addMarkup(iSimpleType);
        return true;
    }

    public boolean redefineComplexType(IComplexType iComplexType) {
        String string = iComplexType.getLocalName();
        this.fComplexTypes.put(string, iComplexType);
        this.addMarkup(iComplexType);
        return true;
    }

    public boolean redefineAttrGroup(IAttrGroup iAttrGroup) {
        String string = iAttrGroup.getLocalName();
        this.fAttrGroups.put(string, iAttrGroup);
        this.addMarkup(iAttrGroup);
        return true;
    }

    public boolean redefineGroup(IGroup iGroup) {
        String string = iGroup.getLocalName();
        this.fGroups.put(string, iGroup);
        this.addMarkup(iGroup);
        return true;
    }

    public boolean addGE(String string, String string2) {
        if (this.hasGE(string)) {
            return false;
        }
        Entity entity = new Entity(string, (Object)string2, this);
        this.fGEs.put(string, entity);
        this.addMarkup(entity);
        return true;
    }

    private boolean hasGE(String string) {
        if (this.fBase != null && this.fBase.hasGE(string)) {
            return false;
        }
        return this.fGEs.get(string) != null;
    }

    private boolean hasPE(String string) {
        if (this.fBase != null && this.fBase.hasPE(string)) {
            return false;
        }
        return this.fPEs.get(string) != null;
    }

    public boolean addExternalGE(String string, String string2, String string3, String string4, IExternalEntity iExternalEntity) {
        if (this.hasGE(string)) {
            return false;
        }
        Entity entity = new Entity(string, iExternalEntity.getEntity(string2, string3), string4, this);
        this.fGEs.put(string, entity);
        return true;
    }

    public boolean addExternalGE(String string, String string2, String string3, IExternalEntity iExternalEntity) {
        if (this.hasGE(string)) {
            return false;
        }
        Entity entity = new Entity(string, iExternalEntity.getEntity(string2, string3), this);
        this.fGEs.put(string, entity);
        return true;
    }

    public boolean addPE(String string, String string2) {
        if (this.hasPE(string)) {
            return false;
        }
        this.fPEs.put(string, string2);
        return true;
    }

    public boolean addExternalPE(String string, String string2, String string3, IExternalEntity iExternalEntity) {
        if (this.hasPE(string)) {
            return false;
        }
        this.fPEs.put(string, iExternalEntity.getEntity(string2, string3));
        return true;
    }

    public Schema(boolean bl, IDocumentReaderFactory iDocumentReaderFactory) {
        super(32);
        this.fIsDTD = bl;
        this.fFactory = iDocumentReaderFactory;
        if (bl) {
            this.setTargetNamespace(null);
        }
    }

    public Schema(Schema schema, boolean bl, IDocumentReaderFactory iDocumentReaderFactory) {
        this(bl, iDocumentReaderFactory);
        this.fBase = schema;
    }

    public Schema(boolean bl, IExternalEntity iExternalEntity) {
        super(32);
        this.fIsDTD = bl;
        this.fFactory = iExternalEntity.getFactory();
        this.fEntity = iExternalEntity;
        if (bl) {
            this.setTargetNamespace(null);
        }
    }

    public void addBase(Schema schema) {
        String string = schema.getSchemaLocation();
        if (string != null && string.equals(this.getSchemaLocation())) {
            return;
        }
        if (this.fBase != null) {
            this.fBase.addBase(schema);
        } else {
            this.fBase = schema;
        }
    }

    private String getExternal(IExternalEntity iExternalEntity) throws IOException {
        return iExternalEntity.getStringContents();
    }

    public ISchemaError[] getErrors() {
        if (this.fErrors == null) {
            this.fErrors = this.fErrorList == null ? NO_ERRORS : this.fErrorList.toArray(new SchemaError[this.fErrorList.size()]);
            this.fErrorList = null;
        }
        return this.fErrors;
    }

    public List getErrorList() {
        if (this.fErrorList != null) {
            return this.fErrorList;
        }
        if (this.fErrors != null) {
            return Arrays.asList(this.fErrors);
        }
        return new LinkedList();
    }

    public void addError(ISchemaError iSchemaError) {
        if (this.fErrorList == null) {
            this.fErrorList = Misc.arrayToList((Object[])this.fErrors);
            this.fErrors = null;
        }
        this.fErrorList.add(iSchemaError);
    }

    public IEntity[] getEntities() {
        LinkedList linkedList = new LinkedList();
        this.internalGetEntities(linkedList, new HashSet());
        IEntity[] iEntityArray = linkedList.toArray(new IEntity[linkedList.size()]);
        Arrays.sort(iEntityArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((IEntity)object).getName().compareTo(((IEntity)object2).getName());
            }

            public boolean equals(Object object) {
                return object == this;
            }
        });
        return iEntityArray;
    }

    private void internalGetEntities(LinkedList linkedList, HashSet hashSet) {
        if (this.fBase != null) {
            this.internalGetEntities(linkedList, hashSet);
        }
        Iterator iterator = this.fGEs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if (hashSet.contains(string)) continue;
            linkedList.add(entry.getValue());
        }
    }

    public boolean addNotation(INotation iNotation) {
        String string;
        HashMap hashMap = this.notations();
        if (!hashMap.containsKey(string = iNotation.getName())) {
            hashMap.put(string, iNotation);
            this.addMarkup(iNotation);
            return true;
        }
        return false;
    }

    public INotation getNotation(String string) {
        return (INotation)this.notations().get(string);
    }

    public INotation[] getNotations() {
        HashMap hashMap = this.notations();
        return hashMap.values().toArray(new INotation[hashMap.size()]);
    }

    private HashMap notations() {
        if (this.fNotations == null) {
            this.fNotations = new HashMap();
        }
        return this.fNotations;
    }

    public boolean addPI(String string, String string2) {
        this.addMarkup(new ProcessingInstruction(string, string2, this));
        return true;
    }

    public boolean addComment(IComment iComment) {
        this.addMarkup(iComment);
        return true;
    }

    public IElement getJspTag(String string) {
        return null;
    }

    public IElement getXmlDecl() {
        if (this.fXmlDecl == null) {
            this.fXmlDecl = new Element("?xml", this);
            ComplexType complexType = new ComplexType(this);
            this.fXmlDecl.setComplexType(complexType);
            complexType.setEmpty(true);
            complexType.setElementModel(Model.EMPTYMODEL);
            Model model = new Model(1);
            complexType.setAttributeModel(model);
            IModel[] iModelArray = new IModel[3];
            model.setContents(iModelArray);
            Model model2 = new Model(4);
            iModelArray[0] = model2;
            Attr attr = new Attr("version", this);
            attr.setSimpleType(new SimpleType("string", this));
            attr.setFixed(true);
            attr.setDefault("1.0");
            model2.setLeaf(attr);
            model2 = new Model(4);
            iModelArray[1] = model2;
            model2.setMinOccurs(0);
            attr = new Attr("encoding", this);
            SimpleType simpleType = new SimpleType("string", this);
            attr.setSimpleType(simpleType);
            EnumFacet enumFacet = new EnumFacet();
            enumFacet.setEnum(Encoding.getStandardEncodings());
            Facet[] facetArray = new Facet[]{enumFacet};
            simpleType.setFacets(facetArray);
            model2.setLeaf(attr);
            model2 = new Model(4);
            iModelArray[2] = model2;
            model2.setMinOccurs(0);
            attr = new Attr("standalone", this);
            simpleType = new SimpleType("string", this);
            attr.setSimpleType(simpleType);
            enumFacet = new EnumFacet();
            enumFacet.setEnum(new String[]{"yes", "no"});
            facetArray = new Facet[]{enumFacet};
            simpleType.setFacets(facetArray);
            model2.setLeaf(attr);
        }
        return this.fXmlDecl;
    }

    public String getSchemaLocation() {
        return this.fSchemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.fSchemaLocation = string;
    }

    public boolean addIdentityConstraint(IIdentityConstraint iIdentityConstraint) {
        String string = iIdentityConstraint.getName();
        if (this.fIdentityConstraints.get(string) != null) {
            return false;
        }
        this.fIdentityConstraints.put(string, iIdentityConstraint);
        return true;
    }

    public IIdentityConstraint getIdentityConstraint(String string, String string2) {
        Schema schema = (Schema)this.getSchemaForNamespace(string);
        return (IIdentityConstraint)schema.fIdentityConstraints.get(string2);
    }

    public List getIdentityConstraints() {
        LinkedList linkedList = new LinkedList();
        this.getIdentityConstraints(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getIdentityConstraints(linkedList);
            }
        }
        return linkedList;
    }

    private void getIdentityConstraints(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getIdentityConstraints(linkedList);
        }
        linkedList.addAll(this.fIdentityConstraints.values());
    }

    public void addSubstitution(IElement iElement, Element element) {
        this.addSubstitution(iElement.getNamespace(), iElement.getLocalName(), element);
    }

    public void addSubstitution(String string, String string2, Element element) {
        SubstitutionGroup substitutionGroup;
        this.fTmpSub.setName(string, string2);
        if (this.fSubs == null) {
            this.fSubs = new HashMap();
        }
        if ((substitutionGroup = (SubstitutionGroup)this.fSubs.get(this.fTmpSub)) == null) {
            substitutionGroup = new SubstitutionGroup(string, string2);
            this.fSubs.put(substitutionGroup, substitutionGroup);
        }
        substitutionGroup.addSubstitution(element);
    }

    public void addSubstitution(QName qName, Element element) {
        this.addSubstitution(qName.namespace, qName.localname, element);
    }

    public ISubstitutionGroup getSubstitutionGroup(String string, String string2) {
        this.fTmpSub.setName(string, string2);
        return (ISubstitutionGroup)this.fSubs.get(this.fTmpSub);
    }

    public List getSubstitutionGroups() {
        LinkedList linkedList = new LinkedList();
        this.getSubstitutionGroups(linkedList);
        if (this.fSchemas != null) {
            Iterator iterator = this.fSchemas.values().iterator();
            while (iterator.hasNext()) {
                ((Schema)iterator.next()).getSubstitutionGroups(linkedList);
            }
        }
        return linkedList;
    }

    private void getSubstitutionGroups(LinkedList linkedList) {
        if (this.fBase != null) {
            this.fBase.getSubstitutionGroups(linkedList);
        }
        linkedList.addAll(this.fSubs.values());
    }

    private static class ExternalGE
    extends ExternalEntity {
        public String fNot;

        public ExternalGE(String string, String string2, String string3, IExternalEntity iExternalEntity) {
            super((ExternalEntity)iExternalEntity, string, string2, iExternalEntity.getFactory());
            this.fNot = string3;
        }
    }
}

