/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.style;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.sse.core.internal.model.ModelManagerImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.ISemanticHighlighting;
import org.eclipse.wst.sse.ui.ISemanticHighlightingExtension;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingManager;
import org.eclipse.wst.sse.ui.internal.style.SemanticHighlightingPresenter;

public class SemanticHighlightingReconciler
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private IDocument fDocument;
    private ITextViewer fViewer;
    private SemanticHighlightingPresenter fPresenter;
    private ISemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fHighlightings;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;
    private ISemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.HighlightingStyle[] fJobHighlightings;
    private boolean fIsInstalled;

    public void install(ITextViewer sourceViewer, SemanticHighlightingPresenter presenter, ISemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.HighlightingStyle[] highlightings) {
        this.fViewer = sourceViewer;
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fIsInstalled = true;
    }

    public void uninstall() {
        this.fIsInstalled = false;
        this.fViewer = null;
        this.fPresenter = null;
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(IRegion partition) {
        var2_2 = this.fReconcileLock;
        synchronized (var2_2) {
            if (this.fIsReconciling) {
                return;
            }
            this.fIsReconciling = true;
        }
        this.fJobPresenter = this.fPresenter;
        this.fJobSemanticHighlightings = this.fSemanticHighlightings;
        this.fJobHighlightings = this.fHighlightings;
        model = null;
        try {
            block32: {
                block31: {
                    if (this.fJobPresenter == null || this.fJobSemanticHighlightings == null || this.fJobHighlightings == null) break block31;
                    if (this.fDocument != null) break block32;
                }
                var10_3 = null;
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                this.fJobHighlightings = null;
                if (model != null) {
                    model.releaseFromRead();
                }
                var12_6 = this.fReconcileLock;
                synchronized (var12_6) {
                    this.fIsReconciling = false;
                    return;
                }
            }
            this.fJobPresenter.setCanceled(false);
            this.startReconcilingPositions();
            document = (IStructuredDocument)this.fDocument;
            model = ModelManagerImpl.getInstance().getModelForRead(document);
            regions = document.getStructuredDocumentRegions(partition.getOffset(), partition.getLength());
            i = 0;
            if (true) ** GOTO lbl58
            {
                catch (Throwable v1) {
                    throw v1;
                }
            }
            do {
                if (document.containsReadOnly(regions[i].getStartOffset(), regions[i].getLength())) {
                    this.addPosition(new Position(regions[i].getStartOffset(), regions[i].getLength()), null, true);
                } else {
                    j = 0;
                    while (j < this.fJobSemanticHighlightings.length && this.fIsInstalled) {
                        if (this.fJobHighlightings[j].isEnabled()) {
                            consumes = null;
                            consumes = this.fJobSemanticHighlightings[j] instanceof ISemanticHighlightingExtension != false && model != null ? ((ISemanticHighlightingExtension)this.fJobSemanticHighlightings[j]).consumes(regions[i], model.getIndexedRegion(regions[i].getStartOffset())) : this.fJobSemanticHighlightings[j].consumes(regions[i]);
                            if (consumes != null) {
                                k = 0;
                                while (k < consumes.length) {
                                    this.addPosition(consumes[k], this.fJobHighlightings[j]);
                                    ++k;
                                }
                            }
                        }
                        ++j;
                    }
                }
                ++i;
lbl58:
                // 2 sources

            } while (i < regions.length && this.fIsInstalled);
            if (this.fIsInstalled) {
                oldPositions = this.fRemovedPositions;
                newPositions = new ArrayList<E>(this.fNOfRemovedPositions);
                i = 0;
                n = oldPositions.size();
                while (i < n && this.fIsInstalled) {
                    current = oldPositions.get(i);
                    if (current != null) {
                        newPositions.add(current);
                    }
                    ++i;
                }
                this.fRemovedPositions = newPositions;
                presentation = null;
                if (!this.fJobPresenter.isCanceled()) {
                    presentation = this.fJobPresenter.createPresentation(this.fAddedPositions, this.fRemovedPositions);
                }
                if (!this.fJobPresenter.isCanceled()) {
                    this.updatePresentation(presentation, this.fAddedPositions, this.fRemovedPositions);
                }
            }
            this.stopReconcilingPositions();
            var10_5 = null;
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            if (model == null) ** GOTO lbl99
            ** GOTO lbl98
        }
        catch (Throwable var11_20) {
            var10_4 = null;
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            if (model != null) {
                model.releaseFromRead();
            }
            var12_7 = this.fReconcileLock;
            synchronized (var12_7) {
                ** try [egrp 2[TRYBLOCK] [6 : 581->592)] { 
lbl96:
                // 1 sources

                this.fIsReconciling = false;
                throw var11_20;
            }
lbl98:
            // 1 sources

            model.releaseFromRead();
lbl99:
            // 2 sources

            var12_8 = this.fReconcileLock;
            synchronized (var12_8) {
                ** try [egrp 2[TRYBLOCK] [6 : 581->592)] { 
lbl102:
                // 1 sources

                this.fIsReconciling = false;
                return;
            }
lbl-1000:
            // 1 sources

            {
                catch (Throwable v2) {
                    throw v2;
                }
            }
        }
lbl-1000:
        // 1 sources

        {
            catch (Throwable v3) {
                throw v3;
            }
        }
    }

    private void addPosition(Position position, SemanticHighlightingManager.HighlightingStyle highlighting) {
        this.addPosition(position, highlighting, false);
    }

    private void addPosition(Position position, SemanticHighlightingManager.HighlightingStyle highlighting, boolean isReadOnly) {
        boolean isExisting = false;
        int i = 0;
        int n = this.fRemovedPositions.size();
        while (i < n) {
            SemanticHighlightingManager.HighlightedPosition highlightedPosition = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fRemovedPositions.get(i));
            if (highlightedPosition != null && highlightedPosition.isEqual(position, highlighting)) {
                isExisting = true;
                this.fRemovedPositions.set(i, null);
                --this.fNOfRemovedPositions;
                break;
            }
            ++i;
        }
        if (!isExisting) {
            this.fAddedPositions.add(this.fJobPresenter.createHighlightedPosition(position, highlighting, isReadOnly));
        }
    }

    private void updatePresentation(TextPresentation textPresentation, List addedPositions, List removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        if (this.fViewer == null) {
            return;
        }
        StyledText viewerControl = this.fViewer.getTextWidget();
        if (viewerControl == null) {
            return;
        }
        Display display = viewerControl.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile((IRegion)dirtyRegion);
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
    }

    public void initialReconcile() {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            this.fJob = new Job("Semantic Highlighting Job"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    if (oldJob != null) {
                        try {
                            oldJob.join();
                        }
                        catch (InterruptedException e) {
                            Logger.logException(e);
                            return Status.CANCEL_STATUS;
                        }
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    SemanticHighlightingReconciler.this.reconcile((IRegion)new Region(0, SemanticHighlightingReconciler.this.fDocument.getLength()));
                    Object object = SemanticHighlightingReconciler.this.fJobLock;
                    synchronized (object) {
                        if (SemanticHighlightingReconciler.this.fJob == this) {
                            SemanticHighlightingReconciler.this.fJob = null;
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            this.fJob.setSystem(true);
            this.fJob.setPriority(50);
            this.fJob.schedule();
        }
    }

    public void refresh() {
        if (this.fDocument != null) {
            this.scheduleJob();
        }
    }
}

