/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.properties.section;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.dtd.core.internal.CMRepeatableNode;
import org.eclipse.wst.dtd.ui.internal.DTDPropertiesMessages;
import org.eclipse.wst.dtd.ui.internal.properties.section.AbstractSection;

public class OccurrenceSection
extends AbstractSection {
    private final String ONCE = DTDPropertiesMessages._UI_ONCE;
    private final String ONE_OR_MORE = DTDPropertiesMessages._UI_ONE_OR_MORE;
    private final String OPTIONAL = DTDPropertiesMessages._UI_OPTIONAL;
    private final String ZERO_OR_MORE = DTDPropertiesMessages._UI_ZERO_OR_MORE;
    private final String OCCURENCE = DTDPropertiesMessages._UI_LABEL_OCCURRENCE;
    private CCombo occurrenceCombo;
    private String[] occurrenceComboValues = new String[]{this.ONCE, this.ONE_OR_MORE, this.OPTIONAL, this.ZERO_OR_MORE};

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        CLabel usageLabel = this.getWidgetFactory().createCLabel(composite, this.OCCURENCE);
        Point p = usageLabel.computeSize(-1, -1, false);
        int labelWidth = Math.max(p.x, 98);
        FormData data = new FormData(labelWidth, -1);
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        usageLabel.setLayoutData((Object)data);
        this.occurrenceCombo = this.getWidgetFactory().createCCombo(composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment((Control)usageLabel, -5);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)usageLabel, 0, 0x1000000);
        this.occurrenceCombo.setLayoutData((Object)data);
        this.occurrenceCombo.addSelectionListener((SelectionListener)this);
        this.occurrenceCombo.setItems(this.occurrenceComboValues);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        Object input = this.getInput();
        if (input instanceof CMRepeatableNode) {
            char occurence = ((CMRepeatableNode)input).getOccurrence();
            if ('1' == occurence) {
                this.occurrenceCombo.setText(this.ONCE);
            } else if ('+' == occurence) {
                this.occurrenceCombo.setText(this.ONE_OR_MORE);
            } else if ('?' == occurence) {
                this.occurrenceCombo.setText(this.OPTIONAL);
            } else if ('*' == occurence) {
                this.occurrenceCombo.setText(this.ZERO_OR_MORE);
            } else {
                this.occurrenceCombo.setText(this.ONCE);
            }
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        Object input = this.getInput();
        if (input instanceof CMRepeatableNode) {
            this.setListenerEnabled(false);
            CMRepeatableNode node = (CMRepeatableNode)input;
            String occurrence = this.occurrenceCombo.getText();
            if (this.ONCE.equals(occurrence)) {
                node.setOccurrence('1');
            } else if (this.ONE_OR_MORE.equals(occurrence)) {
                node.setOccurrence('+');
            } else if (this.OPTIONAL.equals(occurrence)) {
                node.setOccurrence('?');
            } else if (this.ZERO_OR_MORE.equals(occurrence)) {
                node.setOccurrence('*');
            }
            this.setListenerEnabled(true);
        }
    }
}

