/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.ant;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.Task;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final Task task;
    boolean hadError = false;

    public ErrorHandlerImpl(Task task) {
        this.task = task;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.print(sAXParseException, 1);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.print(sAXParseException, 0);
        this.hadError = true;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.print(sAXParseException, 0);
        this.hadError = true;
    }

    private void print(SAXParseException sAXParseException, int n) {
        this.task.log(sAXParseException.getMessage(), n);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        sAXParseException.printStackTrace(printWriter);
        printWriter.close();
        this.task.log(stringWriter.toString(), 3);
    }
}

