/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.model.AbstractModelCollection;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IDescription;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IEndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IService;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.asd.util.EndPointComparator;

public class ServiceColumn
extends AbstractModelCollection {
    public ServiceColumn(IDescription description) {
        super(description, "ServiceColumn");
    }

    public ITreeElement[] getChildren() {
        List services = ((IDescription)this.model).getServices();
        Collections.sort(services, new ServiceComparator());
        Object[] array = services.toArray();
        ITreeElement[] treeElement = new ITreeElement[array.length];
        int index = 0;
        while (index < array.length) {
            treeElement[index] = (ITreeElement)array[index];
            ++index;
        }
        return treeElement;
    }

    public boolean hasChildren() {
        ITreeElement[] treeElement = this.getChildren();
        return treeElement.length > 0;
    }

    public String getText() {
        return "definition";
    }

    private class ServiceComparator
    implements Comparator {
        private ServiceComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof IService && o2 instanceof IService) {
                IEndPoint endPoint1 = this.getFirstAssociatedEndPoint((IService)o1);
                IEndPoint endPoint2 = this.getFirstAssociatedEndPoint((IService)o2);
                EndPointComparator comparator = new EndPointComparator();
                return comparator.compare(endPoint1, endPoint2);
            }
            return 0;
        }

        private IEndPoint getFirstAssociatedEndPoint(IService service) {
            Iterator endPoints = service.getEndPoints().iterator();
            while (endPoints.hasNext()) {
                IEndPoint tempEndPoint = (IEndPoint)endPoints.next();
                if (tempEndPoint.getBinding() == null) continue;
                return tempEndPoint;
            }
            return null;
        }
    }
}

