/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.internal.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.internal.jpql.WordParser;
import org.eclipse.persistence.jpa.internal.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.internal.jpql.parser.Expression;
import org.eclipse.persistence.jpa.internal.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.internal.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.internal.jpql.parser.StringExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WhenClause
extends AbstractExpression {
    private boolean hasSpaceAfterThen;
    private boolean hasSpaceAfterWhen;
    private boolean hasSpaceAfterWhenExpression;
    private boolean hasThen;
    private AbstractExpression thenExpression;
    private AbstractExpression whenExpression;

    WhenClause(AbstractExpression parent) {
        super(parent, "WHEN");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getWhenExpression().accept(visitor);
        this.getThenExpression().accept(visitor);
    }

    @Override
    void addChildrenTo(Collection<Expression> children) {
        children.add(this.getWhenExpression());
        children.add(this.getThenExpression());
    }

    @Override
    void addOrderedChildrenTo(List<StringExpression> children) {
        children.add(this.buildStringExpression("WHEN"));
        if (this.hasSpaceAfterWhen) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.whenExpression != null) {
            children.add(this.whenExpression);
        }
        if (this.hasSpaceAfterWhenExpression) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasThen) {
            children.add(this.buildStringExpression("THEN"));
        }
        if (this.hasSpaceAfterThen) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.thenExpression != null) {
            children.add(this.thenExpression);
        }
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return WhenClause.queryBNF("when_clause");
    }

    public AbstractExpression getThenExpression() {
        if (this.thenExpression == null) {
            this.thenExpression = this.buildNullExpression();
        }
        return this.thenExpression;
    }

    public AbstractExpression getWhenExpression() {
        if (this.whenExpression == null) {
            this.whenExpression = this.buildNullExpression();
        }
        return this.whenExpression;
    }

    public boolean hasSpaceAfterThen() {
        return this.hasSpaceAfterThen;
    }

    public boolean hasSpaceAfterWhen() {
        return this.hasSpaceAfterWhen;
    }

    public boolean hasSpaceAfterWhenExpression() {
        return this.hasSpaceAfterWhenExpression;
    }

    public boolean hasThen() {
        return this.hasThen;
    }

    public boolean hasThenExpression() {
        return this.thenExpression != null && !this.thenExpression.isNull();
    }

    public boolean hasWhenExpression() {
        return this.whenExpression != null && !this.whenExpression.isNull();
    }

    @Override
    boolean isParsingComplete(WordParser wordParser, String word, Expression expression) {
        return word.equalsIgnoreCase("WHEN") || word.equalsIgnoreCase("THEN") || word.equalsIgnoreCase("ELSE") || word.equalsIgnoreCase("END") || super.isParsingComplete(wordParser, word, expression);
    }

    @Override
    void parse(WordParser wordParser, boolean tolerant) {
        wordParser.moveForward("WHEN");
        this.hasSpaceAfterWhen = wordParser.skipLeadingWhitespace() > 0;
        this.whenExpression = this.parse(wordParser, (JPQLQueryBNF)WhenClause.queryBNF("internal_when_clause*"), tolerant);
        this.hasSpaceAfterWhenExpression = wordParser.skipLeadingWhitespace() > 0;
        this.hasThen = wordParser.startsWithIdentifier("THEN");
        if (this.hasThen) {
            wordParser.moveForward("THEN");
        }
        this.hasSpaceAfterThen = wordParser.skipLeadingWhitespace() > 0;
        this.thenExpression = this.parse(wordParser, (JPQLQueryBNF)WhenClause.queryBNF("scalar_expression"), tolerant);
    }

    @Override
    void toParsedText(StringBuilder writer, boolean includeVirtual) {
        writer.append("WHEN");
        if (this.hasSpaceAfterWhen) {
            writer.append(' ');
        }
        if (this.whenExpression != null) {
            this.whenExpression.toParsedText(writer, includeVirtual);
        }
        if (this.hasSpaceAfterWhenExpression) {
            writer.append(' ');
        }
        if (this.hasThen) {
            writer.append("THEN");
        }
        if (this.hasSpaceAfterThen) {
            writer.append(' ');
        }
        if (this.thenExpression != null) {
            this.thenExpression.toParsedText(writer, includeVirtual);
        }
    }
}

