/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.mylyn.internal.wikitext.core.parser.builder.DitaTopicDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.DitaBookMapDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.core.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupTask;
import org.eclipse.mylyn.wikitext.core.util.anttask.Messages;

public class MarkupToDitaTask
extends MarkupTask {
    private final List<FileSet> filesets = new ArrayList<FileSet>();
    private String filenameFormat;
    private String bookTitle;
    private boolean overwrite = true;
    protected File file;
    private String doctype;
    private String topicDoctype;
    private String topicFolder = "topics";
    private BreakStrategy topicStrategy = BreakStrategy.FIRST;
    private boolean formatting = true;

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToDitaTask.1"));
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException(Messages.getString("MarkupToDitaTask.2"));
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.3"), this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.4"), this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.5"), this.file));
            }
        }
        if (this.filenameFormat == null) {
            switch (this.topicStrategy) {
                case NONE: {
                    this.filenameFormat = "$1.dita";
                    break;
                }
                default: {
                    this.filenameFormat = "$1.ditamap";
                }
            }
        }
        MarkupLanguage markupLanguage = this.createMarkupLanguage();
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(markupLanguage, filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.6"), inputFile, e.getMessage()), (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.file != null) {
            try {
                this.processFile(markupLanguage, this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.7"), this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    private void processFile(MarkupLanguage markupLanguage, File baseDir, File source) throws BuildException {
        File outputFile;
        this.log(MessageFormat.format(Messages.getString("MarkupToDitaTask.8"), source), 3);
        String markupContent = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(outputFile = new File(source.getParentFile(), this.filenameFormat.replace("$1", name))).exists() || this.overwrite || outputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            block25: {
                markupContent = this.readFully(source);
                this.performValidation(source, markupContent);
                OutlineItem outline = new OutlineParser(markupLanguage).parse(markupContent);
                try {
                    writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), "utf-8");
                }
                catch (Exception e) {
                    throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.11"), outputFile, e.getMessage()), (Throwable)e);
                }
                try {
                    if (this.topicStrategy == BreakStrategy.NONE) {
                        DitaTopicDocumentBuilder builder = new DitaTopicDocumentBuilder(new DefaultXmlStreamWriter(writer), this.formatting);
                        builder.setRootTopicTitle(this.bookTitle);
                        MarkupParser parser = new MarkupParser();
                        parser.setMarkupLanguage(markupLanguage);
                        parser.setBuilder(builder);
                        if (this.topicDoctype != null) {
                            builder.setDoctype(this.topicDoctype);
                        }
                        builder.setFilename(outputFile.getName());
                        builder.setOutline(outline);
                        parser.parse(markupContent);
                        break block25;
                    }
                    DitaBookMapDocumentBuilder builder = new DitaBookMapDocumentBuilder(this.formatting ? new FormattingXMLStreamWriter(new DefaultXmlStreamWriter(writer)) : new DefaultXmlStreamWriter(writer));
                    try {
                        builder.setFormattingDependencies(this.formatting);
                        MarkupParser parser = new MarkupParser();
                        parser.setMarkupLanguage(markupLanguage);
                        parser.setBuilder(builder);
                        builder.setBookTitle(this.bookTitle == null ? name : this.bookTitle);
                        if (this.doctype != null) {
                            builder.setDoctype(this.doctype);
                        }
                        if (this.topicDoctype != null) {
                            builder.setTopicDoctype(this.topicDoctype);
                        }
                        builder.setTargetFile(outputFile);
                        builder.setTopicFolder(this.topicFolder);
                        builder.setOutline(outline);
                        switch (this.topicStrategy) {
                            case FIRST: {
                                if (!outline.getChildren().isEmpty()) {
                                    builder.setTopicBreakLevel(outline.getChildren().get(0).getLevel());
                                    break;
                                }
                                builder.setTopicBreakLevel(1);
                                break;
                            }
                            case LEVEL1: {
                                builder.setTopicBreakLevel(1);
                            }
                        }
                        parser.parse(markupContent);
                    }
                    catch (Throwable throwable) {
                        try {
                            builder.close();
                        }
                        catch (IOException e) {
                            throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.12"), outputFile, e.getMessage()), (Throwable)e);
                        }
                        throw throwable;
                    }
                    try {
                        builder.close();
                    }
                    catch (IOException e) {
                        throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.12"), outputFile, e.getMessage()), (Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (Exception e) {
                        throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.12"), outputFile, e.getMessage()), (Throwable)e);
                    }
                    throw throwable;
                }
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(MessageFormat.format(Messages.getString("MarkupToDitaTask.12"), outputFile, e.getMessage()), (Throwable)e);
            }
        }
    }

    public String getFilenameFormat() {
        return this.filenameFormat;
    }

    public void setFilenameFormat(String filenameFormat) {
        this.filenameFormat = filenameFormat;
    }

    public String getBookTitle() {
        return this.bookTitle;
    }

    public void setBookTitle(String bookTitle) {
        this.bookTitle = bookTitle;
    }

    public void setDoctype(String doctype) {
        this.doctype = doctype;
    }

    public String getDoctype() {
        return this.doctype;
    }

    public String getTopicDoctype() {
        return this.topicDoctype;
    }

    public void setTopicDoctype(String topicDoctype) {
        this.topicDoctype = topicDoctype;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getTopicFolder() {
        return this.topicFolder;
    }

    public void setTopicFolder(String topicFolder) {
        this.topicFolder = topicFolder;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public BreakStrategy getTopicStrategy() {
        return this.topicStrategy;
    }

    public void setTopicStrategy(BreakStrategy topicStrategy) {
        this.topicStrategy = topicStrategy;
    }

    public boolean isFormatting() {
        return this.formatting;
    }

    public void setFormatting(boolean formatting) {
        this.formatting = formatting;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BreakStrategy {
        NONE,
        LEVEL1,
        FIRST;

    }
}

