/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.xml.io.XMLDumper;
import com.thaiopensource.relaxng.impl.AbstractPatternFunction;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.DatatypeWrapper;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.ErrorPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NotAllowedPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.relaxng.datatype.Datatype;

public class DumpPattern
extends XMLDumper {
    private PDumper pdumper = new PDumper();
    private NCVisitor ncvisitor = new NCVisitor();
    private LinkedList defines = new LinkedList();
    private HashSet defined = new HashSet();
    private HashMap recursive = new HashMap();
    private RecursiveChecker recursiveChecker = new RecursiveChecker();
    private DefineDumper defineDumper = new DefineDumper();

    public void dump(Pattern pattern, PrintWriter printWriter) {
        this.setWriter(printWriter);
        this.startElement("grammar");
        this.startElement("start");
        this.dump(pattern);
        this.endElement();
        this.endElement();
    }

    private void dump(Pattern pattern) {
        this.recursiveChecker.check(pattern);
        pattern.apply(this.pdumper);
        while (this.defines.size() > 0) {
            Pattern pattern2;
            Object e = this.defines.removeFirst();
            if (e instanceof RefPattern) {
                pattern2 = (RefPattern)e;
                this.startElement("define");
                this.attribute("name", ((RefPattern)pattern2).getName());
                ((RefPattern)pattern2).getPattern().apply(this.pdumper);
                this.endElement();
                continue;
            }
            pattern2 = (Pattern)e;
            this.startElement("define");
            this.attribute("name", (String)this.recursive.get(pattern2));
            pattern2.apply(this.defineDumper);
            this.endElement();
        }
        this.defines.clear();
        this.defined.clear();
        this.recursive.clear();
    }

    private class PDumper
    implements PatternFunction {
        PDumper() {
        }

        public Object caseEmpty(EmptyPattern emptyPattern) {
            DumpPattern.this.startElement("empty");
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            DumpPattern.this.startElement("empty");
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseError(ErrorPattern errorPattern) {
            DumpPattern.this.startElement("error");
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            if (this.notRecursive(groupPattern)) {
                DumpPattern.this.startElement("group");
                groupPattern.p1.apply(this);
                groupPattern.p2.apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }

        private boolean notRecursive(Pattern pattern) {
            String string = (String)DumpPattern.this.recursive.get(pattern);
            if (string != null) {
                DumpPattern.this.startElement("ref");
                DumpPattern.this.attribute("name", string);
                DumpPattern.this.endElement();
                return false;
            }
            return true;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            if (this.notRecursive(interleavePattern)) {
                DumpPattern.this.startElement("interleave");
                interleavePattern.p1.apply(this);
                interleavePattern.p2.apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            if (this.notRecursive(choicePattern)) {
                DumpPattern.this.startElement("choice");
                choicePattern.p1.apply(this);
                choicePattern.p2.apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            if (this.notRecursive(oneOrMorePattern)) {
                DumpPattern.this.startElement("oneOrMore");
                oneOrMorePattern.getOperand().apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }

        public Object caseElement(ElementPattern elementPattern) {
            if (this.notRecursive(elementPattern)) {
                DumpPattern.this.startElement("element");
                this.name(elementPattern.getNameClass());
                elementPattern.getContent().apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }

        private void name(NameClass nameClass) {
            if (nameClass instanceof SimpleNameClass) {
                SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
                Name name = simpleNameClass.getName();
                DumpPattern.this.attribute("name", name.getLocalName());
                String string = name.getNamespaceUri();
                if (string != null && string.length() > 0) {
                    DumpPattern.this.attribute("ns", string);
                }
            } else {
                nameClass.accept(DumpPattern.this.ncvisitor);
            }
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            if (this.notRecursive(attributePattern)) {
                DumpPattern.this.startElement("attribute");
                attributePattern.getNameClass().accept(DumpPattern.this.ncvisitor);
                attributePattern.getContent().apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }

        public Object caseData(DataPattern dataPattern) {
            this.dataExcept(dataPattern.getDatatype(), null);
            return null;
        }

        public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
            this.dataExcept(dataExceptPattern.getDatatype(), dataExceptPattern.getExcept());
            return null;
        }

        public Object caseValue(ValuePattern valuePattern) {
            DumpPattern.this.startElement("value");
            this.typeAttribute(valuePattern.getDatatype());
            DumpPattern.this.data(valuePattern.getValue().toString());
            DumpPattern.this.endElement();
            return null;
        }

        private void dataExcept(Datatype datatype, Pattern pattern) {
            if (datatype instanceof DatatypeWrapper) {
                DumpPattern.this.startElement("data");
                this.typeAttribute(datatype);
                DatatypeWrapper datatypeWrapper = (DatatypeWrapper)datatype;
                Iterator iterator = datatypeWrapper.paramIterator();
                while (iterator.hasNext()) {
                    DumpPattern.this.startElement("param");
                    Map.Entry entry = (Map.Entry)iterator.next();
                    DumpPattern.this.attribute("name", (String)entry.getKey());
                    DumpPattern.this.data((String)entry.getValue());
                    DumpPattern.this.endElement();
                }
                if (pattern != null) {
                    DumpPattern.this.startElement("except");
                    pattern.apply(this);
                    DumpPattern.this.endElement();
                }
                DumpPattern.this.endElement();
            } else {
                DumpPattern.this.startElement("text");
                DumpPattern.this.endElement();
            }
        }

        private void typeAttribute(Datatype datatype) {
            if (datatype instanceof DatatypeWrapper) {
                DatatypeWrapper datatypeWrapper = (DatatypeWrapper)datatype;
                String string = datatypeWrapper.getLibraryName();
                if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                    string = "http://www.w3.org/2001/XMLSchema-datatypes";
                }
                String string2 = datatypeWrapper.getDatatypeName();
                DumpPattern.this.attribute("type", string2);
                DumpPattern.this.attribute("datatypeLibrary", string);
            } else {
                DumpPattern.this.attribute("type", "token");
                DumpPattern.this.attribute("datatypeLibrary", "");
            }
        }

        public Object caseText(TextPattern textPattern) {
            DumpPattern.this.startElement("text");
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseList(ListPattern listPattern) {
            DumpPattern.this.startElement("list");
            listPattern.getOperand().apply(this);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseRef(RefPattern refPattern) {
            DumpPattern.this.startElement("ref");
            DumpPattern.this.attribute("name", refPattern.getName());
            if (!DumpPattern.this.defined.contains(refPattern)) {
                DumpPattern.this.defined.add(refPattern);
                DumpPattern.this.defines.add(refPattern);
            }
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            if (this.notRecursive(afterPattern)) {
                DumpPattern.this.startElement("after");
                afterPattern.p1.apply(this);
                afterPattern.p2.apply(this);
                DumpPattern.this.endElement();
            }
            return null;
        }
    }

    private class NCVisitor
    implements NameClassVisitor {
        NCVisitor() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            DumpPattern.this.startElement("choice");
            nameClass.accept(this);
            nameClass2.accept(this);
            DumpPattern.this.endElement();
        }

        public void visitNsName(String string) {
            DumpPattern.this.startElement("nsName");
            DumpPattern.this.attribute("ns", string);
            DumpPattern.this.endElement();
        }

        public void visitNsNameExcept(String string, NameClass nameClass) {
            DumpPattern.this.startElement("nsName");
            DumpPattern.this.attribute("ns", string);
            DumpPattern.this.startElement("except");
            nameClass.accept(this);
            DumpPattern.this.endElement();
            DumpPattern.this.endElement();
        }

        public void visitAnyName() {
            DumpPattern.this.startElement("anyName");
            DumpPattern.this.endElement();
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            DumpPattern.this.startElement("anyName");
            DumpPattern.this.startElement("except");
            nameClass.accept(this);
            DumpPattern.this.endElement();
            DumpPattern.this.endElement();
        }

        public void visitName(Name name) {
            DumpPattern.this.startElement("name");
            String string = name.getNamespaceUri();
            if (string != null && string.length() > 0) {
                DumpPattern.this.attribute("ns", string);
            }
            DumpPattern.this.data(name.getLocalName());
            DumpPattern.this.endElement();
        }

        public void visitNull() {
            DumpPattern.this.startElement("empty");
            DumpPattern.this.endElement();
        }

        public void visitError() {
            DumpPattern.this.startElement("error");
            DumpPattern.this.endElement();
        }
    }

    private class DefineDumper
    extends AbstractPatternFunction {
        DefineDumper() {
        }

        public Object caseOther(Pattern pattern) {
            return pattern.apply(DumpPattern.this.pdumper);
        }

        public Object caseAfter(AfterPattern afterPattern) {
            DumpPattern.this.startElement("after");
            afterPattern.p1.apply(DumpPattern.this.pdumper);
            afterPattern.p2.apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            DumpPattern.this.startElement("attribute");
            attributePattern.getNameClass().accept(DumpPattern.this.ncvisitor);
            attributePattern.getContent().apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            DumpPattern.this.startElement("choice");
            choicePattern.p1.apply(DumpPattern.this.pdumper);
            choicePattern.p2.apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseElement(ElementPattern elementPattern) {
            DumpPattern.this.startElement("element");
            elementPattern.getNameClass().accept(DumpPattern.this.ncvisitor);
            elementPattern.getContent().apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            DumpPattern.this.startElement("group");
            groupPattern.p1.apply(DumpPattern.this.pdumper);
            groupPattern.p2.apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            DumpPattern.this.startElement("interleave");
            interleavePattern.p1.apply(DumpPattern.this.pdumper);
            interleavePattern.p2.apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            DumpPattern.this.startElement("oneOrMore");
            oneOrMorePattern.getOperand().apply(DumpPattern.this.pdumper);
            DumpPattern.this.endElement();
            return null;
        }
    }

    private class RecursiveChecker
    extends AbstractPatternFunction {
        private HashSet set;
        private int unique;

        RecursiveChecker() {
        }

        public void check(Pattern pattern) {
            this.set = new HashSet();
            this.unique = 0;
            pattern.apply(this);
            this.set = null;
        }

        public Object caseOther(Pattern pattern) {
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            if (this.notRecursive(afterPattern)) {
                this.set.add(afterPattern);
                afterPattern.getOperand1().apply(this);
                afterPattern.getOperand2().apply(this);
                this.set.remove(afterPattern);
            }
            return null;
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            if (this.notRecursive(attributePattern)) {
                this.set.add(attributePattern);
                attributePattern.getContent().apply(this);
                this.set.remove(attributePattern);
            }
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            if (this.notRecursive(choicePattern)) {
                this.set.add(choicePattern);
                choicePattern.getOperand1().apply(this);
                choicePattern.getOperand2().apply(this);
                this.set.remove(choicePattern);
            }
            return null;
        }

        public Object caseElement(ElementPattern elementPattern) {
            if (this.notRecursive(elementPattern)) {
                this.set.add(elementPattern);
                elementPattern.getContent().apply(this);
                this.set.remove(elementPattern);
            }
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            if (this.notRecursive(groupPattern)) {
                this.set.add(groupPattern);
                groupPattern.getOperand1().apply(this);
                groupPattern.getOperand2().apply(this);
                this.set.remove(groupPattern);
            }
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            if (this.notRecursive(interleavePattern)) {
                this.set.add(interleavePattern);
                interleavePattern.getOperand1().apply(this);
                interleavePattern.getOperand2().apply(this);
                this.set.remove(interleavePattern);
            }
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            if (this.notRecursive(oneOrMorePattern)) {
                this.set.add(oneOrMorePattern);
                oneOrMorePattern.getOperand().apply(this);
                this.set.remove(oneOrMorePattern);
            }
            return null;
        }

        private boolean notRecursive(Pattern pattern) {
            if (this.set.contains(pattern)) {
                if (!DumpPattern.this.defined.contains(pattern)) {
                    DumpPattern.this.defined.add(pattern);
                    DumpPattern.this.defines.add(pattern);
                    String string = this.uniqueName();
                    DumpPattern.this.recursive.put(pattern, string);
                }
                return false;
            }
            return true;
        }

        private String uniqueName() {
            return "recursive" + ++this.unique;
        }

        private void checkRecursive(Pattern pattern) {
            if (this.set.contains(pattern)) {
                throw new IllegalStateException(pattern.toString());
            }
        }

        public Object caseRef(RefPattern refPattern) {
            return null;
        }
    }
}

