/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.AnyNameClass;
import com.thaiopensource.relaxng.impl.AnyNameExceptNameClass;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataExceptPattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.DatatypeWrapper;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.ErrorPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.ListPattern;
import com.thaiopensource.relaxng.impl.MNPattern;
import com.thaiopensource.relaxng.impl.MPatternFunction;
import com.thaiopensource.relaxng.impl.MStarPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.NotAllowedPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternPool;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.relaxng.datatype.Datatype;

public class PatternPrettyPrinter {
    private String defaultLibrary;
    private boolean startTagOpen = false;
    private final Vector tagStack = new Vector();
    private final PrintWriter writer;
    private int level = 0;
    private boolean suppressIndent = false;
    private final Vector patternList = new Vector();
    private final PatternVisitor patternVisitor = new DumpPatternVisitor();
    private final PatternVisitor groupPatternVisitor = new GroupDumpPatternVisitor();
    private final PatternVisitor choicePatternVisitor = new ChoiceDumpPatternVisitor();
    private final PatternVisitor interleavePatternVisitor = new InterleaveDumpPatternVisitor();
    private final NameClassVisitor nameClassVisitor = new DumpNameClassVisitor();
    private final NameClassVisitor choiceNameClassVisitor = new ChoiceDumpNameClassVisitor();
    private final PatternVisitor collectNamespacesVisitor = new CollectNamespacesVisitor();
    private final NameClassVisitor collectNamespaces = new CollectNamespaces();
    private final PatternFunction normalizeRefsFunction = new NormalizeRefsFunction();
    private final PatternPool pool = new PatternPool();
    private final HashSet namespaces = new HashSet();
    private final HashMap prefixes = new HashMap();
    private final HashMap dtcounts = new HashMap();
    private final HashSet defines = new HashSet();
    private HashSet definedNames = new HashSet();

    public static void dump(PrintWriter printWriter, Pattern pattern) {
        new PatternPrettyPrinter(printWriter).dump(pattern, true, 10);
    }

    public static void dump(OutputStream outputStream, Pattern pattern) {
        new PatternPrettyPrinter(new PrintWriter(outputStream)).dump(pattern, true, 10);
    }

    public static void dump(PrintWriter printWriter, Pattern pattern, boolean bl, int n) {
        new PatternPrettyPrinter(printWriter).dump(pattern, bl, n);
    }

    public static void dump(OutputStream outputStream, Pattern pattern, boolean bl, int n) {
        new PatternPrettyPrinter(new PrintWriter(outputStream)).dump(pattern, bl, n);
    }

    private PatternPrettyPrinter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    private void dump(Pattern pattern, boolean bl, int n) {
        pattern = pattern.applyForPattern(this.normalizeRefsFunction);
        this.setDefines(pattern, bl, n);
        pattern.accept(this.collectNamespacesVisitor);
        this.setDefaultLibrary();
        this.startElement("grammar");
        this.attribute("xmlns", "http://relaxng.org/ns/structure/1.0");
        this.namespaceAttributes();
        if (this.defaultLibrary != null) {
            this.attribute("datatypeLibrary", this.defaultLibrary);
        }
        this.startElement("start");
        pattern.accept(this.groupPatternVisitor);
        this.endElement();
        int n2 = 0;
        while (n2 < this.patternList.size()) {
            this.startElement("define");
            RefPattern refPattern = (RefPattern)this.patternList.elementAt(n2);
            this.attribute("name", refPattern.getName());
            refPattern.getPattern().accept(this.groupPatternVisitor);
            this.endElement();
            ++n2;
        }
        this.endElement();
        this.writer.println();
        this.writer.flush();
    }

    private void setDefines(Pattern pattern, boolean bl, int n) {
        Iterator iterator = this.patternList.iterator();
        while (iterator.hasNext()) {
            PatternPool.PrettyRefPattern prettyRefPattern = (PatternPool.PrettyRefPattern)iterator.next();
            if (bl && prettyRefPattern.level == 0 || prettyRefPattern.uses > n || prettyRefPattern.recursive) {
                prettyRefPattern.setName(this.uniqueDefineName(prettyRefPattern.getName()));
                this.defines.add(prettyRefPattern);
                continue;
            }
            iterator.remove();
        }
    }

    private String uniqueDefineName(String string) {
        String string2 = string;
        int n = 2;
        while (this.definedNames.contains(string)) {
            string = String.valueOf(string2) + '_' + n++;
        }
        this.definedNames.add(string);
        return string;
    }

    private void setDefaultLibrary() {
        Iterator iterator = this.dtcounts.entrySet().iterator();
        this.defaultLibrary = null;
        int n = 0;
        while (iterator.hasNext()) {
            int n2;
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            if ("".equals(string) || n >= (n2 = ((Count)entry.getValue()).getCount())) continue;
            n = n2;
            this.defaultLibrary = (String)entry.getKey();
        }
        if (this.defaultLibrary != null && this.defaultLibrary.equals("http://www.w3.org/2001/XMLSchema")) {
            this.defaultLibrary = "http://www.w3.org/2001/XMLSchema-datatypes";
        }
    }

    private void namespaceAttributes() {
        Iterator iterator = this.namespaces.iterator();
        int n = 1;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("http://relaxng.org/ns/structure/1.0") || string.equals("")) continue;
            String string2 = "ns" + n++;
            this.prefixes.put(string, string2);
            this.attribute("xmlns:" + string2, string);
        }
    }

    private void startElement(String string) {
        this.closeStartTag();
        this.indent(this.level);
        this.write('<');
        this.write(string);
        this.push(string);
        this.startTagOpen = true;
        ++this.level;
    }

    private void closeStartTag() {
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write('>');
        }
    }

    private void attribute(String string, String string2) {
        this.write(' ');
        this.write(string);
        this.write('=');
        this.write('\"');
        this.chars(string2, true);
        this.write('\"');
    }

    private void data(String string) {
        if (string.length() > 0) {
            this.closeStartTag();
            this.chars(string, false);
            this.suppressIndent = true;
        }
    }

    private void chars(String string, boolean bl) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '&': {
                    this.write("&amp;");
                    break;
                }
                case '<': {
                    this.write("&lt;");
                    break;
                }
                case '>': {
                    this.write("&gt;");
                    break;
                }
                case '\"': {
                    if (bl) {
                        this.write("&quot;");
                        break;
                    }
                }
                default: {
                    this.write(c);
                }
            }
            ++n2;
        }
    }

    private void endElement() {
        --this.level;
        if (this.startTagOpen) {
            this.startTagOpen = false;
            this.write("/>");
            this.pop();
        } else {
            if (!this.suppressIndent) {
                this.indent(this.level);
            }
            this.write("</");
            this.write(this.pop());
            this.write(">");
        }
        this.suppressIndent = false;
    }

    private void indent(int n) {
        this.writer.println();
        int n2 = 0;
        while (n2 < n) {
            this.write("  ");
            ++n2;
        }
    }

    private void write(String string) {
        this.writer.print(string);
    }

    private void write(char c) {
        this.writer.print(c);
    }

    private void push(String string) {
        this.tagStack.addElement(string);
    }

    private String pop() {
        String string = (String)this.tagStack.lastElement();
        this.tagStack.setSize(this.tagStack.size() - 1);
        return string;
    }

    class DumpPatternVisitor
    implements PatternPool.RefPatternVisitor {
        DumpPatternVisitor() {
        }

        public void visitRef(RefPattern refPattern) {
            if (PatternPrettyPrinter.this.defines.contains(refPattern)) {
                PatternPrettyPrinter.this.startElement("ref");
                PatternPrettyPrinter.this.attribute("name", refPattern.getName());
                PatternPrettyPrinter.this.endElement();
            } else {
                refPattern.getPattern().accept(this);
            }
        }

        public void visitEmpty() {
            PatternPrettyPrinter.this.startElement("empty");
            PatternPrettyPrinter.this.endElement();
        }

        public void visitNotAllowed() {
            PatternPrettyPrinter.this.startElement("notAllowed");
            PatternPrettyPrinter.this.endElement();
        }

        public void visitError() {
            PatternPrettyPrinter.this.startElement("error");
            PatternPrettyPrinter.this.endElement();
        }

        public void visitGroup(Pattern pattern, Pattern pattern2) {
            PatternPrettyPrinter.this.startElement("group");
            if (pattern instanceof GroupPattern) {
                LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
                while (pattern instanceof GroupPattern) {
                    linkedList.add(pattern2);
                    GroupPattern groupPattern = (GroupPattern)pattern;
                    pattern = groupPattern.p1;
                    pattern2 = groupPattern.p2;
                }
                pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                pattern2.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                while (linkedList.size() > 0) {
                    pattern2 = (Pattern)linkedList.removeLast();
                    pattern2.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                }
            } else {
                pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                pattern2.accept(PatternPrettyPrinter.this.groupPatternVisitor);
            }
            PatternPrettyPrinter.this.endElement();
        }

        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            if (pattern instanceof TextPattern) {
                PatternPrettyPrinter.this.startElement("mixed");
                pattern2.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                PatternPrettyPrinter.this.endElement();
            } else {
                PatternPrettyPrinter.this.startElement("interleave");
                pattern.accept(PatternPrettyPrinter.this.interleavePatternVisitor);
                pattern2.accept(PatternPrettyPrinter.this.interleavePatternVisitor);
                PatternPrettyPrinter.this.endElement();
            }
        }

        public void visitChoice(Pattern pattern, Pattern pattern2) {
            if (pattern2 instanceof EmptyPattern) {
                if (pattern instanceof OneOrMorePattern) {
                    PatternPrettyPrinter.this.startElement("zeroOrMore");
                    ((OneOrMorePattern)pattern).getOperand().accept(PatternPrettyPrinter.this.groupPatternVisitor);
                    PatternPrettyPrinter.this.endElement();
                } else {
                    PatternPrettyPrinter.this.startElement("optional");
                    pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                    PatternPrettyPrinter.this.endElement();
                }
            } else {
                PatternPrettyPrinter.this.startElement("choice");
                pattern.accept(PatternPrettyPrinter.this.choicePatternVisitor);
                pattern2.accept(PatternPrettyPrinter.this.choicePatternVisitor);
                PatternPrettyPrinter.this.endElement();
            }
        }

        public void visitOneOrMore(Pattern pattern) {
            PatternPrettyPrinter.this.startElement("oneOrMore");
            pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
            PatternPrettyPrinter.this.endElement();
        }

        public void visitMN(Pattern pattern, int n, int n2) {
            int n3 = 0;
            while (n3 < n) {
                pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                ++n3;
            }
            n3 = 0;
            int n4 = n2 - n;
            while (n3 < n4) {
                PatternPrettyPrinter.this.startElement("optional");
                pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                PatternPrettyPrinter.this.endElement();
                ++n3;
            }
        }

        public void visitMStar(Pattern pattern, int n) {
            int n2 = 1;
            while (n2 < n) {
                pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                ++n2;
            }
            PatternPrettyPrinter.this.startElement("oneOrMore");
            pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
            PatternPrettyPrinter.this.endElement();
        }

        public void visitElement(NameClass nameClass, Pattern pattern) {
            PatternPrettyPrinter.this.startElement("element");
            nameClass.accept(PatternPrettyPrinter.this.nameClassVisitor);
            pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
            PatternPrettyPrinter.this.endElement();
        }

        public void visitAttribute(NameClass nameClass, Pattern pattern) {
            PatternPrettyPrinter.this.startElement("attribute");
            nameClass.accept(PatternPrettyPrinter.this.nameClassVisitor);
            pattern.accept(PatternPrettyPrinter.this.patternVisitor);
            PatternPrettyPrinter.this.endElement();
        }

        public void visitData(Datatype datatype) {
            this.dataExcept(datatype, null);
        }

        private void dataExcept(Datatype datatype, Pattern pattern) {
            if (datatype instanceof DatatypeWrapper) {
                PatternPrettyPrinter.this.startElement("data");
                this.typeAttribute(datatype);
                DatatypeWrapper datatypeWrapper = (DatatypeWrapper)datatype;
                Iterator iterator = datatypeWrapper.paramIterator();
                while (iterator.hasNext()) {
                    PatternPrettyPrinter.this.startElement("param");
                    Map.Entry entry = (Map.Entry)iterator.next();
                    PatternPrettyPrinter.this.attribute("name", (String)entry.getKey());
                    PatternPrettyPrinter.this.data((String)entry.getValue());
                    PatternPrettyPrinter.this.endElement();
                }
                if (pattern != null) {
                    PatternPrettyPrinter.this.startElement("except");
                    pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
                    PatternPrettyPrinter.this.endElement();
                }
                PatternPrettyPrinter.this.endElement();
            } else {
                PatternPrettyPrinter.this.startElement("text");
                PatternPrettyPrinter.this.endElement();
            }
        }

        private void typeAttribute(Datatype datatype) {
            if (datatype instanceof DatatypeWrapper) {
                DatatypeWrapper datatypeWrapper = (DatatypeWrapper)datatype;
                String string = datatypeWrapper.getLibraryName();
                if (string.equals("http://www.w3.org/2001/XMLSchema")) {
                    string = "http://www.w3.org/2001/XMLSchema-datatypes";
                }
                String string2 = datatypeWrapper.getDatatypeName();
                PatternPrettyPrinter.this.attribute("type", string2);
                if (!string.equals(PatternPrettyPrinter.this.defaultLibrary)) {
                    PatternPrettyPrinter.this.attribute("datatypeLibrary", string);
                }
            } else {
                PatternPrettyPrinter.this.attribute("type", "token");
                PatternPrettyPrinter.this.attribute("datatypeLibrary", "");
            }
        }

        public void visitDataExcept(Datatype datatype, Pattern pattern) {
            this.dataExcept(datatype, pattern);
        }

        public void visitValue(Datatype datatype, Object object) {
            PatternPrettyPrinter.this.startElement("value");
            this.typeAttribute(datatype);
            PatternPrettyPrinter.this.data(object.toString());
            PatternPrettyPrinter.this.endElement();
        }

        public void visitText() {
            PatternPrettyPrinter.this.startElement("text");
            PatternPrettyPrinter.this.endElement();
        }

        public void visitList(Pattern pattern) {
            PatternPrettyPrinter.this.startElement("list");
            pattern.accept(PatternPrettyPrinter.this.groupPatternVisitor);
            PatternPrettyPrinter.this.endElement();
        }
    }

    class GroupDumpPatternVisitor
    extends DumpPatternVisitor {
        GroupDumpPatternVisitor() {
        }

        public void visitGroup(Pattern pattern, Pattern pattern2) {
            if (pattern instanceof GroupPattern) {
                LinkedList<Pattern> linkedList = new LinkedList<Pattern>();
                while (pattern instanceof GroupPattern) {
                    linkedList.add(pattern2);
                    GroupPattern groupPattern = (GroupPattern)pattern;
                    pattern = groupPattern.p1;
                    pattern2 = groupPattern.p2;
                }
                pattern.accept(this);
                pattern2.accept(this);
                while (linkedList.size() > 0) {
                    pattern2 = (Pattern)linkedList.removeLast();
                    pattern2.accept(this);
                }
            } else {
                pattern.accept(this);
                pattern2.accept(this);
            }
        }
    }

    class ChoiceDumpPatternVisitor
    extends DumpPatternVisitor {
        ChoiceDumpPatternVisitor() {
        }

        public void visitChoice(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class InterleaveDumpPatternVisitor
    extends DumpPatternVisitor {
        InterleaveDumpPatternVisitor() {
        }

        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }
    }

    class DumpNameClassVisitor
    implements NameClassVisitor {
        DumpNameClassVisitor() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            PatternPrettyPrinter.this.startElement("choice");
            nameClass.accept(PatternPrettyPrinter.this.choiceNameClassVisitor);
            nameClass2.accept(PatternPrettyPrinter.this.choiceNameClassVisitor);
            PatternPrettyPrinter.this.endElement();
        }

        public void visitNsName(String string) {
            PatternPrettyPrinter.this.startElement("nsName");
            PatternPrettyPrinter.this.attribute("ns", string);
            PatternPrettyPrinter.this.endElement();
        }

        public void visitNsNameExcept(String string, NameClass nameClass) {
            PatternPrettyPrinter.this.startElement("nsName");
            PatternPrettyPrinter.this.startElement("except");
            nameClass.accept(PatternPrettyPrinter.this.choiceNameClassVisitor);
            PatternPrettyPrinter.this.endElement();
            PatternPrettyPrinter.this.endElement();
        }

        public void visitAnyName() {
            PatternPrettyPrinter.this.startElement("anyName");
            PatternPrettyPrinter.this.endElement();
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            PatternPrettyPrinter.this.startElement("anyName");
            PatternPrettyPrinter.this.startElement("except");
            nameClass.accept(PatternPrettyPrinter.this.choiceNameClassVisitor);
            PatternPrettyPrinter.this.endElement();
            PatternPrettyPrinter.this.endElement();
        }

        public void visitName(Name name) {
            String string = name.getNamespaceUri();
            String string2 = (String)PatternPrettyPrinter.this.prefixes.get(string);
            if ("".equals(string)) {
                PatternPrettyPrinter.this.attribute("name", name.getLocalName());
            } else if (string2 != null) {
                PatternPrettyPrinter.this.attribute("name", String.valueOf(string2) + ':' + name.getLocalName());
            } else {
                PatternPrettyPrinter.this.startElement("name");
                PatternPrettyPrinter.this.attribute("ns", string);
                PatternPrettyPrinter.this.data(name.getLocalName());
                PatternPrettyPrinter.this.endElement();
            }
        }

        public void visitError() {
            PatternPrettyPrinter.this.startElement("error");
            PatternPrettyPrinter.this.endElement();
        }

        public void visitNull() {
            this.visitAnyName();
        }
    }

    class ChoiceDumpNameClassVisitor
    extends DumpNameClassVisitor {
        ChoiceDumpNameClassVisitor() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }
    }

    class CollectNamespacesVisitor
    implements PatternPool.RefPatternVisitor {
        HashSet refs = new HashSet();

        CollectNamespacesVisitor() {
        }

        public void visitRef(RefPattern refPattern) {
            if (!this.refs.contains(refPattern)) {
                this.refs.add(refPattern);
                refPattern.getPattern().accept(this);
            }
        }

        public void visitEmpty() {
        }

        public void visitNotAllowed() {
        }

        public void visitError() {
        }

        public void visitGroup(Pattern pattern, Pattern pattern2) {
            while (pattern instanceof GroupPattern) {
                pattern2.accept(this);
                GroupPattern groupPattern = (GroupPattern)pattern;
                pattern = groupPattern.p1;
                pattern2 = groupPattern.p2;
            }
            pattern.accept(this);
            pattern2.accept(this);
        }

        public void visitInterleave(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }

        public void visitChoice(Pattern pattern, Pattern pattern2) {
            pattern.accept(this);
            pattern2.accept(this);
        }

        public void visitOneOrMore(Pattern pattern) {
            pattern.accept(this);
        }

        public void visitMN(Pattern pattern, int n, int n2) {
            pattern.accept(this);
        }

        public void visitMStar(Pattern pattern, int n) {
            pattern.accept(this);
        }

        public void visitElement(NameClass nameClass, Pattern pattern) {
            nameClass.accept(PatternPrettyPrinter.this.collectNamespaces);
            pattern.accept(this);
        }

        public void visitAttribute(NameClass nameClass, Pattern pattern) {
            nameClass.accept(PatternPrettyPrinter.this.collectNamespaces);
            pattern.accept(this);
        }

        public void visitData(Datatype datatype) {
            if (datatype instanceof DatatypeWrapper) {
                DatatypeWrapper datatypeWrapper = (DatatypeWrapper)datatype;
                String string = datatypeWrapper.getLibraryName();
                Count count = (Count)PatternPrettyPrinter.this.dtcounts.get(string);
                if (count == null) {
                    count = new Count();
                    PatternPrettyPrinter.this.dtcounts.put(string, count);
                } else {
                    count.increment();
                }
            }
        }

        public void visitDataExcept(Datatype datatype, Pattern pattern) {
            this.visitData(datatype);
            pattern.accept(this);
        }

        public void visitValue(Datatype datatype, Object object) {
            this.visitData(datatype);
        }

        public void visitText() {
        }

        public void visitList(Pattern pattern) {
            pattern.accept(this);
        }
    }

    private static class Count {
        private int count = 1;

        public void increment() {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    private class CollectNamespaces
    implements NameClassVisitor {
        CollectNamespaces() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept(this);
            nameClass2.accept(this);
        }

        public void visitNsName(String string) {
            PatternPrettyPrinter.this.namespaces.add(string);
        }

        public void visitNsNameExcept(String string, NameClass nameClass) {
            PatternPrettyPrinter.this.namespaces.add(string);
            nameClass.accept(this);
        }

        public void visitAnyName() {
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            nameClass.accept(this);
        }

        public void visitName(Name name) {
            PatternPrettyPrinter.this.namespaces.add(name.getNamespaceUri());
        }

        public void visitNull() {
        }

        public void visitError() {
        }
    }

    private class NormalizeRefsFunction
    implements MPatternFunction {
        int level = 0;
        HashSet recursive = new HashSet();
        private HashMap defined = new HashMap();

        NormalizeRefsFunction() {
        }

        public Object caseEmpty(EmptyPattern emptyPattern) {
            return emptyPattern;
        }

        public Object caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            return notAllowedPattern;
        }

        public Object caseError(ErrorPattern errorPattern) {
            return errorPattern;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            LinkedList<GroupPattern> linkedList = new LinkedList<GroupPattern>();
            Pattern pattern = groupPattern;
            while (pattern instanceof GroupPattern) {
                linkedList.add((GroupPattern)pattern);
                pattern = pattern.p1;
            }
            GroupPattern groupPattern2 = (GroupPattern)linkedList.removeLast();
            Pattern pattern2 = PatternPrettyPrinter.this.pool.makeGroup(groupPattern2.p1.applyForPattern(this), groupPattern2.p2.applyForPattern(this));
            while (linkedList.size() > 0) {
                groupPattern2 = (GroupPattern)linkedList.removeLast();
                pattern2 = PatternPrettyPrinter.this.pool.makeGroup(pattern2, groupPattern2.p2.applyForPattern(this));
            }
            return pattern2;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            return PatternPrettyPrinter.this.pool.makeInterleave(interleavePattern.p1.applyForPattern(this), interleavePattern.p2.applyForPattern(this));
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            return PatternPrettyPrinter.this.pool.makeChoice(choicePattern.p1.applyForPattern(this), choicePattern.p2.applyForPattern(this));
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            return PatternPrettyPrinter.this.pool.makeOneOrMore(oneOrMorePattern.getOperand().applyForPattern(this));
        }

        public Object caseMN(MNPattern mNPattern) {
            return PatternPrettyPrinter.this.pool.makeMN(mNPattern.getOperand().applyForPattern(this), mNPattern.getM(), mNPattern.getN());
        }

        public Object caseMStar(MStarPattern mStarPattern) {
            return PatternPrettyPrinter.this.pool.makeMStar(mStarPattern.getOperand().applyForPattern(this), mStarPattern.getM());
        }

        public Object caseElement(ElementPattern elementPattern) {
            String string;
            Object object;
            if (this.defined.containsKey(elementPattern)) {
                PatternPool.PrettyRefPattern prettyRefPattern = (PatternPool.PrettyRefPattern)this.defined.get(elementPattern);
                this.markUsed(prettyRefPattern);
                return prettyRefPattern;
            }
            NameClass nameClass = elementPattern.getNameClass();
            if (nameClass instanceof SimpleNameClass) {
                object = ((SimpleNameClass)nameClass).getName();
                string = ((Name)object).getLocalName();
            } else {
                string = nameClass instanceof AnyNameClass || nameClass instanceof AnyNameExceptNameClass ? "any" : "ns";
            }
            object = PatternPrettyPrinter.this.pool.makePrettyRef(string);
            ((PatternPool.PrettyRefPattern)object).level = this.level++;
            ((RefPattern)object).setPattern(elementPattern);
            this.defined.put(elementPattern, object);
            PatternPrettyPrinter.this.patternList.add(object);
            this.recursive.add(object);
            Pattern pattern = elementPattern.getContent().applyForPattern(this);
            --this.level;
            this.recursive.remove(object);
            elementPattern.setContent(pattern);
            return object;
        }

        private void markUsed(PatternPool.PrettyRefPattern prettyRefPattern) {
            ++prettyRefPattern.uses;
            if (this.recursive.contains(prettyRefPattern)) {
                prettyRefPattern.recursive = true;
            }
            if (prettyRefPattern.level > this.level) {
                prettyRefPattern.level = this.level;
            }
        }

        public Object caseRef(RefPattern refPattern) {
            if (refPattern.getPattern() == null) {
                return refPattern;
            }
            Pattern pattern = refPattern.getPattern();
            String string = refPattern.getName();
            while (pattern instanceof RefPattern) {
                refPattern = (RefPattern)pattern;
                pattern = refPattern.getPattern();
            }
            PatternPool.PrettyRefPattern prettyRefPattern = (PatternPool.PrettyRefPattern)this.defined.get(pattern);
            if (prettyRefPattern != null) {
                this.markUsed(prettyRefPattern);
                return prettyRefPattern;
            }
            Pattern pattern2 = pattern.applyForPattern(this);
            if (pattern instanceof ElementPattern) {
                return pattern2;
            }
            PatternPool.PrettyRefPattern prettyRefPattern2 = PatternPrettyPrinter.this.pool.makePrettyRef(string);
            prettyRefPattern2.level = this.level;
            prettyRefPattern2.setPattern(pattern2);
            this.defined.put(pattern, prettyRefPattern2);
            PatternPrettyPrinter.this.patternList.add(prettyRefPattern2);
            return prettyRefPattern2;
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            return attributePattern;
        }

        public Object caseData(DataPattern dataPattern) {
            return dataPattern;
        }

        public Object caseDataExcept(DataExceptPattern dataExceptPattern) {
            return dataExceptPattern;
        }

        public Object caseValue(ValuePattern valuePattern) {
            return valuePattern;
        }

        public Object caseText(TextPattern textPattern) {
            return textPattern;
        }

        public Object caseList(ListPattern listPattern) {
            return listPattern;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            return PatternPrettyPrinter.this.pool.makeAfter(afterPattern.p1.applyForPattern(this), afterPattern.p2.applyForPattern(this));
        }
    }
}

