/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.util.Local;
import com.objfac.xml.XMLCharacter;
import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import java.util.TreeMap;
import java.util.TreeSet;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeStreamingValidator;
import org.relaxng.datatype.ValidationContext;

public class RegexDatatype
implements Datatype,
DatatypeBuilder {
    RegexEngine engine;
    Regex regex;
    TreeMap map = new TreeMap();
    private static final char IDSTART = '$';

    public RegexDatatype(RegexEngine regexEngine) {
        this.engine = regexEngine;
    }

    public boolean isValid(String string, ValidationContext validationContext) {
        if (this.regex == null) {
            try {
                this.regex = this.engine.compile(this.getStringEx());
            }
            catch (RegexSyntaxException regexSyntaxException) {
                return false;
            }
        }
        return this.regex.matches(string);
    }

    private String getStringEx() {
        return null;
    }

    public void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        if (this.regex == null) {
            try {
                this.regex = this.engine.compile(this.getStringEx());
            }
            catch (RegexSyntaxException regexSyntaxException) {
                throw new DatatypeException(regexSyntaxException.getLocalizedMessage());
            }
        }
        if (!this.regex.matches(string)) {
            throw new DatatypeException(Local.format((String)"Value \"{0}\" does not match {1}", (Object)string, (Object)this.getStringEx()));
        }
    }

    public DatatypeStreamingValidator createStreamingValidator(final ValidationContext validationContext) {
        return new DatatypeStreamingValidator(){
            StringBuffer sb = new StringBuffer();

            public void addCharacters(char[] cArray, int n, int n2) {
                this.sb.append(cArray, n, n2);
            }

            public boolean isValid() {
                return RegexDatatype.this.isValid(this.sb.toString(), validationContext);
            }

            public void checkValid() throws DatatypeException {
                RegexDatatype.this.checkValid(this.sb.toString(), validationContext);
            }
        };
    }

    public Object createValue(String string, ValidationContext validationContext) {
        return string;
    }

    public boolean sameValue(Object object, Object object2) {
        return object.equals(object2);
    }

    public int valueHashCode(Object object) {
        return object.hashCode();
    }

    public int getIdType() {
        return 0;
    }

    public boolean isContextDependent() {
        return false;
    }

    public void addParameter(String string, String string2, ValidationContext validationContext) throws DatatypeException {
        if (this.map.containsKey(string)) {
            throw new DatatypeException(Local.format((String)"Duplicate rule {0}", (Object)string));
        }
        this.map.put(string, string2);
    }

    public Datatype createDatatype() throws DatatypeException {
        TreeSet treeSet = new TreeSet();
        TreeMap treeMap = new TreeMap();
        String string = null;
        try {
            string = this.resolve("start", treeSet, treeMap);
            this.regex = this.engine.compile(string);
            return this;
        }
        catch (RegexSyntaxException regexSyntaxException) {
            throw new DatatypeException(Local.format((String)"{0} at {2} in \"{2}\"", (Object)regexSyntaxException.getLocalizedMessage(), (Object)new Integer(regexSyntaxException.getPosition()), (Object)string));
        }
    }

    private String resolve(String string, TreeSet treeSet, TreeMap treeMap) throws DatatypeException {
        if (treeSet.contains(string)) {
            throw new DatatypeException(Local.format((String)"Rescursive use of {0} in pattern", (Object)string));
        }
        String string2 = (String)treeMap.get(string);
        if (string2 == null) {
            String string3 = (String)this.map.get(string);
            if (string3 == null) {
                throw new DatatypeException(Local.format((String)"Missing {0} rule", (Object)string));
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            int n2 = string3.length();
            while (n < n2) {
                char c = string3.charAt(n);
                if (c == '$') {
                    if (n + 1 == n2) {
                        throw new DatatypeException(Local.format((String)"Unescaped $ in expression {0}=\"{1}\"", (Object)string, (Object)string3));
                    }
                    if (string3.charAt(++n) == '$') {
                        stringBuffer.append('$');
                    } else {
                        int n3 = n;
                        while (n < n2 && XMLCharacter.isIDPart((char)string3.charAt(n))) {
                            ++n;
                        }
                        if (n3 == n) {
                            throw new DatatypeException(Local.format((String)"Unescaped $ in expression {0}=\"{1}\"", (Object)string, (Object)string3));
                        }
                        String string4 = string3.substring(n3, n);
                        treeSet.add(string);
                        stringBuffer.append(this.resolve(string4, treeSet, treeMap));
                        treeSet.remove(string);
                        --n;
                    }
                } else {
                    stringBuffer.append(c);
                }
                ++n;
            }
            string2 = stringBuffer.toString();
            treeMap.put(string, string2);
        }
        return string2;
    }
}

