/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.walker.IWalker;
import com.thaiopensource.relaxng.impl.AnyNameClass;
import com.thaiopensource.relaxng.impl.AnyNameExceptNameClass;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.MPatternVisitor;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternPool;
import com.thaiopensource.relaxng.impl.PatternWalker;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.util.AbstractSequentialList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObject;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaWalkerFactory {
    private NameClass anyNameNameClass;
    private String grammarNamespace;
    private RefPattern anyTypeContents;
    private Locator locator;
    private ErrorHandler eh;
    private HashSet names = new HashSet();
    private int uniqueNum;
    private HashMap namespaceStarts = new HashMap();
    private HashMap deferredWildcards = new HashMap();
    private HashMap deferredTopLevelElements = new HashMap();
    private HashMap subGroups = new HashMap();
    private HashMap namespaceAttributes = new HashMap();
    private HashMap anyElementPatterns = new HashMap();
    private HashMap anyContentPatterns = new HashMap();
    private HashMap contentPatterns = new HashMap();
    private HashMap types = new HashMap();
    private LinkedList laxWildcards = new LinkedList();
    private LinkedList strictWildcards = new LinkedList();
    private GetNameVisitor getNameVisitor = new GetNameVisitor();
    private PatternPool pool;
    private IWalker dtdWalker;
    private XMLGrammarPool grammarPool;
    private Pattern start;
    private HashMap fModelGroupRefs = new HashMap();
    private int uniqueModelGroupNum = 0;
    private static final boolean TESTMN = false;

    public static PatternWalker makeSchemaWalker(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, IWalker iWalker, ErrorHandler errorHandler, Locator locator) throws SAXException {
        SchemaWalkerFactory schemaWalkerFactory = new SchemaWalkerFactory(symbolTable, xMLGrammarPool, iWalker, errorHandler, locator);
        try {
            return schemaWalkerFactory.generateWalker();
        }
        catch (WrapException wrapException) {
            throw wrapException.getException();
        }
    }

    private SchemaWalkerFactory(SymbolTable symbolTable, XMLGrammarPool xMLGrammarPool, IWalker iWalker, ErrorHandler errorHandler, Locator locator) {
        this.grammarPool = xMLGrammarPool;
        this.dtdWalker = iWalker;
        this.eh = errorHandler;
        this.locator = locator;
        this.pool = new PatternPool();
        this.start = this.pool.makeNotAllowed();
    }

    private PatternWalker generateWalker() {
        Grammar[] grammarArray = this.grammarPool.retrieveInitialGrammarSet("http://www.w3.org/2001/XMLSchema");
        int n = 0;
        while (n < grammarArray.length) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammarArray[n];
            this.generateWalker(schemaGrammar);
            ++n;
        }
        PatternWalker patternWalker = new PatternWalker(this.pool, this.start, this.dtdWalker);
        patternWalker.setXMLSchema(true);
        return patternWalker;
    }

    public static PatternWalker schemaToWalker(SchemaGrammar schemaGrammar, PatternPool patternPool) {
        SchemaWalkerFactory schemaWalkerFactory = new SchemaWalkerFactory(patternPool);
        return schemaWalkerFactory.makeWalker(schemaGrammar);
    }

    private PatternWalker makeWalker(SchemaGrammar schemaGrammar) {
        this.generateWalker(schemaGrammar);
        this.fixupWildcards();
        PatternWalker patternWalker = new PatternWalker(this.pool);
        patternWalker.setStartPattern(this.start);
        patternWalker.setXMLSchema(true);
        return patternWalker;
    }

    public SchemaWalkerFactory(PatternPool patternPool) {
        this.grammarPool = null;
        this.dtdWalker = null;
        this.eh = null;
        this.locator = null;
        this.pool = patternPool;
        this.start = patternPool.makeNotAllowed();
    }

    private void generateWalker(SchemaGrammar schemaGrammar) {
        LinkedList linkedList;
        Object object;
        Pattern pattern;
        Object object2;
        XSObject xSObject;
        this.grammarNamespace = this.nonNull(schemaGrammar.getTargetNamespace());
        Pattern pattern2 = this.start;
        this.start = this.pool.makeNotAllowed();
        XSNamedMap xSNamedMap = schemaGrammar.getComponents((short)2);
        int n = 0;
        int n2 = xSNamedMap.getLength();
        while (n < n2) {
            xSObject = xSNamedMap.item(n);
            if (xSObject instanceof XSElementDeclaration) {
                object2 = (XSElementDeclaration)xSObject;
                this.referTopLevelElementPattern((XSElementDeclaration)object2);
            }
            ++n;
        }
        xSNamedMap = schemaGrammar.getComponents((short)2);
        n = 0;
        n2 = xSNamedMap.getLength();
        while (n < n2) {
            xSObject = xSNamedMap.item(n);
            if (xSObject instanceof XSAttributeDeclaration) {
                object2 = (LinkedList)this.namespaceAttributes.get(this.grammarNamespace);
                if (object2 == null) {
                    object2 = new LinkedList();
                    this.namespaceAttributes.put(this.grammarNamespace, object2);
                }
                ((LinkedList)object2).add(xSObject);
            } else if (xSObject instanceof XSElementDeclaration) {
                object2 = (XSElementDeclaration)xSObject;
                pattern = this.makeTopLevelElementPattern((XSElementDeclaration)object2);
                object = object2.getSubstitutionGroupAffiliation();
                if (object != null) {
                    if (!object2.getAbstract()) {
                        linkedList = (LinkedList)this.subGroups.get(object);
                        if (linkedList == null) {
                            linkedList = new LinkedList();
                            this.subGroups.put(object, linkedList);
                        }
                        linkedList.add(pattern);
                    }
                } else if (!object2.getAbstract()) {
                    this.addTopLevelElement((XSElementDeclaration)object2, pattern);
                } else {
                    linkedList = (LinkedList)this.subGroups.get(object2);
                    if (linkedList == null) {
                        linkedList = new LinkedList();
                        this.subGroups.put(object2, linkedList);
                    }
                }
            }
            ++n;
        }
        this.start = this.pool.makeChoice(pattern2, this.start);
        Pattern pattern3 = (Pattern)this.namespaceStarts.get(this.grammarNamespace);
        pattern3 = pattern3 != null ? this.pool.makeChoice(pattern3, this.start) : this.start;
        this.namespaceStarts.put(this.grammarNamespace, pattern3);
        Iterator iterator = this.subGroups.keySet().iterator();
        while (iterator.hasNext()) {
            xSObject = (XSElementDeclaration)iterator.next();
            object2 = (LinkedList)this.subGroups.get(xSObject);
            if (object2 == null) continue;
            pattern = this.referTopLevelElementPattern((XSElementDeclaration)xSObject);
            if (!xSObject.getAbstract()) {
                object = this.pool.makeRef(((RefPattern)pattern).getName());
                ((RefPattern)object).setPattern(((RefPattern)pattern).getPattern());
                ((LinkedList)object2).add(object);
            }
            ((RefPattern)pattern).setName(String.valueOf(((RefPattern)pattern).getName()) + "_sub");
            object = this.pool.makeNotAllowed();
            linkedList = ((AbstractSequentialList)object2).iterator();
            while (linkedList.hasNext()) {
                Object e = linkedList.next();
                object = this.pool.makeChoice((Pattern)object, (Pattern)e);
            }
            ((RefPattern)pattern).setPattern((Pattern)object);
        }
    }

    private void fixupWildcards() {
        Object object;
        String string;
        Object object2;
        Object object3;
        Iterator iterator = this.strictWildcards.iterator();
        while (iterator.hasNext()) {
            object3 = (RefPattern)iterator.next();
            object2 = (XSWildcard)iterator.next();
            string = (String)iterator.next();
            object = this.getAllowedStarts((XSWildcard)object2, string);
            ((RefPattern)object3).setPattern((Pattern)object);
        }
        object3 = this.laxWildcards.iterator();
        while (object3.hasNext()) {
            object2 = (RefPattern)object3.next();
            string = (XSWildcard)object3.next();
            object = (String)object3.next();
            Pattern pattern = this.getAllowedStarts((XSWildcard)string, (String)object);
            pattern = this.pool.makeChoice(pattern, ((RefPattern)object2).getPattern());
            ((RefPattern)object2).setPattern(pattern);
        }
    }

    private Pattern getAllowedStarts(XSWildcard xSWildcard, String string) {
        LinkedList linkedList = this.collectNamespaces(xSWildcard, string);
        Pattern pattern = this.pool.makeNotAllowed();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            Pattern pattern2 = (Pattern)this.namespaceStarts.get(string2);
            if (pattern2 == null) continue;
            pattern = this.pool.makeChoice(pattern, pattern2);
        }
        return pattern;
    }

    private LinkedList collectNamespaces(XSWildcard xSWildcard, String string) {
        LinkedList<String> linkedList = null;
        switch (xSWildcard.getConstraintType()) {
            case 1: {
                linkedList = this.allNamespaces();
                break;
            }
            case 2: {
                linkedList = this.allNamespaces();
                linkedList.remove(string);
                break;
            }
            case 3: {
                linkedList = new LinkedList<String>();
                StringList stringList = xSWildcard.getNsConstraintList();
                int n = 0;
                int n2 = stringList.getLength();
                while (n < n2) {
                    linkedList.add(this.notNull(stringList.item(n)));
                    ++n;
                }
                break;
            }
        }
        return linkedList;
    }

    private LinkedList allNamespaces() {
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = this.namespaceStarts.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            linkedList.add(string);
        }
        return linkedList;
    }

    private Pattern addChoice(Pattern pattern, Pattern pattern2) {
        if (pattern == null) {
            return pattern2;
        }
        return this.pool.makeChoice(pattern, pattern2);
    }

    private void addTopLevelElement(XSElementDeclaration xSElementDeclaration, Pattern pattern) {
        this.start = this.pool.makeChoice(this.start, pattern);
    }

    private Pattern makeTopLevelElementPattern(XSElementDeclaration xSElementDeclaration) {
        RefPattern refPattern = this.referTopLevelElementPattern(xSElementDeclaration);
        if (refPattern.getPattern() == null) {
            refPattern.setPattern(this.makeElementPattern(xSElementDeclaration));
        }
        return refPattern;
    }

    private RefPattern referTopLevelElementPattern(XSElementDeclaration xSElementDeclaration) {
        RefPattern refPattern = (RefPattern)this.deferredTopLevelElements.get(xSElementDeclaration);
        if (refPattern == null) {
            refPattern = this.pool.makeRef(this.uniqueName(xSElementDeclaration.getName(), xSElementDeclaration.getNamespace()));
            this.deferredTopLevelElements.put(xSElementDeclaration, refPattern);
        }
        return refPattern;
    }

    private String uniqueName(String string, String string2) {
        if (string == null) {
            return "any";
        }
        return String.valueOf(string) + (string2 == null ? "" : "{" + string2 + "}");
    }

    private Pattern makeLowerLevelElementPattern(XSElementDeclaration xSElementDeclaration) {
        Pattern pattern;
        if (xSElementDeclaration.getScope() == 1) {
            RefPattern refPattern = (RefPattern)this.deferredTopLevelElements.get(xSElementDeclaration);
            if (refPattern == null) {
                refPattern = this.pool.makeRef(this.uniqueName(xSElementDeclaration.getName(), xSElementDeclaration.getNamespace()));
                this.deferredTopLevelElements.put(xSElementDeclaration, refPattern);
                refPattern.setPattern(this.makeElementPattern(xSElementDeclaration));
            }
            pattern = refPattern;
        } else {
            pattern = this.makeElementPattern(xSElementDeclaration);
        }
        return pattern;
    }

    private Pattern makeElementPattern(XSElementDeclaration xSElementDeclaration) {
        Object object;
        Pattern pattern = this.makeContentModel(xSElementDeclaration);
        pattern = this.setDefaultFixed(xSElementDeclaration.getConstraintType(), xSElementDeclaration.getConstraintValue(), pattern);
        if (xSElementDeclaration.getNillable() && xSElementDeclaration.getConstraintType() != 2) {
            object = this.pool.makeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", this.pool.makeValue(this.pool.makeTokenDatatype(), "true"));
            NameClass nameClass = ((AttributePattern)object).getNameClass();
            XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
            short s = xSTypeDefinition.getTypeCategory();
            if (s == 15) {
                object = this.addAttributes((XSComplexTypeDefinition)xSTypeDefinition, (Pattern)object, nameClass);
            }
            pattern = this.pool.makeChoice(pattern, (Pattern)object);
        }
        object = this.pool.makeName(this.nonNull(xSElementDeclaration.getNamespace()), xSElementDeclaration.getName());
        return this.pool.makeElement((NameClass)object, pattern);
    }

    private Pattern makeRefElementPattern(XSElementDeclaration xSElementDeclaration) {
        Pattern pattern = this.makeElementPattern(xSElementDeclaration);
        RefPattern refPattern = this.pool.makeRef(this.uniqueName(xSElementDeclaration.getName(), xSElementDeclaration.getNamespace()));
        refPattern.setPattern(pattern);
        return refPattern;
    }

    private String uniqueName(String string) {
        if (string == null) {
            string = "any";
        }
        String string2 = string;
        return string2;
    }

    private String nonNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private Pattern makeContentModel(XSElementDeclaration xSElementDeclaration) {
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        short s = xSTypeDefinition.getTypeCategory();
        if (s == 16) {
            return this.makeSimpleContentModel((XSSimpleTypeDefinition)xSTypeDefinition);
        }
        return this.makeComplexContentModel((XSComplexTypeDefinition)xSTypeDefinition);
    }

    private Pattern makeSimpleContentModel(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        Pattern pattern;
        switch (xSSimpleTypeDefinition.getVariety()) {
            case 0: {
                pattern = this.pool.makeText();
                break;
            }
            case 1: {
                pattern = this.makeAtomicContentModel(xSSimpleTypeDefinition);
                break;
            }
            case 2: {
                pattern = this.makeListContentModel(xSSimpleTypeDefinition);
                break;
            }
            case 3: {
                pattern = this.makeUnionContentModel(xSSimpleTypeDefinition);
                break;
            }
            default: {
                pattern = this.pool.makeNotAllowed();
            }
        }
        return pattern;
    }

    private Pattern makeUnionContentModel(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        Pattern pattern = this.getTypeRef((XSTypeDefinition)xSSimpleTypeDefinition);
        if (pattern != null) {
            return pattern;
        }
        pattern = this.pool.makeNotAllowed();
        XSObjectList xSObjectList = xSSimpleTypeDefinition.getMemberTypes();
        int n = 0;
        int n2 = xSObjectList.getLength();
        while (n < n2) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition2 = (XSSimpleTypeDefinition)xSObjectList.item(n);
            Pattern pattern2 = this.makeSimpleContentModel(xSSimpleTypeDefinition2);
            pattern = this.pool.makeChoice(pattern, pattern2);
            ++n;
        }
        return this.setTypeRef((XSTypeDefinition)xSSimpleTypeDefinition, pattern);
    }

    private Pattern makeListContentModel(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        Pattern pattern = this.getTypeRef((XSTypeDefinition)xSSimpleTypeDefinition);
        if (pattern != null) {
            return pattern;
        }
        XSSimpleTypeDefinition xSSimpleTypeDefinition2 = xSSimpleTypeDefinition.getItemType();
        Pattern pattern2 = this.makeSimpleContentModel(xSSimpleTypeDefinition2);
        pattern = this.pool.makeList(this.pool.makeZeroOrMore(pattern2));
        return this.setTypeRef((XSTypeDefinition)xSSimpleTypeDefinition, pattern);
    }

    private Pattern makeAtomicContentModel(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        String string;
        String string2 = xSSimpleTypeDefinition.getNamespace();
        if (this.isBuiltIn(string2, string = xSSimpleTypeDefinition.getName())) {
            try {
                PatternPool.DatatypeMaker datatypeMaker = this.pool.makeDatatypeMaker(string2, string);
                return this.pool.makeData(datatypeMaker.createDatatype());
            }
            catch (DatatypeException datatypeException) {}
        } else {
            Pattern pattern = this.getTypeRef((XSTypeDefinition)xSSimpleTypeDefinition);
            if (pattern != null) {
                return pattern;
            }
            XSSimpleTypeDefinition xSSimpleTypeDefinition2 = this.getBuiltInType((XSSimpleTypeDefinition)xSSimpleTypeDefinition.getBaseType());
            try {
                Object object;
                Object object2;
                PatternPool.DatatypeMaker datatypeMaker = this.pool.makeDatatypeMaker(xSSimpleTypeDefinition2.getNamespace(), xSSimpleTypeDefinition2.getName());
                boolean bl = "http://www.w3.org/2001/XMLSchema".equals(xSSimpleTypeDefinition2.getNamespace()) && "QName".equals(xSSimpleTypeDefinition2.getName());
                short s = xSSimpleTypeDefinition.getDefinedFacets();
                if ((0x800 & s) != 0) {
                    object2 = (XSSimpleTypeDecl)xSSimpleTypeDefinition;
                    object2.getName();
                    object2.getNamespace();
                    object = datatypeMaker.createDatatype();
                    Pattern pattern2 = this.pool.makeNotAllowed();
                    StringList stringList = xSSimpleTypeDefinition.getLexicalEnumeration();
                    Vector vector = object2.getEnumeration();
                    int n = 0;
                    int n2 = stringList.getLength();
                    while (n < n2) {
                        String string3 = stringList.item(n);
                        Object e = vector.elementAt(n);
                        if (string3 != null) {
                            Pattern pattern3;
                            if (bl) {
                                QName qName = (QName)e;
                                pattern3 = this.pool.makeQNameValue((Datatype)object, string3, qName.uri);
                            } else {
                                pattern3 = this.pool.makeValue((Datatype)object, string3);
                            }
                            pattern2 = this.pool.makeChoice(pattern2, pattern3);
                        }
                        ++n;
                    }
                    if (!pattern2.isNotAllowed()) {
                        return this.setTypeRef((XSTypeDefinition)xSSimpleTypeDefinition, pattern2);
                    }
                }
                if (s != 0) {
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "length", (short)1);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "minLength", (short)2);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "maxLength", (short)4);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "whitespace", (short)16);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "maxInclusive", (short)32);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "maxExclusive", (short)64);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "minInclusive", (short)256);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "minExclusive", (short)128);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "totalDigits", (short)512);
                    this.addParameter(datatypeMaker, xSSimpleTypeDefinition, xSSimpleTypeDefinition2, s, "fractionDigits", (short)1024);
                }
                if ((8 & s) != 0) {
                    object2 = xSSimpleTypeDefinition.getLexicalPattern();
                    int n = 0;
                    int n3 = object2.getLength();
                    while (n < n3) {
                        ++n;
                    }
                }
                object2 = datatypeMaker.createDatatype();
                object = this.pool.makeData((Datatype)object2);
                return this.setTypeRef((XSTypeDefinition)xSSimpleTypeDefinition, (Pattern)object);
            }
            catch (DatatypeException datatypeException) {}
        }
        return this.pool.makeText();
    }

    private void addParameter(PatternPool.DatatypeMaker datatypeMaker, XSSimpleTypeDefinition xSSimpleTypeDefinition, XSSimpleTypeDefinition xSSimpleTypeDefinition2, short s, String string, short s2) {
        int n = s & s2;
        if (n != 0) {
            String string2 = xSSimpleTypeDefinition.getLexicalFacetValue(s2);
            String string3 = null;
            if ((xSSimpleTypeDefinition2.getDefinedFacets() & s2) != 0) {
                string3 = xSSimpleTypeDefinition2.getLexicalFacetValue(s2);
            }
            if (string2 != null && !string2.equals(string3)) {
                try {
                    datatypeMaker.addParameter(string, string2);
                }
                catch (DatatypeException datatypeException) {}
            }
        }
    }

    private XSSimpleTypeDefinition getBuiltInType(XSSimpleTypeDefinition xSSimpleTypeDefinition) {
        String string;
        String string2 = xSSimpleTypeDefinition.getNamespace();
        if (this.isBuiltIn(string2, string = xSSimpleTypeDefinition.getName())) {
            return xSSimpleTypeDefinition;
        }
        return this.getBuiltInType((XSSimpleTypeDefinition)xSSimpleTypeDefinition.getBaseType());
    }

    private final boolean isBuiltIn(String string, String string2) {
        if (string == null || !string.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA)) {
            return false;
        }
        return SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl(string2) != null;
    }

    private String getKey(XSTypeDefinition xSTypeDefinition) {
        String string = xSTypeDefinition.getName();
        String string2 = xSTypeDefinition.getNamespace();
        return String.valueOf(string) + (string2 == null ? "" : "{" + string2 + "}");
    }

    private Pattern getTypeRef(XSTypeDefinition xSTypeDefinition) {
        return xSTypeDefinition.getAnonymous() ? null : (Pattern)this.types.get(this.getKey(xSTypeDefinition));
    }

    private Pattern setTypeRef(XSTypeDefinition xSTypeDefinition, Pattern pattern) {
        Pattern pattern2 = pattern;
        if (!xSTypeDefinition.getAnonymous()) {
            RefPattern refPattern;
            String string = xSTypeDefinition.getName();
            if (pattern instanceof RefPattern && ((RefPattern)pattern).getName().equals(string)) {
                refPattern = (RefPattern)pattern;
            } else {
                refPattern = this.pool.makeRef(xSTypeDefinition.getName());
                refPattern.setPattern(pattern);
            }
            this.types.put(this.getKey(xSTypeDefinition), refPattern);
            pattern2 = refPattern;
        }
        return pattern2;
    }

    private Pattern setTypeRef(XSTypeDefinition xSTypeDefinition, RefPattern refPattern) {
        this.types.put(this.getKey(xSTypeDefinition), refPattern);
        return refPattern;
    }

    private Pattern makeComplexContentModel(XSComplexTypeDefinition xSComplexTypeDefinition) {
        Pattern pattern = this.getTypeRef((XSTypeDefinition)xSComplexTypeDefinition);
        if (pattern != null) {
            return pattern;
        }
        if ("anyType".equals(xSComplexTypeDefinition.getName()) && SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(xSComplexTypeDefinition.getNamespace())) {
            pattern = this.setTypeRef((XSTypeDefinition)xSComplexTypeDefinition, this.makeAnyTypeContents());
        } else {
            Pattern pattern2 = this.setTypeRef((XSTypeDefinition)xSComplexTypeDefinition, (Pattern)null);
            switch (xSComplexTypeDefinition.getContentType()) {
                case 0: {
                    pattern = this.addAttributes(xSComplexTypeDefinition, this.pool.makeEmpty());
                    break;
                }
                case 1: {
                    pattern = this.makeSimpleWithAttributesContentModel(xSComplexTypeDefinition);
                    break;
                }
                case 2: {
                    pattern = this.makeElementContentModel(xSComplexTypeDefinition);
                    break;
                }
                case 3: {
                    pattern = this.pool.makeMixed(this.makeElementContentModel(xSComplexTypeDefinition));
                    break;
                }
                default: {
                    throw new IllegalStateException("content type not empty,simple, element or mixed");
                }
            }
            if (pattern2 == null) {
                pattern = this.setTypeRef((XSTypeDefinition)xSComplexTypeDefinition, pattern);
            } else {
                ((RefPattern)pattern2).setPattern(pattern);
                pattern = pattern2;
            }
        }
        return pattern;
    }

    private Pattern makeAnyTypeContents() {
        if (this.anyTypeContents != null) {
            return this.anyTypeContents;
        }
        RefPattern refPattern = this.pool.makeRef(this.uniqueName("anyType"));
        ElementPattern elementPattern = (ElementPattern)this.pool.makeElement(this.getAnyNameNameClass(), refPattern);
        Pattern pattern = this.pool.makeMixed(this.pool.makeZeroOrMore(this.pool.makeChoice(elementPattern, this.pool.makeAttribute(this.getAnyNameNameClass(), this.pool.makeText()))));
        refPattern.setPattern(pattern);
        this.anyTypeContents = refPattern;
        return refPattern;
    }

    private Pattern makeAnyNsTypeContents(NameClass nameClass) {
        if (this.anyTypeContents != null) {
            return this.anyTypeContents;
        }
        RefPattern refPattern = this.pool.makeRef(this.uniqueName(nameClass instanceof AnyNameExceptNameClass ? "anyExceptNs" : "anyNs"));
        ElementPattern elementPattern = (ElementPattern)this.pool.makeElement(nameClass, refPattern);
        Pattern pattern = this.pool.makeMixed(this.pool.makeZeroOrMore(this.pool.makeChoice(elementPattern, this.pool.makeAttribute(nameClass, this.pool.makeText()))));
        refPattern.setPattern(pattern);
        this.anyTypeContents = refPattern;
        return refPattern;
    }

    private Pattern makeElementContentModel(XSComplexTypeDefinition xSComplexTypeDefinition) {
        Pattern pattern = this.acceptParticle(xSComplexTypeDefinition.getParticle());
        return this.addAttributes(xSComplexTypeDefinition, pattern);
    }

    private Pattern acceptParticle(XSParticle xSParticle) {
        Pattern pattern = null;
        XSTerm xSTerm = xSParticle.getTerm();
        if (xSTerm instanceof XSElementDeclaration) {
            pattern = this.acceptElementDeclaration((XSElementDeclaration)xSTerm, xSParticle);
        } else if (xSTerm instanceof XSModelGroup) {
            pattern = this.acceptModelGroup((XSModelGroup)xSTerm, xSParticle);
        } else if (xSTerm instanceof XSWildcard) {
            pattern = this.acceptWildcard((XSWildcard)xSTerm, xSParticle);
        } else {
            throw new IllegalStateException("term is not XSElementDeclaration, XSModelGroup or XSWildcard");
        }
        return this.iterate(pattern, xSParticle);
    }

    private Pattern acceptModelGroup(XSModelGroup xSModelGroup, XSParticle xSParticle) {
        String string = this.getUniqueModelGroupName(xSModelGroup.getName());
        RefPattern refPattern = (RefPattern)this.fModelGroupRefs.get(string);
        if (refPattern != null) {
            return refPattern;
        }
        refPattern = this.pool.makeRef(string);
        this.fModelGroupRefs.put(string, refPattern);
        short s = xSModelGroup.getCompositor();
        XSObjectList xSObjectList = xSModelGroup.getParticles();
        Pattern pattern = null;
        switch (s) {
            case 1: {
                pattern = this.apply(xSObjectList, this.pool.makeEmpty(), new BinaryOp(){

                    public Pattern apply(Pattern pattern, Pattern pattern2) {
                        return SchemaWalkerFactory.this.pool.makeGroup(pattern, pattern2);
                    }
                });
                break;
            }
            case 2: {
                pattern = this.apply(xSObjectList, this.pool.makeNotAllowed(), new BinaryOp(){

                    public Pattern apply(Pattern pattern, Pattern pattern2) {
                        return SchemaWalkerFactory.this.pool.makeChoice(pattern, pattern2);
                    }
                });
                break;
            }
            case 3: {
                pattern = this.apply(xSObjectList, this.pool.makeEmpty(), new BinaryOp(){

                    public Pattern apply(Pattern pattern, Pattern pattern2) {
                        return SchemaWalkerFactory.this.pool.makeInterleave(pattern, pattern2);
                    }
                });
                break;
            }
            default: {
                throw new IllegalStateException("compositor is not sequence, choice or all");
            }
        }
        refPattern.setPattern(pattern);
        return pattern;
    }

    private String getUniqueModelGroupName(String string) {
        if (string == null) {
            string = "unnamed" + ++this.uniqueModelGroupNum;
        }
        string = String.valueOf(string) + "modelgroup";
        return string;
    }

    private Pattern iterate(Pattern pattern, XSParticle xSParticle) {
        int n = xSParticle.getMinOccurs();
        if (xSParticle.getMaxOccursUnbounded()) {
            if (n == 0) {
                pattern = this.pool.makeChoice(this.pool.makeOneOrMore(pattern), this.pool.makeEmpty());
            } else if (n == 1) {
                pattern = this.pool.makeOneOrMore(pattern);
            } else {
                if (n > 100) {
                    this.warn("minOccurs=\"" + n + "\" truncated to 100");
                    n = 100;
                }
                Pattern pattern2 = pattern = this.getOccursRef(pattern);
                int n2 = 2;
                while (n2 < n) {
                    pattern2 = this.pool.makeGroup(pattern2, pattern);
                    ++n2;
                }
                pattern = this.pool.makeGroup(pattern2, this.pool.makeOneOrMore(pattern));
            }
        } else {
            int n3 = xSParticle.getMaxOccurs();
            if (n != 1 || n3 != 1) {
                if (n > 100) {
                    this.warn("minOccurs=\"" + n + "\" truncated to 100");
                    n = 100;
                }
                if (n3 > 1) {
                    pattern = this.getOccursRef(pattern);
                }
                Pattern pattern3 = this.pool.makeEmpty();
                int n4 = 0;
                while (n4 < n) {
                    pattern3 = this.pool.makeGroup(pattern3, pattern);
                    ++n4;
                }
                if (n4 < n3) {
                    if (n3 > 100) {
                        this.warn("maxOccurs=\"" + n3 + "\" truncated to 100");
                        n3 = 100;
                    }
                    Pattern pattern4 = this.pool.makeOptional(pattern);
                    while (n4 < n3) {
                        pattern3 = this.pool.makeGroup(pattern3, pattern4);
                        ++n4;
                    }
                }
                pattern = pattern3;
            }
        }
        return pattern;
    }

    private Pattern getOccursRef(Pattern pattern) {
        if (pattern instanceof RefPattern || pattern instanceof DataPattern || pattern instanceof ValuePattern) {
            return pattern;
        }
        String string = this.getNameVisitor.getName(pattern);
        if (string == null) {
            string = "occurs";
        }
        RefPattern refPattern = this.pool.makeRef(this.uniqueName(string));
        refPattern.setPattern(pattern);
        return refPattern;
    }

    private void warn(String string) {
        try {
            if (this.eh != null) {
                this.eh.warning(new SAXParseException(string, this.locator));
            }
        }
        catch (SAXException sAXException) {
            throw new WrapException(sAXException);
        }
    }

    private Pattern apply(XSObjectList xSObjectList, Pattern pattern, BinaryOp binaryOp) {
        Pattern pattern2 = pattern;
        int n = 0;
        int n2 = xSObjectList.getLength();
        while (n < n2) {
            XSParticle xSParticle = (XSParticle)xSObjectList.item(n);
            Pattern pattern3 = this.acceptParticle(xSParticle);
            pattern2 = binaryOp.apply(pattern2, pattern3);
            ++n;
        }
        return pattern2;
    }

    private Pattern acceptElementDeclaration(XSElementDeclaration xSElementDeclaration, XSParticle xSParticle) {
        return this.makeLowerLevelElementPattern(xSElementDeclaration);
    }

    private Pattern acceptWildcard(XSWildcard xSWildcard, XSParticle xSParticle) {
        Pattern pattern = null;
        switch (xSWildcard.getProcessContents()) {
            case 2: {
                pattern = this.makeSkipWildcard(xSWildcard, xSParticle);
                break;
            }
            case 3: {
                pattern = this.makeLaxWildcard(xSWildcard, xSParticle);
                break;
            }
            case 1: {
                pattern = this.makeStrictWildcard(xSWildcard, xSParticle);
            }
        }
        return pattern;
    }

    private Pattern makeAnyPattern(NameClass nameClass) {
        RefPattern refPattern = (RefPattern)this.contentPatterns.get(nameClass);
        if (refPattern != null) {
            return refPattern;
        }
        refPattern = this.pool.makeRef(this.uniqueName(null));
        Pattern pattern = this.pool.makeZeroOrMore(this.pool.makeChoice(this.pool.makeChoice(this.pool.makeAttribute(nameClass, this.pool.makeText()), this.pool.makeText()), refPattern));
        refPattern.setPattern(this.pool.makeElement(nameClass, pattern));
        this.contentPatterns.put(nameClass, refPattern);
        return refPattern;
    }

    private Pattern makeStrictWildcard(XSWildcard xSWildcard, XSParticle xSParticle) {
        Object object;
        NameClass nameClass = null;
        switch (xSWildcard.getConstraintType()) {
            case 1: {
                nameClass = this.pool.makeNsName("##any");
                break;
            }
            case 2: {
                nameClass = this.pool.makeOtherName(this.grammarNamespace);
                break;
            }
            case 3: {
                object = xSWildcard.getNsConstraintList();
                int n = object.getLength();
                int n2 = 0;
                while (n2 < n) {
                    String string = object.item(n2);
                    if (string != null) {
                        if ("##targetNamespace".equals(string)) {
                            string = this.grammarNamespace;
                        }
                        NameClass nameClass2 = this.pool.makeNsName(string);
                        nameClass = nameClass == null ? nameClass2 : this.pool.makeChoiceNameClass(nameClass, nameClass2);
                    }
                    ++n2;
                }
                break;
            }
        }
        if (nameClass == null) {
            this.warn("No namespace scope defined for any");
            nameClass = this.pool.makeNsName("##any");
        }
        object = this.pool.makeElement(nameClass, this.makeAnyTypeContents());
        return object;
    }

    private Pattern makeLaxWildcard(XSWildcard xSWildcard, XSParticle xSParticle) {
        return this.makeStrictWildcard(xSWildcard, xSParticle);
    }

    private Pattern makeSkipWildcard(XSWildcard xSWildcard, XSParticle xSParticle) {
        return this.makeStrictWildcard(xSWildcard, xSParticle);
    }

    private Pattern makeSimpleWithAttributesContentModel(XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSSimpleTypeDefinition xSSimpleTypeDefinition = xSComplexTypeDefinition.getSimpleType();
        Pattern pattern = this.makeAtomicContentModel(xSSimpleTypeDefinition);
        return this.addAttributes(xSComplexTypeDefinition, pattern);
    }

    private Pattern addAttributes(XSComplexTypeDefinition xSComplexTypeDefinition, Pattern pattern) {
        return this.addAttributes(xSComplexTypeDefinition, pattern, null);
    }

    private Pattern addAttributes(XSComplexTypeDefinition xSComplexTypeDefinition, Pattern pattern, NameClass nameClass) {
        XSWildcard xSWildcard;
        Pattern pattern2 = this.pool.makeEmpty();
        XSObjectList xSObjectList = xSComplexTypeDefinition.getAttributeUses();
        if (xSObjectList != null) {
            int n = 0;
            int n2 = xSObjectList.getLength();
            while (n < n2) {
                XSAttributeUse xSAttributeUse = (XSAttributeUse)xSObjectList.item(n);
                XSAttributeDeclaration xSAttributeDeclaration = xSAttributeUse.getAttrDeclaration();
                XSSimpleTypeDefinition xSSimpleTypeDefinition = xSAttributeDeclaration.getTypeDefinition();
                Pattern pattern3 = this.makeAtomicContentModel(xSSimpleTypeDefinition);
                pattern3 = this.setDefaultFixed(xSAttributeUse.getConstraintType(), xSAttributeUse.getConstraintValue(), pattern3);
                Pattern pattern4 = this.pool.makeAttribute(this.notNull(xSAttributeDeclaration.getNamespace()), xSAttributeDeclaration.getName(), pattern3);
                if (!xSAttributeUse.getRequired()) {
                    pattern4 = this.pool.makeOptional(pattern4);
                }
                pattern2 = this.pool.makeGroup(pattern2, pattern4);
                ++n;
            }
        }
        if ((xSWildcard = xSComplexTypeDefinition.getAttributeWildcard()) != null) {
            NameClass nameClass2 = this.makeWildcardNameClass(xSWildcard);
            if (nameClass != null && nameClass2 instanceof AnyNameClass) {
                nameClass2 = this.pool.makeAnyName(nameClass);
            }
            pattern2 = this.pool.makeGroup(pattern2, this.pool.makeZeroOrMore(this.pool.makeAttribute(nameClass2, this.pool.makeText())));
        }
        pattern2 = this.pool.makeGroup(pattern2, pattern);
        return pattern2;
    }

    private Pattern setDefaultFixed(short s, String string, Pattern pattern) {
        if (string != null && "".equals(string)) {
            return pattern;
        }
        if (s == 1 || s == 2) {
            Datatype datatype = pattern instanceof DataPattern ? ((DataPattern)pattern).getDatatype() : (pattern instanceof ChoicePattern && ((ChoicePattern)pattern).p2 instanceof ValuePattern ? ((ValuePattern)((ChoicePattern)pattern).p2).getDatatype() : this.pool.makeStringDatatype());
            Pattern pattern2 = this.pool.makeValue(datatype, string);
            pattern = s == 2 ? pattern2 : this.pool.makeChoice(pattern, pattern2);
        }
        return pattern;
    }

    private NameClass makeWildcardNameClass(XSWildcard xSWildcard) {
        NameClass nameClass = null;
        switch (xSWildcard.getConstraintType()) {
            case 1: {
                break;
            }
            case 2: {
                StringList stringList = xSWildcard.getNsConstraintList();
                if (stringList.getLength() <= 0) break;
                NameClass nameClass2 = this.pool.makeNsName(this.nonNull(stringList.item(0)));
                nameClass = this.pool.makeAnyName(nameClass2);
                break;
            }
            case 3: {
                nameClass = this.makeNameClassList(xSWildcard.getNsConstraintList());
            }
        }
        if (nameClass == null) {
            nameClass = this.getAnyNameNameClass();
        }
        return nameClass;
    }

    private NameClass getAnyNameNameClass() {
        if (this.anyNameNameClass == null) {
            this.anyNameNameClass = this.pool.makeAnyName();
        }
        return this.anyNameNameClass;
    }

    private NameClass makeNameClassList(StringList stringList) {
        NameClass nameClass = null;
        int n = 0;
        int n2 = stringList.getLength();
        while (n < n2) {
            String string = stringList.item(n);
            if (string != null) {
                NameClass nameClass2 = this.pool.makeNsName(string);
                nameClass = nameClass == null ? nameClass2 : this.pool.makeChoiceNameClass(nameClass, nameClass2);
            }
            ++n;
        }
        return nameClass;
    }

    private String notNull(String string) {
        return string == null ? "" : string;
    }

    private static class WrapException
    extends RuntimeException {
        private SAXException e;

        public WrapException(SAXException sAXException) {
            this.e = sAXException;
        }

        public SAXException getException() {
            return this.e;
        }
    }

    private static interface BinaryOp {
        public Pattern apply(Pattern var1, Pattern var2);
    }

    private static class GetNameVisitor
    implements MPatternVisitor {
        private String name;
        private GetNameClassVisitor getNameClass = new GetNameClassVisitor();

        GetNameVisitor() {
        }

        public String getName(Pattern pattern) {
            this.name = null;
            pattern.accept(this);
            return this.name;
        }

        public void visitEmpty() {
        }

        public void visitNotAllowed() {
        }

        public void visitError() {
        }

        public void visitGroup(Pattern pattern, Pattern pattern2) {
        }

        public void visitInterleave(Pattern pattern, Pattern pattern2) {
        }

        public void visitChoice(Pattern pattern, Pattern pattern2) {
        }

        public void visitOneOrMore(Pattern pattern) {
        }

        public void visitMN(Pattern pattern, int n, int n2) {
        }

        public void visitMStar(Pattern pattern, int n) {
        }

        public void visitElement(NameClass nameClass, Pattern pattern) {
            this.name = this.getNameClass.getName(nameClass);
        }

        public void visitAttribute(NameClass nameClass, Pattern pattern) {
            this.name = this.getNameClass.getName(nameClass);
        }

        public void visitData(Datatype datatype) {
        }

        public void visitDataExcept(Datatype datatype, Pattern pattern) {
        }

        public void visitValue(Datatype datatype, Object object) {
        }

        public void visitText() {
        }

        public void visitList(Pattern pattern) {
        }

        private class GetNameClassVisitor
        implements NameClassVisitor {
            private String name;

            GetNameClassVisitor() {
            }

            public String getName(NameClass nameClass) {
                this.name = null;
                nameClass.accept(this);
                return this.name;
            }

            public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            }

            public void visitNsName(String string) {
            }

            public void visitNsNameExcept(String string, NameClass nameClass) {
            }

            public void visitAnyName() {
            }

            public void visitAnyNameExcept(NameClass nameClass) {
            }

            public void visitName(Name name) {
                this.name = name.getLocalName();
            }

            public void visitNull() {
            }

            public void visitError() {
            }
        }
    }
}

