/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Version;
import com.thaiopensource.validate.Flag;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.OptionArgumentException;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.IOException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class Driver {
    private static String usageKey = "usage";
    private boolean timing = false;
    private String encoding = null;
    private Localizer localizer;
    static /* synthetic */ Class class$0;

    Driver() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.thaiopensource.relaxng.util.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.localizer = new Localizer(clazz);
    }

    public static void setUsageKey(String string) {
        usageKey = string;
    }

    public static void main(String[] stringArray) {
        System.exit(new Driver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) {
        ErrorHandlerImpl errorHandlerImpl = new ErrorHandlerImpl(System.out);
        OptionParser optionParser = new OptionParser("itcdfe:p:", stringArray);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, errorHandlerImpl);
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        SchemaReader schemaReader = null;
        boolean bl = false;
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        propertyMapBuilder.put(RngProperty.CHECK_ID_IDREF, null);
                        break;
                    }
                    case 'c': {
                        bl = true;
                        break;
                    }
                    case 'd': {
                        Option option;
                        if (schemaReader == null) {
                            schemaReader = new AutoSchemaReader();
                        }
                        if ((option = schemaReader.getOption("http://www.thaiopensource.com/validate/diagnose")) == null) {
                            errorHandlerImpl.print(this.localizer.message("no_schematron", optionParser.getOptionCharString()));
                            return 2;
                        }
                        propertyMapBuilder.put(option.getPropertyId(), Flag.PRESENT);
                        break;
                    }
                    case 't': {
                        this.timing = true;
                        break;
                    }
                    case 'e': {
                        this.encoding = optionParser.getOptionArg();
                        break;
                    }
                    case 'f': {
                        RngProperty.FEASIBLE.add(propertyMapBuilder);
                        break;
                    }
                    case 'p': {
                        Option option;
                        if (schemaReader == null) {
                            schemaReader = new AutoSchemaReader();
                        }
                        if ((option = schemaReader.getOption("http://www.thaiopensource.com/validate/phase")) == null) {
                            errorHandlerImpl.print(this.localizer.message("no_schematron", optionParser.getOptionCharString()));
                            return 2;
                        }
                        try {
                            propertyMapBuilder.put(option.getPropertyId(), option.valueOf(optionParser.getOptionArg()));
                            break;
                        }
                        catch (OptionArgumentException optionArgumentException) {
                            errorHandlerImpl.print(this.localizer.message("invalid_phase", optionParser.getOptionArg()));
                            return 2;
                        }
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            errorHandlerImpl.print(this.localizer.message("invalid_option", optionParser.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            errorHandlerImpl.print(this.localizer.message("option_missing_argument", optionParser.getOptionCharString()));
            return 2;
        }
        if (bl) {
            schemaReader = CompactSchemaReader.getInstance();
        }
        if ((stringArray = optionParser.getRemainingArgs()).length < 1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.thaiopensource.relaxng.util.Driver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            errorHandlerImpl.print(this.localizer.message(usageKey, Version.getVersion(clazz)));
            return 2;
        }
        long l = System.currentTimeMillis();
        long l2 = -1L;
        boolean bl2 = false;
        try {
            ValidationDriver validationDriver = new ValidationDriver(propertyMapBuilder.toPropertyMap(), schemaReader);
            InputSource inputSource = ValidationDriver.uriOrFileInputSource(stringArray[0]);
            if (this.encoding != null) {
                inputSource.setEncoding(this.encoding);
            }
            if (validationDriver.loadSchema(inputSource)) {
                l2 = System.currentTimeMillis();
                int n = 1;
                while (n < stringArray.length) {
                    if (!validationDriver.validate(ValidationDriver.uriOrFileInputSource(stringArray[n]))) {
                        bl2 = true;
                    }
                    ++n;
                }
            } else {
                bl2 = true;
            }
        }
        catch (SAXException sAXException) {
            bl2 = true;
            errorHandlerImpl.printException(sAXException);
        }
        catch (IOException iOException) {
            bl2 = true;
            errorHandlerImpl.printException(iOException);
        }
        if (this.timing) {
            long l3 = System.currentTimeMillis();
            if (l2 < 0L) {
                l2 = l3;
            }
            errorHandlerImpl.print(this.localizer.message("elapsed_time", new Object[]{new Long(l2 - l), new Long(l3 - l2), new Long(l3 - l)}));
        }
        if (bl2) {
            return 1;
        }
        return 0;
    }
}

