/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.util;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.OptionParser;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.SAXException;

class TestDriver {
    private ValidationDriver driver;
    private ErrorHandlerImpl eh;
    private Localizer localizer;
    private int nTests;
    private static final String CORRECT_SCHEMA_NAME = "c.rng";
    private static final String INCORRECT_SCHEMA_NAME = "i.rng";
    private static final String VALID_INSTANCE_SUFFIX = ".v.xml";
    private static final String INVALID_INSTANCE_SUFFIX = ".i.xml";
    static /* synthetic */ Class class$0;

    TestDriver() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.thaiopensource.relaxng.util.TestDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.localizer = new Localizer(clazz);
        this.nTests = 0;
    }

    public static void main(String[] stringArray) throws IOException {
        System.exit(new TestDriver().doMain(stringArray));
    }

    public int doMain(String[] stringArray) throws IOException {
        long l = System.currentTimeMillis();
        this.eh = new ErrorHandlerImpl(System.out);
        OptionParser optionParser = new OptionParser("i", stringArray);
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        RngProperty.DATATYPE_LIBRARY_FACTORY.put(propertyMapBuilder, new DatatypeLibraryLoader());
        try {
            while (optionParser.moveToNextOption()) {
                switch (optionParser.getOptionChar()) {
                    case 'i': {
                        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
                    }
                }
            }
        }
        catch (OptionParser.InvalidOptionException invalidOptionException) {
            this.eh.print(this.localizer.message("invalid_option", optionParser.getOptionCharString()));
            return 2;
        }
        catch (OptionParser.MissingArgumentException missingArgumentException) {
            this.eh.print(this.localizer.message("option_missing_argument", optionParser.getOptionCharString()));
            return 2;
        }
        stringArray = optionParser.getRemainingArgs();
        this.eh = new ErrorHandlerImpl(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(stringArray[0]))));
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, this.eh);
        this.driver = new ValidationDriver(propertyMapBuilder.toPropertyMap());
        int n = 0;
        int n2 = 1;
        while (n2 < stringArray.length) {
            int n3 = this.runTestSuite(new File(stringArray[n2]));
            if (n3 > n) {
                n = n3;
            }
            ++n2;
        }
        System.err.println("Number of tests: " + this.nTests);
        System.err.println("Elapsed time: " + (System.currentTimeMillis() - l));
        this.eh.close();
        return n;
    }

    public int runTestSuite(File file) throws IOException {
        int n = 0;
        String[] stringArray = file.list();
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            File file2 = new File(file, stringArray[n2]);
            if (file2.isDirectory() && (n3 = this.runTestCase(file2)) > n) {
                n = n3;
            }
            ++n2;
        }
        return n;
    }

    private int runTestCase(File file) throws IOException {
        File file2 = new File(file, INCORRECT_SCHEMA_NAME);
        if (file2.exists()) {
            if (this.loadSchema(file2)) {
                TestDriver.failed(file2);
                return 1;
            }
            return 0;
        }
        file2 = new File(file, CORRECT_SCHEMA_NAME);
        if (!file2.exists()) {
            return 0;
        }
        if (!this.loadSchema(file2)) {
            TestDriver.failed(file2);
            return 1;
        }
        String[] stringArray = file.list();
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].endsWith(VALID_INSTANCE_SUFFIX)) {
                file2 = new File(file, stringArray[n2]);
                if (!this.validateInstance(file2)) {
                    TestDriver.failed(file2);
                    n = 1;
                }
            } else if (stringArray[n2].endsWith(INVALID_INSTANCE_SUFFIX) && this.validateInstance(file2 = new File(file, stringArray[n2]))) {
                TestDriver.failed(file2);
                n = 1;
            }
            ++n2;
        }
        return n;
    }

    private static void failed(File file) {
        System.err.println("Failed: " + file.toString());
    }

    private boolean loadSchema(File file) throws IOException {
        ++this.nTests;
        try {
            if (this.driver.loadSchema(ValidationDriver.fileInputSource(file))) {
                return true;
            }
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return false;
    }

    private boolean validateInstance(File file) throws IOException {
        ++this.nTests;
        try {
            if (this.driver.validate(ValidationDriver.fileInputSource(file))) {
                return true;
            }
        }
        catch (SAXException sAXException) {
            this.eh.printException(sAXException);
        }
        return false;
    }
}

