/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.auto;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.auto.Rewindable;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class AutoSchemaReceiver
implements SchemaReceiver {
    private final PropertyMap properties;
    private final Rewindable rewindable;

    public AutoSchemaReceiver(PropertyMap propertyMap, Rewindable rewindable) {
        this.properties = propertyMap;
        this.rewindable = rewindable;
    }

    public SchemaFuture installHandlers(XMLReader xMLReader) {
        Handler handler = new Handler(xMLReader);
        xMLReader.setContentHandler(handler);
        return handler;
    }

    private class Handler
    extends DefaultHandler
    implements SchemaFuture {
        private final XMLReader xr;
        private SchemaFuture sf = null;
        private Locator locator = null;
        private final Vector prefixMappings = new Vector();
        static /* synthetic */ Class class$0;

        Handler(XMLReader xMLReader) {
            this.xr = xMLReader;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void startPrefixMapping(String string, String string2) {
            this.prefixMappings.addElement(string);
            this.prefixMappings.addElement(string2);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            SchemaReceiverFactory schemaReceiverFactory = SchemaReceiverFactory.PROPERTY.get(AutoSchemaReceiver.this.properties);
            SchemaReceiver schemaReceiver = schemaReceiverFactory.createSchemaReceiver(string, AutoSchemaReceiver.this.properties);
            if (schemaReceiver == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.thaiopensource.validate.auto.AutoSchemaReceiver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Localizer localizer = new Localizer(clazz);
                String string4 = "".equals(string) ? localizer.message("no_namespace") : localizer.message("unknown_namespace", string);
                throw new SAXParseException(string4, this.locator);
            }
            this.sf = schemaReceiver.installHandlers(this.xr);
            AutoSchemaReceiver.this.rewindable.willNotRewind();
            ContentHandler contentHandler = this.xr.getContentHandler();
            if (contentHandler == null) {
                return;
            }
            if (this.locator != null) {
                contentHandler.setDocumentLocator(this.locator);
                contentHandler = this.xr.getContentHandler();
            }
            contentHandler.startDocument();
            contentHandler = this.xr.getContentHandler();
            int n = 0;
            int n2 = this.prefixMappings.size();
            while (n < n2) {
                contentHandler.startPrefixMapping((String)this.prefixMappings.elementAt(n), (String)this.prefixMappings.elementAt(n + 1));
                contentHandler = this.xr.getContentHandler();
                n += 2;
            }
            contentHandler.startElement(string, string2, string3, attributes);
        }

        public Schema getSchema() throws IncorrectSchemaException, SAXException, IOException {
            if (this.sf == null) {
                throw new IncorrectSchemaException();
            }
            return this.sf.getSchema();
        }

        public RuntimeException unwrapException(RuntimeException runtimeException) throws SAXException, IOException, IncorrectSchemaException {
            if (this.sf == null) {
                return runtimeException;
            }
            return this.sf.unwrapException(runtimeException);
        }
    }
}

