/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.context.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.ui.AbstractFocusViewAction;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractAutoFocusViewAction
extends AbstractFocusViewAction {
    private boolean initialized = false;
    private final AbstractContextListener CONTEXT_LISTENER = new AbstractContextListener(){

        public void contextActivated(IInteractionContext context) {
            if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable") && context.getAllElements().size() > 0) {
                AbstractAutoFocusViewAction.this.internalSuppressExpandAll = true;
                AbstractAutoFocusViewAction.super.update(true);
            } else {
                AbstractAutoFocusViewAction.this.internalSuppressExpandAll = true;
                AbstractAutoFocusViewAction.super.update(false);
            }
        }
    };

    public AbstractAutoFocusViewAction(InterestFilter interestFilter, boolean manageViewer, boolean manageFilters, boolean manageLinking) {
        super(interestFilter, manageViewer, manageFilters, manageLinking);
        this.showEmptyViewMessage = true;
        ContextCore.getContextManager().addListener(this.CONTEXT_LISTENER);
    }

    public void dispose() {
        super.dispose();
        ContextCore.getContextManager().removeListener(this.CONTEXT_LISTENER);
    }

    public void init(IViewPart view) {
        super.init(view);
        this.configureAction();
    }

    public void init(IAction action) {
        super.init(action);
        this.configureAction();
    }

    private void configureAction() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (ContextCore.getContextManager().isContextActive() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.navigators.filter.auto.enable")) {
                        AbstractAutoFocusViewAction.this.internalSuppressExpandAll = true;
                        AbstractAutoFocusViewAction.this.update(true);
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.context.ui", "Could not toggle focus action on view: " + AbstractAutoFocusViewAction.this.getPartForAction(), (Throwable)e));
                }
            }
        });
    }
}

