/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.context.core.IDegreeOfInterest;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.core.IInteractionRelation;
import org.eclipse.mylyn.internal.context.core.DegreeOfInterest;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InteractionContextElement
implements IInteractionElement {
    private String handle;
    private String kind;
    private final DegreeOfInterest interest;
    private final InteractionContext context;
    private final Map<String, InteractionContextRelation> edges = new HashMap<String, InteractionContextRelation>();

    public InteractionContextElement(String kind, String elementHandle, InteractionContext context) {
        this(kind, elementHandle, context, -1);
    }

    public InteractionContextElement(String kind, String elementHandle, InteractionContext context, int eventCountOnCreation) {
        if (elementHandle == null) {
            throw new RuntimeException("malformed context: null handle");
        }
        this.interest = new DegreeOfInterest(context, context.getScaling(), eventCountOnCreation);
        this.handle = elementHandle.intern();
        this.kind = kind != null ? kind.intern() : null;
        this.context = context;
    }

    @Override
    public String getHandleIdentifier() {
        return this.handle;
    }

    @Override
    public void setHandleIdentifier(String handle) {
        this.handle = handle;
    }

    @Override
    public String getContentType() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    public Collection<InteractionContextRelation> getRelations() {
        return this.edges.values();
    }

    @Override
    public InteractionContextRelation getRelation(String targetHandle) {
        return this.edges.get(targetHandle);
    }

    public void addEdge(InteractionContextRelation edge) {
        this.edges.put(edge.getTarget().getHandleIdentifier(), edge);
    }

    @Override
    public void clearRelations() {
        this.edges.clear();
    }

    void removeEdge(IInteractionRelation edge) {
        this.edges.remove(edge.getTarget().getHandleIdentifier());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getHandleIdentifier() == null) {
            return false;
        }
        if (obj instanceof InteractionContextElement) {
            InteractionContextElement node = (InteractionContextElement)obj;
            return this.getHandleIdentifier().equals(node.getHandleIdentifier());
        }
        return false;
    }

    public int hashCode() {
        if (this.handle != null) {
            return this.handle.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public IDegreeOfInterest getInterest() {
        return this.interest;
    }

    @Override
    public InteractionContext getContext() {
        return this.context;
    }

    public String toString() {
        return this.handle;
    }
}

