/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.parts;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.actions.ActionFactory;

public class PDESourceViewer {
    private static XMLConfiguration fSourceConfiguration = null;
    private static IColorManager fColorManager = null;
    private static int fSourceViewerCount = 0;
    private SourceViewer fViewer;
    private PDEFormPage fPage;
    private IDocument fDocument = new Document();

    public PDESourceViewer(PDEFormPage page) {
        this.fPage = page;
    }

    public IDocument getDocument() {
        return this.fDocument;
    }

    public SourceViewer getViewer() {
        return this.fViewer;
    }

    private XMLConfiguration getConfiguration() {
        if (fSourceConfiguration == null) {
            fColorManager = ColorManager.getDefault();
            fSourceConfiguration = new XMLConfiguration(fColorManager);
        }
        return fSourceConfiguration;
    }

    public void createUI(Composite parent, int heightHint, int widthHint) {
        GridData data = new GridData(768);
        data.heightHint = heightHint;
        data.widthHint = widthHint;
        this.createUI(parent, data);
    }

    public void createUI(Composite parent, GridData data) {
        int style = 578;
        this.fViewer = new SourceViewer(parent, null, style);
        this.fViewer.configure((SourceViewerConfiguration)this.getConfiguration());
        XMLDocumentSetupParticpant participant = new XMLDocumentSetupParticpant();
        participant.setup(this.fDocument);
        this.fViewer.setDocument(this.fDocument);
        this.configureUIStyledText(data, this.fViewer.getTextWidget());
        this.createUIListenersStyledText(this.fViewer.getTextWidget());
    }

    public void createUIListeners() {
        if (this.fViewer == null) {
            return;
        }
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PDESourceViewer.this.fPage.getPDEEditor().setSelection(event.getSelection());
            }
        });
        this.fViewer.getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                PDESourceViewer.this.fPage.getPDEEditor().getContributor().updateSelectableActions(null);
            }
        });
    }

    private void createUIListenersStyledText(StyledText textWidget) {
        ++fSourceViewerCount;
        textWidget.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fSourceViewerCount = fSourceViewerCount - 1;
                if (fSourceViewerCount == 0) {
                    PDESourceViewer.this.dispose();
                }
            }
        });
    }

    private void dispose() {
        if (fColorManager != null) {
            fColorManager.dispose();
            fColorManager = null;
        }
        if (fSourceConfiguration != null) {
            fSourceConfiguration.dispose();
            fSourceConfiguration = null;
        }
    }

    private void configureUIStyledText(GridData data, StyledText styledText) {
        styledText.setMenu(this.fPage.getPDEEditor().getContextMenu());
        styledText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        styledText.setLayoutData((Object)data);
    }

    public void unsetMenu() {
        if (this.fViewer == null) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        if (styledText.isDisposed()) {
            return;
        }
        styledText.setMenu(null);
    }

    public boolean doGlobalAction(String actionId) {
        if (this.fViewer == null) {
            return false;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.fViewer.doOperation(3);
            return true;
        }
        if (actionId.equals(ActionFactory.COPY.getId())) {
            this.fViewer.doOperation(4);
            return true;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.fViewer.doOperation(5);
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            this.fViewer.doOperation(7);
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.fViewer.doOperation(6);
            return true;
        }
        if (actionId.equals(ActionFactory.UNDO.getId())) {
            return false;
        }
        if (actionId.equals(ActionFactory.REDO.getId())) {
            return false;
        }
        return false;
    }

    public boolean canPaste() {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.canDoOperation(5);
    }
}

