/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.extension.BaseExtensionPointMainPage;

public class NewSchemaFileMainPage
extends BaseExtensionPointMainPage {
    private IPluginExtensionPoint fPoint;
    private boolean isPluginIdFinal;

    public NewSchemaFileMainPage(IContainer container) {
        this(container, null, false);
    }

    public NewSchemaFileMainPage(IContainer container, IPluginExtensionPoint point, boolean isPluginIdFinal) {
        super(container);
        this.setTitle(PDEUIMessages.NewSchemaFileWizard_title);
        this.setDescription(PDEUIMessages.NewSchemaFileWizard_desc);
        this.fPoint = point;
        this.isPluginIdFinal = isPluginIdFinal;
    }

    public boolean finish() {
        IRunnableWithProgress operation = this.getOperation();
        try {
            this.getContainer().run(true, true, operation);
            if (this.fPoint != null) {
                this.fPoint.setId(this.fIdText.getText());
                this.fPoint.setName(this.fNameText.getText());
                this.fPoint.setSchema(this.fSchemaText.getText());
            }
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
        return true;
    }

    protected boolean isPluginIdNeeded() {
        return true;
    }

    protected boolean isPluginIdFinal() {
        return this.isPluginIdFinal;
    }

    protected boolean isSharedSchemaSwitchNeeded() {
        return true;
    }

    public void initializeValues() {
        if (this.fContainer != null) {
            this.fPluginIdText.setText(this.fContainer.getProject().getName());
            if (!this.isPluginIdFinal()) {
                this.fSchemaLocationText.setText(String.valueOf(this.fContainer.getProject().getName()) + "/" + this.fContainer.getProjectRelativePath().toString());
            }
        }
        if (this.fPoint == null) {
            return;
        }
        if (this.fIdText != null && this.fPoint.getId() != null) {
            this.fIdText.setText(this.fPoint.getId());
        }
        if (this.fNameText != null && this.fPoint.getName() != null) {
            this.fNameText.setText(this.fPoint.getName());
        }
        if (this.fSchemaText != null && this.fPoint.getSchema() != null) {
            this.fSchemaText.setText(this.fPoint.getSchema());
        }
        this.fPluginIdText.setEnabled(!this.isPluginIdFinal);
        this.fPluginBrowseButton.setEnabled(!this.isPluginIdFinal);
    }

    protected String validateFieldContents() {
        String message = this.validatePluginID();
        if (message != null) {
            return message;
        }
        message = this.validateExtensionPointID();
        if (message != null) {
            return message;
        }
        message = this.validateExtensionPointName();
        if (message != null) {
            return message;
        }
        message = this.validateContainer();
        if (message != null) {
            return message;
        }
        message = this.validateExtensionPointSchema();
        if (message != null) {
            return message;
        }
        return null;
    }

    protected String validatePluginID() {
        String pluginID = this.getPluginId();
        if (pluginID.length() == 0) {
            return PDEUIMessages.NewSchemaFileMainPage_missingPluginID;
        }
        IPluginModelBase model = PluginRegistry.findModel((String)pluginID);
        if (model == null) {
            return PDEUIMessages.NewSchemaFileMainPage_nonExistingPluginID;
        }
        if (model.getUnderlyingResource() == null) {
            return PDEUIMessages.NewSchemaFileMainPage_externalPluginID;
        }
        return null;
    }

    protected String validateContainer() {
        if (!this.isPluginIdFinal()) {
            String newContainerName = this.fSchemaLocationText.getText().trim();
            if (newContainerName.length() == 0) {
                return PDEUIMessages.NewSchemaFileMainPage_missingContainer;
            }
            IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
            IResource resource = root.findMember((IPath)new Path(newContainerName));
            if (resource instanceof IContainer) {
                this.fContainer = (IContainer)resource;
            } else {
                this.fContainer = null;
                return PDEUIMessages.NewSchemaFileMainPage_invalidContainer;
            }
        }
        if (this.fContainer == null || !this.fContainer.exists()) {
            return PDEUIMessages.NewSchemaFileMainPage_nonExistingContainer;
        }
        return null;
    }
}

