/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;

public class ModelUpdater {
    HashSet projectsToUpdate = new HashSet();

    protected void addToParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.addChild(child);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
    }

    protected static void close(Openable element) {
        try {
            element.close();
        }
        catch (JavaScriptModelException javaScriptModelException) {}
    }

    protected void elementAdded(Openable element) {
        int elementType = element.getElementType();
        if (elementType == 2) {
            this.addToParentInfo(element);
            this.projectsToUpdate.add(element);
        } else {
            this.addToParentInfo(element);
            ModelUpdater.close(element);
        }
        switch (elementType) {
            case 3: {
                this.projectsToUpdate.add(element.getJavaScriptProject());
                break;
            }
            case 4: {
                JavaProject project = (JavaProject)element.getJavaScriptProject();
                project.resetCaches();
            }
        }
    }

    protected void elementChanged(Openable element) {
        ModelUpdater.close(element);
    }

    protected void elementRemoved(Openable element) {
        if (element.isOpen()) {
            ModelUpdater.close(element);
        }
        this.removeFromParentInfo(element);
        int elementType = element.getElementType();
        switch (elementType) {
            case 1: {
                JavaModelManager.getJavaModelManager().getIndexManager().reset();
                break;
            }
            case 2: {
                JavaModelManager manager = JavaModelManager.getJavaModelManager();
                JavaProject javaProject = (JavaProject)element;
                manager.removePerProjectInfo(javaProject);
                manager.containerRemove(javaProject);
                break;
            }
            case 3: {
                this.projectsToUpdate.add(element.getJavaScriptProject());
                break;
            }
            case 4: {
                JavaProject project = (JavaProject)element.getJavaScriptProject();
                project.resetCaches();
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processJavaDelta(IJavaScriptElementDelta delta) {
        try {
            this.traverseDelta(delta, null, null);
            Iterator iterator = this.projectsToUpdate.iterator();
            while (iterator.hasNext()) {
                JavaProject project = (JavaProject)iterator.next();
                project.updatePackageFragmentRoots();
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.projectsToUpdate = new HashSet();
            throw throwable;
        }
        {
            Object var4_6 = null;
            this.projectsToUpdate = new HashSet();
            return;
        }
    }

    protected void removeFromParentInfo(Openable child) {
        Openable parent = (Openable)child.getParent();
        if (parent != null && parent.isOpen()) {
            try {
                JavaElementInfo info = (JavaElementInfo)parent.getElementInfo();
                info.removeChild(child);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
    }

    protected void traverseDelta(IJavaScriptElementDelta delta, IPackageFragmentRoot root, IJavaScriptProject project) {
        boolean processChildren = true;
        Openable element = (Openable)delta.getElement();
        switch (element.getElementType()) {
            case 2: {
                project = (IJavaScriptProject)((Object)element);
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)((Object)element);
                break;
            }
            case 5: {
                CompilationUnit cu = (CompilationUnit)element;
                if (cu.isWorkingCopy() && !cu.isPrimary()) {
                    return;
                }
            }
            case 6: {
                processChildren = false;
            }
        }
        switch (delta.getKind()) {
            case 1: {
                this.elementAdded(element);
                break;
            }
            case 2: {
                this.elementRemoved(element);
                break;
            }
            case 4: {
                if ((delta.getFlags() & 1) == 0) break;
                this.elementChanged(element);
            }
        }
        if (processChildren) {
            IJavaScriptElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                IJavaScriptElementDelta childDelta = children[i];
                this.traverseDelta(childDelta, root, project);
                ++i;
            }
        }
    }
}

