/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmReadOnlyPersistentAttribute;
import org.eclipse.jpt.jpa.ui.internal.dialogs.AddPersistentAttributeToXmlAndMapDialog;
import org.eclipse.jpt.jpa.ui.internal.selection.DefaultJpaSelection;
import org.eclipse.jpt.jpa.ui.internal.selection.JpaSelectionManager;
import org.eclipse.jpt.jpa.ui.internal.selection.SelectionManagerFactory;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddPersistentAttributeToXmlAndMapHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        final IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
        final ArrayList<OrmReadOnlyPersistentAttribute> newAttributes = new ArrayList<OrmReadOnlyPersistentAttribute>();
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)executionEvent);
        for (OrmReadOnlyPersistentAttribute attribute : CollectionTools.iterable((Iterator)selection.iterator())) {
            OrmPersistentType type = attribute.getOwningPersistentType();
            String attributeName = attribute.getName();
            AddPersistentAttributeToXmlAndMapDialog dialog = new AddPersistentAttributeToXmlAndMapDialog(window.getShell(), attribute);
            dialog.create();
            dialog.setBlockOnOpen(true);
            dialog.open();
            OrmReadOnlyPersistentAttribute newAttribute = type.getAttributeNamed(attributeName);
            if (newAttribute == null) continue;
            newAttributes.add(newAttribute);
        }
        if (newAttributes.size() == 1) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JpaSelectionManager selectionManager = SelectionManagerFactory.getSelectionManager(window);
                    selectionManager.select(new DefaultJpaSelection((JpaStructureNode)newAttributes.get(0)), null);
                }
            });
        }
        return null;
    }
}

