/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.listeners;

import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.ConnectionListener;
import org.eclipse.jpt.jpa.db.ConnectionProfile;
import org.eclipse.jpt.jpa.db.Database;
import org.eclipse.jpt.jpa.db.ForeignKey;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Sequence;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.swt.widgets.Display;

public class SWTConnectionListenerWrapper
implements ConnectionListener {
    private final ConnectionListener listener;

    public SWTConnectionListenerWrapper(ConnectionListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void opened(ConnectionProfile profile) {
        if (this.isExecutingOnUIThread()) {
            this.opened_(profile);
        } else {
            this.executeOnUIThread(this.buildOpenedRunnable(profile));
        }
    }

    public void modified(ConnectionProfile profile) {
        if (this.isExecutingOnUIThread()) {
            this.modified_(profile);
        } else {
            this.executeOnUIThread(this.buildModifiedRunnable(profile));
        }
    }

    public boolean okToClose(ConnectionProfile profile) {
        if (this.isExecutingOnUIThread()) {
            return this.okToClose_(profile);
        }
        this.executeOnUIThread(this.buildOkToCloseRunnable(profile));
        return true;
    }

    public void aboutToClose(ConnectionProfile profile) {
        if (this.isExecutingOnUIThread()) {
            this.aboutToClose_(profile);
        } else {
            this.executeOnUIThread(this.buildAboutToCloseRunnable(profile));
        }
    }

    public void closed(ConnectionProfile profile) {
        if (this.isExecutingOnUIThread()) {
            this.closed_(profile);
        } else {
            this.executeOnUIThread(this.buildClosedRunnable(profile));
        }
    }

    public void databaseChanged(ConnectionProfile profile, Database database) {
        if (this.isExecutingOnUIThread()) {
            this.databaseChanged_(profile, database);
        } else {
            this.executeOnUIThread(this.buildDatabaseChangedRunnable(profile, database));
        }
    }

    public void catalogChanged(ConnectionProfile profile, Catalog catalog) {
        if (this.isExecutingOnUIThread()) {
            this.catalogChanged_(profile, catalog);
        } else {
            this.executeOnUIThread(this.buildCatalogChangedRunnable(profile, catalog));
        }
    }

    public void schemaChanged(ConnectionProfile profile, Schema schema) {
        if (this.isExecutingOnUIThread()) {
            this.schemaChanged_(profile, schema);
        } else {
            this.executeOnUIThread(this.buildSchemaChangedRunnable(profile, schema));
        }
    }

    public void sequenceChanged(ConnectionProfile profile, Sequence sequence) {
        if (this.isExecutingOnUIThread()) {
            this.sequenceChanged_(profile, sequence);
        } else {
            this.executeOnUIThread(this.buildSequenceChangedRunnable(profile, sequence));
        }
    }

    public void tableChanged(ConnectionProfile profile, Table table) {
        if (this.isExecutingOnUIThread()) {
            this.tableChanged_(profile, table);
        } else {
            this.executeOnUIThread(this.buildTableChangedRunnable(profile, table));
        }
    }

    public void columnChanged(ConnectionProfile profile, Column column) {
        if (this.isExecutingOnUIThread()) {
            this.columnChanged_(profile, column);
        } else {
            this.executeOnUIThread(this.buildColumnChangedRunnable(profile, column));
        }
    }

    public void foreignKeyChanged(ConnectionProfile profile, ForeignKey foreignKey) {
        if (this.isExecutingOnUIThread()) {
            this.foreignKeyChanged_(profile, foreignKey);
        } else {
            this.executeOnUIThread(this.buildForeignKeyChangedRunnable(profile, foreignKey));
        }
    }

    private Runnable buildOpenedRunnable(final ConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.opened_(profile);
            }

            public String toString() {
                return "opened runnable";
            }
        };
    }

    private Runnable buildModifiedRunnable(final ConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.modified_(profile);
            }

            public String toString() {
                return "modified runnable";
            }
        };
    }

    private Runnable buildOkToCloseRunnable(final ConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.okToClose_(profile);
            }

            public String toString() {
                return "OK to close runnable";
            }
        };
    }

    private Runnable buildAboutToCloseRunnable(final ConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.aboutToClose_(profile);
            }

            public String toString() {
                return "about to close runnable";
            }
        };
    }

    private Runnable buildClosedRunnable(final ConnectionProfile profile) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.closed_(profile);
            }

            public String toString() {
                return "closed runnable";
            }
        };
    }

    private Runnable buildDatabaseChangedRunnable(final ConnectionProfile profile, final Database database) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.databaseChanged_(profile, database);
            }

            public String toString() {
                return "database changed runnable";
            }
        };
    }

    private Runnable buildCatalogChangedRunnable(final ConnectionProfile profile, final Catalog catalog) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.catalogChanged_(profile, catalog);
            }

            public String toString() {
                return "catalog changed runnable";
            }
        };
    }

    private Runnable buildSchemaChangedRunnable(final ConnectionProfile profile, final Schema schema) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.schemaChanged_(profile, schema);
            }

            public String toString() {
                return "schema changed runnable";
            }
        };
    }

    private Runnable buildSequenceChangedRunnable(final ConnectionProfile profile, final Sequence sequence) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.sequenceChanged_(profile, sequence);
            }

            public String toString() {
                return "sequence changed runnable";
            }
        };
    }

    private Runnable buildTableChangedRunnable(final ConnectionProfile profile, final Table table) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.tableChanged_(profile, table);
            }

            public String toString() {
                return "table changed runnable";
            }
        };
    }

    private Runnable buildColumnChangedRunnable(final ConnectionProfile profile, final Column column) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.columnChanged_(profile, column);
            }

            public String toString() {
                return "column changed runnable";
            }
        };
    }

    private Runnable buildForeignKeyChangedRunnable(final ConnectionProfile profile, final ForeignKey foreignKey) {
        return new Runnable(){

            public void run() {
                SWTConnectionListenerWrapper.this.foreignKeyChanged_(profile, foreignKey);
            }

            public String toString() {
                return "foreign key changed runnable";
            }
        };
    }

    private boolean isExecutingOnUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void opened_(ConnectionProfile profile) {
        this.listener.opened(profile);
    }

    void modified_(ConnectionProfile profile) {
        this.listener.modified(profile);
    }

    boolean okToClose_(ConnectionProfile profile) {
        return this.listener.okToClose(profile);
    }

    void aboutToClose_(ConnectionProfile profile) {
        this.listener.aboutToClose(profile);
    }

    void closed_(ConnectionProfile profile) {
        this.listener.closed(profile);
    }

    void databaseChanged_(ConnectionProfile profile, Database database) {
        this.listener.databaseChanged(profile, database);
    }

    void catalogChanged_(ConnectionProfile profile, Catalog catalog) {
        this.listener.catalogChanged(profile, catalog);
    }

    void schemaChanged_(ConnectionProfile profile, Schema schema) {
        this.listener.schemaChanged(profile, schema);
    }

    void sequenceChanged_(ConnectionProfile profile, Sequence sequence) {
        this.listener.sequenceChanged(profile, sequence);
    }

    void tableChanged_(ConnectionProfile profile, Table table) {
        this.listener.tableChanged(profile, table);
    }

    void columnChanged_(ConnectionProfile profile, Column column) {
        this.listener.columnChanged(profile, column);
    }

    void foreignKeyChanged_(ConnectionProfile profile, ForeignKey foreignKey) {
        this.listener.foreignKeyChanged(profile, foreignKey);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ')';
    }
}

