/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.builder;

import aurora.ide.helpers.StatusUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.gen.BaseBmGenerator;
import aurora.ide.meta.project.AuroraMetaProject;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class AutoGenBuilder
extends IncrementalProjectBuilder {
    public static final String MARKER_BUILD_ERROR = "aurora.ide.meta.builderror";
    private ArrayList<IResource> filesToBuild = new ArrayList();
    private IFolder mpFolder;
    public static final String BUILDER_ID = "aurora.ide.meta.autoGenBuilder";

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        AuroraMetaProject amp = new AuroraMetaProject(this.getProject());
        try {
            this.mpFolder = amp.getModelFolder();
        }
        catch (ResourceNotFoundException e) {
            e.printStackTrace();
        }
        if (this.mpFolder == null) {
            return null;
        }
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    void buildMeta(IResource resource) {
        if (this.canBuild(resource)) {
            try {
                AutoGenBuilder.deleteMarkers(resource);
                IFile file = (IFile)resource;
                new BaseBmGenerator(file).process();
            }
            catch (Exception e) {
                AutoGenBuilder.createMarker(resource, MARKER_BUILD_ERROR, e);
            }
        }
    }

    public static IMarker createMarker(IResource res, String marker_id, Exception e) {
        IMarker m = null;
        try {
            m = res.createMarker(marker_id);
            m.setAttribute("severity", 2);
            m.setAttribute("message", (Object)e.getMessage());
            m.setAttribute("lineNumber", 0);
        }
        catch (CoreException e1) {
            StatusUtil.showExceptionDialog(null, null, (String)("Error occured while create markers on " + res.getName()), (boolean)false, (Throwable)e1);
        }
        return m;
    }

    public static void deleteMarkers(IResource res) {
        try {
            res.deleteMarkers(MARKER_BUILD_ERROR, false, 0);
        }
        catch (CoreException e) {
            StatusUtil.showExceptionDialog(null, null, (String)("Error occured while delete markers on " + res.getName()), (boolean)false, (Throwable)e);
        }
    }

    private boolean canBuild(IResource res) {
        if (!(res instanceof IFile)) {
            return false;
        }
        if (!this.mpFolder.getFullPath().isPrefixOf(res.getFullPath())) {
            return false;
        }
        return res.getName().toLowerCase().endsWith(".bmq");
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            this.filesToBuild.clear();
            this.getProject().accept((IResourceVisitor)new SampleResourceVisitor());
            this.buildFiles(monitor);
        }
        catch (CoreException e) {
            StatusUtil.showExceptionDialog(null, null, (String)"Error occurred during AutoGenBuild.", (boolean)false, (Throwable)e);
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        this.filesToBuild.clear();
        delta.accept((IResourceDeltaVisitor)new SampleDeltaVisitor());
        this.buildFiles(monitor);
    }

    private void buildFiles(final IProgressMonitor monitor) {
        monitor.beginTask("build " + this.getProject().getName(), this.filesToBuild.size());
        Object[] objectArray = new Object[3];
        objectArray[0] = 0;
        objectArray[1] = 0;
        final Object[] status = objectArray;
        Job job = new Job("update status"){

            protected IStatus run(IProgressMonitor innerMonitor) {
                while (!monitor.isCanceled()) {
                    IResource res = (IResource)status[2];
                    if (res != null) {
                        this.updateStatus(res);
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }

            private void updateStatus(final IResource res) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        status[1] = (Integer)status[1] + (Integer)status[0];
                        monitor.subTask("build " + status[1] + " of " + AutoGenBuilder.this.filesToBuild.size() + " " + res.getFullPath().toString());
                        monitor.worked(((Integer)status[0]).intValue());
                        status[0] = 0;
                    }
                });
            }
        };
        job.setSystem(true);
        job.schedule(1L);
        for (IResource res : this.filesToBuild) {
            if (monitor.isCanceled()) break;
            status[0] = (Integer)status[0] + 1;
            status[2] = res;
            this.buildMeta(res);
        }
        job.cancel();
        monitor.done();
    }

    class SampleDeltaVisitor
    implements IResourceDeltaVisitor {
        SampleDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            switch (delta.getKind()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    AutoGenBuilder.this.filesToBuild.add(resource);
                }
            }
            return true;
        }
    }

    class SampleResourceVisitor
    implements IResourceVisitor {
        SampleResourceVisitor() {
        }

        public boolean visit(IResource resource) {
            AutoGenBuilder.this.filesToBuild.add(resource);
            return true;
        }
    }
}

