/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors;

import aurora.ide.editor.InputFileListener;
import aurora.ide.meta.gef.editors.BMViewer;
import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.FlayoutBMGEFEditor;
import aurora.ide.meta.gef.editors.VScreenEditorPaletteFactory;
import aurora.ide.meta.gef.editors.actions.ViewContextMenuProvider;
import aurora.ide.meta.gef.editors.dnd.BMTransferDropTargetListener;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.models.io.ModelIOManager;
import aurora.ide.meta.gef.editors.parts.AuroraPartFactory;
import aurora.ide.meta.gef.editors.property.MetaPropertyViewer;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.editparts.ScalableRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.xml.sax.SAXException;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class VScreenEditor
extends FlayoutBMGEFEditor {
    public static final String CONTEXT_MENU_KEY = "aurora.ide.meta.gef.editor.contextmenu";
    ViewDiagram diagram;
    private PaletteRoot root;
    private KeyHandler sharedKeyHandler;
    private MetaPropertyViewer propertyViewer;
    private BMViewer bmViewer;
    private EditorMode editorMode = new EditorMode(this);
    private IFile file;

    public VScreenEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new InputFileListener((EditorPart)this));
    }

    public void setDiagram(ViewDiagram diagram) {
        this.diagram = diagram;
        GraphicalViewer gv = this.getGraphicalViewer();
        gv.setContents((Object)diagram);
        this.bmViewer.refreshInput();
        this.markDirty();
    }

    public void markDirty() {
        Command cmd = new Command(){};
        this.getEditDomain().getCommandStack().execute(cmd);
        this.firePropertyChange(257);
    }

    public Object getAdapter(Class adapter) {
        if (IFile.class.equals((Object)adapter)) {
            return this.file;
        }
        return super.getAdapter(adapter);
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        DirectEditAction action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void createOutputStream(OutputStream os) throws IOException {
        ModelIOManager mim = ModelIOManager.getNewInstance();
        CompositeMap rootMap = mim.toCompositeMap(this.diagram);
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" + rootMap.toXML();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        bw.write(xml);
        bw.close();
    }

    public void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        this.getGraphicalViewer().setRootEditPart((RootEditPart)new ScalableRootEditPart());
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new AuroraPartFactory(this.editorMode));
        this.getGraphicalViewer().setKeyHandler(new GraphicalViewerKeyHandler(this.getGraphicalViewer()).setParent(this.getCommonKeyHandler()));
        ViewContextMenuProvider provider = new ViewContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(CONTEXT_MENU_KEY, (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)this.propertyViewer);
    }

    public void initializeGraphicalViewer() {
        this.getGraphicalViewer().setContents((Object)this.diagram);
        this.getGraphicalViewer().addDropTargetListener((TransferDropTargetListener)new BMTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()));
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.createOutputStream(out);
            IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
            file.setContents((InputStream)new ByteArrayInputStream(out.toByteArray()), true, false, monitor);
            out.close();
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getWorkbenchWindow().getShell());
        dialog.setOriginalFile(((IFileEditorInput)this.getEditorInput()).getFile());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IFile file = workspace.getRoot().getFile(path);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    VScreenEditor.this.createOutputStream(out);
                    file.create((InputStream)new ByteArrayInputStream(out.toByteArray()), true, monitor);
                    out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getSite().getWorkbenchWindow().getShell()).run(false, true, (IRunnableWithProgress)op);
            this.setInput((IEditorInput)new FileEditorInput(file));
            this.getCommandStack().markSaveLocation();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler();
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.root == null) {
            this.root = VScreenEditorPaletteFactory.createPalette(this.editorMode);
        }
        return this.root;
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    /*
     * Loose catch block
     */
    public void setInput(IEditorInput input) {
        super.setInput(input);
        if (!(input instanceof IFileEditorInput)) {
            this.diagram = new ViewDiagram();
            return;
        }
        this.file = ((IFileEditorInput)input).getFile();
        this.setPartName(this.file.getName());
        InputStream is = null;
        try {
            try {
                is = this.file.getContents(false);
                CompositeLoader parser = new CompositeLoader();
                CompositeMap rootMap = parser.loadFromStream(is);
                ModelIOManager mim = ModelIOManager.getNewInstance();
                this.diagram = mim.fromCompositeMap(rootMap);
            }
            catch (CoreException e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
                if (this.diagram == null) {
                    this.diagram = new ViewDiagram();
                }
                DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
                this.setEditDomain(defaultEditDomain);
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                if (this.diagram == null) {
                    this.diagram = new ViewDiagram();
                }
                DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
                this.setEditDomain(defaultEditDomain);
            }
            catch (SAXException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                if (this.diagram == null) {
                    this.diagram = new ViewDiagram();
                }
                DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
                this.setEditDomain(defaultEditDomain);
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (this.diagram == null) {
                this.diagram = new ViewDiagram();
            }
            DefaultEditDomain defaultEditDomain = new DefaultEditDomain((IEditorPart)this);
            this.setEditDomain(defaultEditDomain);
        }
    }

    protected void createPropertyViewer(Composite c) {
        this.propertyViewer = new MetaPropertyViewer(c, (IWorkbenchPart)this);
        DefaultEditDomain editDomain = this.getEditDomain();
        if (editDomain == null) {
            return;
        }
        this.propertyViewer.setCommandStack(editDomain.getCommandStack());
    }

    protected void createBMViewer(Composite c) {
        this.bmViewer = new BMViewer(c, this);
    }

    public ViewDiagram getDiagram() {
        return this.diagram;
    }
}

