/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors;

import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.CheckBox;
import aurora.ide.meta.gef.editors.models.FieldSet;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.HBox;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.Label;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.VBox;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VScreenEditorPaletteFactory {
    private static List<PaletteContainer> createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(VScreenEditorPaletteFactory.createControlGroup(root));
        categories.add(VScreenEditorPaletteFactory.createInputDrawer());
        categories.add(VScreenEditorPaletteFactory.createButtonDrawer());
        categories.add(VScreenEditorPaletteFactory.createLayoutDrawer());
        categories.add(VScreenEditorPaletteFactory.createGridDrawer());
        return categories;
    }

    private static List<PaletteContainer> createCategories(PaletteRoot root, EditorMode editorMode) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(VScreenEditorPaletteFactory.createControlGroup(root));
        if (!"Template".equals(editorMode.getMode())) {
            categories.add(VScreenEditorPaletteFactory.createInputDrawer());
        }
        categories.add(VScreenEditorPaletteFactory.createButtonDrawer());
        categories.add(VScreenEditorPaletteFactory.createLayoutDrawer());
        if (!"Template".equals(editorMode.getMode())) {
            categories.add(VScreenEditorPaletteFactory.createGridDrawer());
            categories.add(VScreenEditorPaletteFactory.createTabDrawer());
        }
        return categories;
    }

    private static PaletteContainer createTabDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("Tab", null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Tab Folder", "Create a  TabFolder", TabFolder.class, (CreationFactory)new SimpleFactory(TabFolder.class), ImagesUtils.getImageDescriptor("palette/tabfolder.png"), ImagesUtils.getImageDescriptor("palette/tabfolder.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Tab Item", "Create a  TabItem", TabItem.class, (CreationFactory)new SimpleFactory(TabItem.class), ImagesUtils.getImageDescriptor("palette/tabitem.png"), ImagesUtils.getImageDescriptor("palette/tabitem.png"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createGridDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("Grid", null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Grid", "Create a  Grid", Grid.class, (CreationFactory)new SimpleFactory(Grid.class), ImagesUtils.getImageDescriptor("palette/grid.png"), ImagesUtils.getImageDescriptor("palette/grid.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Grid Column", "Create a  Grid Column", GridColumn.class, (CreationFactory)new SimpleFactory(GridColumn.class), ImagesUtils.getImageDescriptor("palette/column.png"), ImagesUtils.getImageDescriptor("palette/column.png"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createInputDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("Input", null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Label", "Create a new Label", Label.class, (CreationFactory)new SimpleFactory(Label.class){

            public Object getNewObject() {
                Label newObject = (Label)super.getNewObject();
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/label.png"), ImagesUtils.getImageDescriptor("palette/label.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("TextField", "Create a new TextField", Input.class, (CreationFactory)new SimpleFactory(Input.class){

            public Object getNewObject() {
                Input newObject = (Input)super.getNewObject();
                newObject.setType("textField");
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/input_edit.png"), ImagesUtils.getImageDescriptor("palette/input_edit.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("NumberField", "Create a new NumberField", Input.class, (CreationFactory)new SimpleFactory(Input.class){

            public Object getNewObject() {
                Input newObject = (Input)super.getNewObject();
                newObject.setType("numberField");
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/input_edit.png"), ImagesUtils.getImageDescriptor("palette/input_edit.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Combox", "Create a new Combox", Input.class, (CreationFactory)new SimpleFactory(Input.class){

            public Object getNewObject() {
                Input newObject = (Input)super.getNewObject();
                newObject.setType("comboBox");
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/itembar_01.png"), ImagesUtils.getImageDescriptor("palette/itembar_01.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("DatePicker", "Create a new DatePicker", Input.class, (CreationFactory)new SimpleFactory(Input.class){

            public Object getNewObject() {
                Input newObject = (Input)super.getNewObject();
                newObject.setType("datePicker");
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/itembar_02.png"), ImagesUtils.getImageDescriptor("palette/itembar_02.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("DateTimePicker", "Create a new DateTimePicker", Input.class, (CreationFactory)new SimpleFactory(Input.class){

            public Object getNewObject() {
                Input newObject = (Input)super.getNewObject();
                newObject.setType("dateTimePicker");
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/itembar_02.png"), ImagesUtils.getImageDescriptor("palette/itembar_02.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("LOV", "Create a new Lov", Input.class, (CreationFactory)new SimpleFactory(Input.class){

            public Object getNewObject() {
                Input newObject = (Input)super.getNewObject();
                newObject.setType("lov");
                return newObject;
            }
        }, ImagesUtils.getImageDescriptor("palette/itembar_03.png"), ImagesUtils.getImageDescriptor("palette/itembar_03.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("CheckBox", "Create a CheckBox", CheckBox.class, (CreationFactory)new SimpleFactory(CheckBox.class), ImagesUtils.getImageDescriptor("palette/checkbox_01.png"), ImagesUtils.getImageDescriptor("palette/checkbox_01.png"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createLayoutDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("Layout", null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Form", "Create a  Form", Form.class, (CreationFactory)new SimpleFactory(Form.class), ImagesUtils.getImageDescriptor("palette/form.png"), ImagesUtils.getImageDescriptor("palette/form.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("FieldSet", "Create a  FieldSet", FieldSet.class, (CreationFactory)new SimpleFactory(FieldSet.class), ImagesUtils.getImageDescriptor("palette/fieldset.png"), ImagesUtils.getImageDescriptor("palette/fieldset.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("HBox", "Create a  HBox", Grid.class, (CreationFactory)new SimpleFactory(HBox.class), ImagesUtils.getImageDescriptor("palette/hbox.png"), ImagesUtils.getImageDescriptor("palette/hbox.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("VBox", "Create a  VBox", Grid.class, (CreationFactory)new SimpleFactory(VBox.class), ImagesUtils.getImageDescriptor("palette/vbox.png"), ImagesUtils.getImageDescriptor("palette/vbox.png"));
        entries.add(combined);
        combined = new CombinedTemplateCreationEntry("Toolbar", "Create a  Toolbar ", Toolbar.class, (CreationFactory)new SimpleFactory(Toolbar.class), ImagesUtils.getImageDescriptor("palette/toolbar.png"), ImagesUtils.getImageDescriptor("palette/toolbar.png"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createButtonDrawer() {
        PaletteDrawer drawer = new PaletteDrawer("Button", null);
        ArrayList<CombinedTemplateCreationEntry> entries = new ArrayList<CombinedTemplateCreationEntry>();
        CombinedTemplateCreationEntry combined = new CombinedTemplateCreationEntry("Button", "Create a Button", Button.class, (CreationFactory)new SimpleFactory(Button.class), ImagesUtils.getImageDescriptor("palette/toolbar_btn_01.png"), ImagesUtils.getImageDescriptor("palette/toolbar_btn_01.png"));
        entries.add(combined);
        drawer.addAll(entries);
        return drawer;
    }

    private static PaletteContainer createControlGroup(PaletteRoot root) {
        PaletteGroup controlGroup = new PaletteGroup("Control Group");
        ArrayList<Object> entries = new ArrayList<Object>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        PaletteSeparator sep = new PaletteSeparator("aurora.ide.meta.gef.editors");
        sep.setUserModificationPermission(1);
        entries.add(sep);
        controlGroup.addAll(entries);
        return controlGroup;
    }

    public static PaletteRoot createPalette() {
        PaletteRoot flowPalette = new PaletteRoot();
        flowPalette.addAll(VScreenEditorPaletteFactory.createCategories(flowPalette));
        return flowPalette;
    }

    public static PaletteRoot createPalette(EditorMode editorMode) {
        PaletteRoot flowPalette = new PaletteRoot();
        flowPalette.addAll(VScreenEditorPaletteFactory.createCategories(flowPalette, editorMode));
        return flowPalette;
    }
}

