/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.actions;

import aurora.ide.meta.gef.editors.actions.TypeChangeUtil;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.actions.ActionFactory;

public class ViewContextMenuProvider
extends ContextMenuProvider {
    private ActionRegistry actionRegistry;
    private ISelection selection;
    private CommandStack commandStack;

    public ViewContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewContextMenuProvider.this.selection = event.getSelection();
            }
        });
        this.commandStack = viewer.getEditDomain().getCommandStack();
        this.setActionRegistry(registry);
    }

    public void buildContextMenu(IMenuManager menu) {
        IStructuredSelection ss;
        Object ele;
        GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
        IAction action = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
        menu.appendToGroup("org.eclipse.gef.group.undo", action);
        action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
        if (action.isEnabled()) {
            menu.appendToGroup("org.eclipse.gef.group.edit", action);
        }
        if (this.selection instanceof IStructuredSelection && (ele = (ss = (IStructuredSelection)this.selection).getFirstElement()) instanceof ComponentPart) {
            if (ele instanceof ViewDiagramPart) {
                return;
            }
            MenuManager typeManager = new MenuManager("TypeChange");
            menu.appendToGroup("org.eclipse.gef.group.edit", (IContributionItem)typeManager);
            AuroraComponent model = (AuroraComponent)((ComponentPart)ele).getModel();
            TypeChangeUtil tc = new TypeChangeUtil(this.commandStack);
            Action[] actionArray = tc.getActionFor(model);
            int n = actionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action a = actionArray[n2];
                typeManager.add((IAction)a);
                ++n2;
            }
        }
    }

    private ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public void setActionRegistry(ActionRegistry registry) {
        this.actionRegistry = registry;
    }
}

