/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.figures.ToolbarFigure;
import aurora.ide.meta.gef.editors.models.Button;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ButtonFigure
extends Figure {
    private static Image bgImg = ImagesUtils.getImage("btn.gif");
    private static String[] buttonTypes = new String[]{"add", "save", "delete", "clear", "excel"};
    private static Image stdimg = ImagesUtils.getImage("aurora/toolbar_btn.gif");
    private static Image defaultimg = ImagesUtils.getImage("aurora/default.gif");
    private Button model = null;

    public void handleFocusGained(FocusEvent event) {
        super.handleFocusGained(event);
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.pushState();
        Rectangle rect = this.getBounds();
        Dimension dim = this.model.getSize();
        IFigure parentFigure = this.getParent();
        if (!(parentFigure instanceof ToolbarFigure)) {
            g.drawImage(bgImg, 0, 0, 3, 2, rect.x, rect.y, 3, 2);
            g.drawImage(bgImg, 0, 6, 1, 2, rect.x + 3, rect.y, dim.width - 6, 2);
            g.drawImage(bgImg, 3, 0, 3, 2, rect.x + dim.width - 3, rect.y, 3, 2);
            g.drawImage(bgImg, 0, 24, 3, 1, rect.x, rect.y + 2, 3, dim.height - 4);
            g.drawImage(bgImg, 3, 24, 3, 1, rect.x + dim.width - 3, rect.y + 2, 3, dim.height - 4);
            g.drawImage(bgImg, 0, 1096, 1, dim.height - 4, rect.x + 3, rect.y + 2, dim.width - 6, dim.height - 4);
            g.drawImage(bgImg, 0, 4, 3, 2, rect.x, rect.y + dim.height - 2, 3, 2);
            g.drawImage(bgImg, 0, 16, 1, 2, rect.x + 3, rect.y + dim.height - 2, dim.width - 3, 2);
            g.drawImage(bgImg, 3, 4, 3, 2, rect.x + dim.width - 3, rect.y + dim.height - 2, 3, 2);
        }
        String text = this.model.getText();
        Dimension textExtents = FigureUtilities.getTextExtents((String)text, (Font)this.getFont());
        Rectangle r1 = this.getStdImgRect();
        g.setForegroundColor(ColorConstants.BLACK);
        if (r1 == null) {
            g.drawString(text, rect.x + (dim.width - textExtents.width) / 2, rect.y + (dim.height - textExtents.height) / 2);
        } else {
            Rectangle r2 = new Rectangle(rect.x + (dim.width - textExtents.width - 16) / 2, rect.y + (dim.height - r1.height) / 2, 16, 17);
            g.drawImage(this.getBgImage(), r1, r2);
            g.drawString(text, rect.x + (dim.width - textExtents.width) / 2 + 8, rect.y + (dim.height - textExtents.height) / 2);
        }
        g.popState();
    }

    private Rectangle getStdImgRect() {
        String btype = this.model.getButtonType();
        int i = 0;
        while (i < buttonTypes.length) {
            if (buttonTypes[i].equals(btype)) {
                return new Rectangle(0, 17 * i, 16, 17);
            }
            ++i;
        }
        if (this.model.getIcon() == null || this.model.getIcon().length() == 0) {
            return null;
        }
        return new Rectangle(defaultimg.getBounds());
    }

    private Image getBgImage() {
        return this.model.isStdButton() ? stdimg : defaultimg;
    }

    public void setModel(Button model) {
        this.model = model;
    }
}

