/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import aurora.ide.meta.gef.editors.models.TabItem;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class TabItemFigure
extends Figure {
    private static Image bgImg = ImagesUtils.getImage("toolbar_bg");
    private TabItem model;

    public void setModel(TabItem model) {
        this.model = model;
    }

    public TabItem getModel() {
        return this.model;
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        if (!this.model.isCurrent()) {
            g.drawImage(bgImg, new Rectangle(bgImg.getBounds()), this.getBounds());
        }
        String prompt = this.model.getPrompt();
        Rectangle bounds = this.getBounds().getCopy();
        Point center = bounds.getCenter();
        Dimension textExtents = FigureUtilities.getTextExtents((String)prompt, (Font)this.getFont());
        g.setForegroundColor(ColorConstants.BLACK);
        g.drawText(prompt, center.translate(-textExtents.width / 2, -textExtents.height / 2));
        g.setForegroundColor(ColorConstants.FIELDSET_BORDER);
        g.drawRoundRectangle(this.getBounds().getResized(-1, 1), 6, 6);
    }
}

