/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.figures;

import aurora.ide.meta.gef.editors.ImagesUtils;
import aurora.ide.meta.gef.editors.figures.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TitleBarBorder;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class TitleBorder
extends TitleBarBorder {
    private String imageKey = "toolbar_bg";

    public TitleBorder(String string) {
        super(string);
    }

    public TitleBorder(String title, String imageKey) {
        super(title);
        this.imageKey = imageKey;
    }

    public void paint(IFigure figure, Graphics g, Insets insets) {
        tempRect.setBounds(TitleBorder.getPaintRectangle((IFigure)figure, (Insets)insets));
        FigureUtilities.paintEtchedBorder((Graphics)g, (Rectangle)tempRect);
        Rectangle rec = tempRect;
        rec.height = 25;
        g.clipRect(rec);
        g.fillRectangle(rec);
        Image i = this.getBGImage();
        Rectangle src = new Rectangle(i.getBounds().x, i.getBounds().y, i.getBounds().width, 25);
        g.drawImage(i, src, rec);
        int x = rec.x + 5;
        int y = rec.getCenter().y;
        g.setFont(this.getFont(figure));
        g.setForegroundColor(this.getTextColor());
        g.drawString(this.getLabel(), x, y -= this.getTextExtents((IFigure)figure).height / 2);
        FigureUtilities.paintEtchedBorder((Graphics)g, (Rectangle)tempRect);
    }

    private Image getBGImage() {
        return ImagesUtils.getImage(this.imageKey);
    }

    public Color getTextColor() {
        return ColorConstants.TITLETEXT;
    }
}

