/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.ILink;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.property.DialogEditableObject;
import aurora.ide.meta.gef.editors.property.PropertySourceUtil;
import aurora.ide.meta.gef.i18n.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonClicker
extends AuroraComponent
implements DialogEditableObject,
ILink {
    private static final long serialVersionUID = 1177281488586303137L;
    public static final String DEFAULT = "";
    public static final String B_SEARCH = "query";
    public static final String B_RESET = "reset";
    public static final String B_SAVE = "save";
    public static final String B_CLOSE = "close";
    public static final String B_OPEN = "open";
    public static final String B_CUSTOM = "custom";
    public static final String[] action_ids = new String[]{"query", "reset", "save", "open", "close", "custom"};
    public static final String[] action_texts = new String[]{Messages.ButtonClicker_Query, Messages.ButtonClicker_Reset, Messages.ButtonClicker_Save, Messages.ButtonClicker_Open, Messages.ButtonClicker_Close, Messages.ButtonClicker_Custom};
    private String actionID = "";
    private String openPath;
    private List<Parameter> paras = new ArrayList<Parameter>();
    private String closeWindowID;
    private String function;
    private Button button;
    private AuroraComponent targetComponent;

    public AuroraComponent getTargetComponent() {
        return this.targetComponent;
    }

    public void setTargetComponent(AuroraComponent targetComponent) {
        this.targetComponent = targetComponent;
    }

    public String getActionID() {
        return this.actionID;
    }

    public void setActionID(String actionID) {
        this.actionID = actionID;
    }

    public String getActionText() {
        int i = 0;
        while (i < action_ids.length) {
            if (action_ids[i].equals(this.actionID)) {
                return action_texts[i];
            }
            ++i;
        }
        return DEFAULT;
    }

    @Override
    public String getOpenPath() {
        return this.openPath;
    }

    @Override
    public void setOpenPath(String openPath) {
        this.openPath = openPath;
    }

    public String getCloseWindowID() {
        return this.closeWindowID;
    }

    public void setCloseWindowID(String closeWindowID) {
        this.closeWindowID = closeWindowID;
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String func) {
        this.function = func;
    }

    @Override
    public String getDescripition() {
        return this.getActionText();
    }

    @Override
    public Object getContextInfo() {
        return this.button;
    }

    public Button getButton() {
        return this.button;
    }

    public void setButton(Button button) {
        this.button = button;
    }

    @Override
    public ButtonClicker clone() {
        ButtonClicker bc = new ButtonClicker();
        bc.actionID = this.actionID;
        bc.button = this.button;
        bc.closeWindowID = this.closeWindowID;
        bc.openPath = this.openPath;
        bc.paras = new ArrayList<Parameter>();
        for (Parameter p : this.paras) {
            bc.paras.add(p.clone());
        }
        bc.function = this.function;
        bc.targetComponent = this.targetComponent;
        return bc;
    }

    @Override
    public Image getDisplayImage() {
        if (this.targetComponent != null && (B_SEARCH.equals(this.actionID) || B_SAVE.equals(this.actionID) || B_RESET.equals(this.actionID))) {
            return PropertySourceUtil.getImageOf(this.targetComponent);
        }
        return null;
    }

    @Override
    public Object getEditableValue() {
        return null;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.paras;
    }

    @Override
    public void addParameter(Parameter para) {
        this.paras.add(para);
    }
}

