/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.DatasetField;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.property.StringPropertyDescriptor;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class CheckBox
extends Input {
    private static final long serialVersionUID = 319077599101372088L;
    public static final String TEXT = "text";
    private String text = "text";
    public static final String CHECKBOX = "checkBox";
    public static final IPropertyDescriptor PD_TEXT = new StringPropertyDescriptor("text", "text");
    public static final IPropertyDescriptor PD_CHECKED_VALUE = new StringPropertyDescriptor("checkedValue", "*checkedValue");
    public static final IPropertyDescriptor PD_UNCHECKED_VALUE = new StringPropertyDescriptor("uncheckedValue", "*uncheckedValue");
    private static final IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_PROMPT, PD_NAME, PD_TEXT, DatasetField.PD_READONLY, DatasetField.PD_REQUIRED, PD_CHECKED_VALUE, PD_UNCHECKED_VALUE};

    public CheckBox() {
        this.setSize(new Dimension(120, 20));
        this.setType(CHECKBOX);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.eq(this.text, text)) {
            return;
        }
        String oldV = this.text;
        this.text = text;
        this.firePropertyChange(TEXT, oldV, text);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return pds;
    }

    public Object getPropertyValue(Object propName) {
        if (TEXT.equals(propName)) {
            return this.getText();
        }
        if ("uncheckedValue".equals(propName) || "checkedValue".equals(propName) || "defaultValue".equals(propName)) {
            return this.getDatasetField().getPropertyValue(propName);
        }
        return super.getPropertyValue(propName);
    }

    public void setPropertyValue(Object propName, Object val) {
        if (TEXT.equals(propName)) {
            this.setText((String)val);
        } else if ("uncheckedValue".equals(propName) || "checkedValue".equals(propName) || "defaultValue".equals(propName)) {
            this.getDatasetField().setPropertyValue(propName, val);
        } else {
            super.setPropertyValue(propName, val);
        }
    }

    public void setParent(Container part) {
        super.setParent(part);
        if (this.getDatasetField() != null) {
            this.getDatasetField().setDataset(DataSetFieldUtil.findDataset(this.getParent()));
        }
    }

    public void setDatasetField(DatasetField field) {
        field.setName(this.getName());
        field.setDataset(DataSetFieldUtil.findDataset(this.getParent()));
        field.setCheckedValue("Y");
        field.setUncheckedValue("N");
        field.setDefaultValue("N");
        super.setDatasetField(field);
    }
}

