/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.QueryContainer;
import aurora.ide.meta.gef.editors.property.ComboPropertyDescriptor;
import aurora.ide.meta.gef.editors.property.IntegerPropertyDescriptor;
import java.util.Arrays;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class ResultDataSet
extends Dataset {
    private static final long serialVersionUID = -4436804459187661221L;
    public static final String SELECT_NONE = "";
    public static final String SELECT_MULTI = "multiple";
    public static final String SELECT_SINGLE = "single";
    public static final String SELECTION_MODE = "selectionModel";
    private static final String[] selectionModes = new String[]{"", "multiple", "single"};
    private static final IPropertyDescriptor PD_SELECTION_MODE = new ComboPropertyDescriptor("selectionModel", "*SelectionModel", selectionModes);
    private QueryContainer queryContainer = new QueryContainer();
    public static final String QUERY_CONTAINER = "queryContainer";
    public static final int DEFAULT_PAGE_SIZE = 10;
    private int pageSize;
    private boolean selectable = false;
    private String selectionMode = "";
    public static final String PAGE_SIZE = "pageSize";
    public static final String SELECTABLE = "selectable";
    public static final String QUERY_DATASET = "queryDataSet";
    private AuroraComponent owner = null;
    private static final IPropertyDescriptor[] pds = new IPropertyDescriptor[]{PD_SELECTION_MODE, new IntegerPropertyDescriptor("pageSize", "*pageSize")};

    public ResultDataSet() {
        this.setUse4Query(false);
        this.setPageSize(10);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.mergePropertyDescriptor(super.getPropertyDescriptors(), pds);
    }

    public Object getPropertyValue(Object propName) {
        if (SELECTION_MODE.equals(propName)) {
            return Arrays.asList(selectionModes).indexOf(this.getSelectionMode());
        }
        if (PAGE_SIZE.equals(propName)) {
            return this.getPageSize();
        }
        if (SELECTABLE.equals(propName)) {
            return this.isSelectable();
        }
        if (QUERY_DATASET.equals(propName)) {
            return this.getQueryDataset();
        }
        if (QUERY_CONTAINER.equals(propName)) {
            return this.getQueryContainer();
        }
        return super.getPropertyValue(propName);
    }

    public void setPropertyValue(Object propName, Object val) {
        if (SELECTION_MODE.equals(propName)) {
            this.setSelectionMode(selectionModes[(Integer)val]);
        } else if (PAGE_SIZE.equals(propName)) {
            this.setPageSize((Integer)val);
        } else if (SELECTABLE.equals(propName)) {
            this.setSelectable((Boolean)val);
        } else if (!QUERY_DATASET.equals(propName)) {
            if (QUERY_CONTAINER.equals(propName)) {
                this.setQueryContainer((QueryContainer)val);
            } else {
                super.setPropertyValue(propName, val);
            }
        }
    }

    private String getQueryDataset() {
        if (this.queryContainer != null) {
            return this.queryContainer.getQueryDateset();
        }
        return SELECT_NONE;
    }

    public QueryContainer getQueryContainer() {
        return this.queryContainer;
    }

    public void setQueryContainer(QueryContainer queryContainer) {
        this.queryContainer = queryContainer;
    }

    public void setQueryContainer(Container container) {
        this.queryContainer.setTarget(container);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public String getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(String selectionMode) {
        this.selectionMode = selectionMode;
        this.setSelectable(!selectionMode.equals(SELECT_NONE));
    }

    public AuroraComponent getOwner() {
        return this.owner;
    }

    public void setOwner(AuroraComponent owner) {
        this.owner = owner;
        this.queryContainer.setOwner(owner);
    }
}

